/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.catalog;

import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import org.fusesource.ide.camel.model.Activator;
import org.fusesource.ide.camel.model.catalog.CamelModel;

public class CamelModelFactory {
    private static HashMap<String, CamelModel> supportedCamelModels;

    public static void initializeModels() {
        supportedCamelModels = new HashMap();
        Enumeration models = Activator.getDefault().getBundle().findEntries("catalogs", "*", false);
        while (models.hasMoreElements()) {
            URL model = (URL)models.nextElement();
            String version = model.getFile();
            if ((version = version.substring(version.indexOf("catalogs/") + "catalogs/".length())).endsWith("/")) {
                version = version.substring(0, version.length() - 1);
            }
            CamelModel m = new CamelModel(version);
            supportedCamelModels.put(version, m);
        }
    }

    public static List<String> getSupportedCamelVersions() {
        if (supportedCamelModels == null || supportedCamelModels.isEmpty()) {
            CamelModelFactory.initializeModels();
        }
        return Arrays.asList(supportedCamelModels.keySet().toArray(new String[supportedCamelModels.size()]));
    }

    public static CamelModel getModelForVersion(String camelVersion) {
        return supportedCamelModels.get(camelVersion);
    }

    public static String getLatestCamelVersion() {
        String latest = null;
        for (String v : supportedCamelModels.keySet()) {
            if (latest == null) {
                latest = v;
                continue;
            }
            if (v.compareTo(latest) <= 0) continue;
            latest = v;
        }
        if (latest != null) {
            return latest;
        }
        return supportedCamelModels.keySet().iterator().next();
    }
}

