/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.catalog;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.fusesource.ide.camel.model.Activator;
import org.fusesource.ide.camel.model.catalog.components.ComponentModel;
import org.fusesource.ide.camel.model.catalog.dataformats.DataFormatModel;
import org.fusesource.ide.camel.model.catalog.eips.EipModel;
import org.fusesource.ide.camel.model.catalog.languages.LanguageModel;

public class CamelModel {
    private String camelVersion;
    private ComponentModel componentModel;
    private DataFormatModel dataformatModel;
    private EipModel eipModel;
    private LanguageModel languageModel;

    public CamelModel(String camelVersion) {
        this.camelVersion = camelVersion;
    }

    public String getCamelVersion() {
        return this.camelVersion;
    }

    public ComponentModel getComponentModel() {
        if (this.componentModel == null) {
            this.initialize();
        }
        return this.componentModel;
    }

    public DataFormatModel getDataformatModel() {
        if (this.dataformatModel == null) {
            this.initialize();
        }
        return this.dataformatModel;
    }

    public EipModel getEipModel() {
        if (this.eipModel == null) {
            this.initialize();
        }
        return this.eipModel;
    }

    public LanguageModel getLanguageModel() {
        if (this.languageModel == null) {
            this.initialize();
        }
        return this.languageModel;
    }

    private synchronized void initialize() {
        Enumeration models = Activator.getDefault().getBundle().findEntries("catalogs/" + this.camelVersion, "*.xml", false);
        while (models.hasMoreElements()) {
            URL model = (URL)models.nextElement();
            String fileName = model.getFile();
            try {
                if (fileName.endsWith("/components.xml")) {
                    this.componentModel = ComponentModel.getFactoryInstance(model.openStream(), this);
                    continue;
                }
                if (fileName.endsWith("/dataformats.xml")) {
                    this.dataformatModel = DataFormatModel.getFactoryInstance(model.openStream(), this);
                    continue;
                }
                if (fileName.endsWith("/languages.xml")) {
                    this.languageModel = LanguageModel.getFactoryInstance(model.openStream(), this);
                    continue;
                }
                if (fileName.endsWith("/eips.xml")) {
                    this.eipModel = EipModel.getFactoryInstance(model.openStream(), this);
                    continue;
                }
                Activator.getLogger().debug("Unknown catalog model file: " + fileName);
            }
            catch (IOException ex) {
                Activator.getLogger().error((Throwable)ex);
            }
        }
    }
}

