/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.fuse.core.bean;

import java.io.File;
import org.jboss.ide.eclipse.as.core.server.bean.AbstractCondition;
import org.jboss.ide.eclipse.as.core.server.bean.ICondition;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanType;

public class ServerBeanTypeFuse6x
extends ServerBeanType {
    protected static final String FUSE6x_RELEASE_VERSION = "Bundle-Version";
    public static final String V6_0 = "6.0";
    public static final String V6_1 = "6.1";
    public static final String V6_2 = "6.2";
    public static final String V6_x = "6.";

    protected ServerBeanTypeFuse6x() {
        super("FUSE6x", "JBoss Fuse 6.x", "lib" + File.separator + "esb-version.jar", (ICondition)new Fuse6xServerTypeCondition());
    }

    public static class Fuse6xServerTypeCondition
    extends AbstractCondition {
        public boolean isServerRoot(File location) {
            return Fuse6xServerTypeCondition.checkFuseVersion(location, ServerBeanTypeFuse6x.FUSE6x_RELEASE_VERSION, ServerBeanTypeFuse6x.V6_x);
        }

        protected static boolean checkFuseVersion(File location, String property, String propPrefix) {
            String mainFolder = new ServerBeanTypeFuse6x().getSystemJarPath();
            String value = ServerBeanTypeFuse6x.getJarProperty((File)new File(location + File.separator + mainFolder), (String)property);
            return value != null && value.startsWith(propPrefix);
        }

        public String getServerTypeId(String version) {
            if (version.equals(ServerBeanTypeFuse6x.V6_0)) {
                return "org.fusesource.ide.fuseesb.server.60";
            }
            if (version.equals(ServerBeanTypeFuse6x.V6_1)) {
                return "org.fusesource.ide.fuseesb.server.61";
            }
            if (version.equals(ServerBeanTypeFuse6x.V6_2)) {
                return "org.fusesource.ide.fuseesb.server.62";
            }
            if (version.startsWith(ServerBeanTypeFuse6x.V6_x)) {
                return "org.fusesource.ide.fuseesb.server.62";
            }
            return null;
        }
    }
}

