/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.modeshape.rest.Activator;
import org.jboss.tools.modeshape.rest.RestClientI18n;
import org.jboss.tools.modeshape.rest.domain.ModeShapeWorkspace;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;

public final class AddPublishAreaDialog
extends MessageDialog {
    private Button btnOk;
    private String publishArea;
    private final ModeShapeWorkspace workspace;

    public AddPublishAreaDialog(Shell parentShell, ModeShapeWorkspace workspace) {
        super(parentShell, RestClientI18n.addPublishAreaDialogTitle, Activator.getDefault().getImage("icons/views/modeShape_icon_16x.png"), RestClientI18n.addPublishAreaDialogMessage, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        CheckArg.isNotNull((Object)workspace, (String)"workspace");
        this.workspace = workspace;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button btn = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.btnOk = btn;
            this.btnOk.setEnabled(false);
        }
        return btn;
    }

    protected Control createCustomArea(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout(2, false));
        panel.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lbl = new Label(panel, 0);
        lbl.setText(NLS.bind((String)RestClientI18n.workspacePath, (Object)this.workspace.getRepository().getName(), (Object)this.workspace.getName()));
        final Text txt = new Text(panel, 2048);
        txt.setLayoutData((Object)new GridData(4, 4, true, true));
        txt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddPublishAreaDialog.this.handlePublishAreaChanged(txt.getText());
            }
        });
        return panel;
    }

    void handlePublishAreaChanged(String newPublishArea) {
        boolean enable;
        this.publishArea = newPublishArea;
        boolean bl = enable = !StringUtil.isBlank((String)newPublishArea);
        if (this.btnOk.getEnabled() != enable) {
            this.btnOk.setEnabled(enable);
        }
    }

    public String publishArea() {
        return this.publishArea;
    }
}

