/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.jboss.tools.modeshape.rest.Activator;
import org.jboss.tools.modeshape.rest.RestClientI18n;
import org.jboss.tools.modeshape.rest.ServerManager;
import org.jboss.tools.modeshape.rest.dialogs.DeleteServerDialog;
import org.jboss.tools.modeshape.rest.domain.ModeShapeServer;
import org.modeshape.web.jcr.rest.client.Status;

public final class DeleteServerAction
extends BaseSelectionListenerAction {
    private final ServerManager serverManager;
    private final List<ModeShapeServer> serversToDelete;
    private final Shell shell;

    public DeleteServerAction(Shell shell, ServerManager serverManager) {
        super(RestClientI18n.deleteServerActionText);
        this.setToolTipText(RestClientI18n.deleteServerActionToolTip);
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/views/delete_server.gif"));
        this.setEnabled(false);
        this.serversToDelete = new ArrayList<ModeShapeServer>(5);
        this.shell = shell;
        this.serverManager = serverManager;
    }

    public void run() {
        DeleteServerDialog dialog = new DeleteServerDialog(this.shell, this.serversToDelete);
        if (dialog.open() == 0) {
            boolean errorsOccurred = false;
            for (ModeShapeServer server : this.serversToDelete) {
                Status status = this.serverManager.removeServer(server);
                if (status.isOk()) continue;
                Activator.getDefault().log(status);
                if (!status.isError()) continue;
                errorsOccurred = true;
            }
            if (errorsOccurred) {
                MessageDialog.openError((Shell)this.shell, (String)RestClientI18n.errorDialogTitle, (String)RestClientI18n.deleteServerDialogErrorsOccurredMsg);
            }
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.serversToDelete.clear();
        if (selection.isEmpty()) {
            return false;
        }
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (!(obj instanceof ModeShapeServer)) {
                this.serversToDelete.clear();
                return false;
            }
            this.serversToDelete.add((ModeShapeServer)obj);
            ++n2;
        }
        return true;
    }
}

