/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.modeshape.rest.Activator;
import org.jboss.tools.modeshape.rest.IServerRegistryListener;
import org.jboss.tools.modeshape.rest.RestClientI18n;
import org.jboss.tools.modeshape.rest.ServerRegistryEvent;
import org.jboss.tools.modeshape.rest.domain.ModeShapeRepository;
import org.jboss.tools.modeshape.rest.domain.ModeShapeServer;
import org.jboss.tools.modeshape.rest.domain.ModeShapeWorkspace;
import org.jboss.tools.modeshape.rest.domain.WorkspaceArea;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.Base64;
import org.modeshape.common.util.CheckArg;
import org.modeshape.web.jcr.rest.client.IRestClient;
import org.modeshape.web.jcr.rest.client.Status;
import org.modeshape.web.jcr.rest.client.domain.QueryRow;
import org.modeshape.web.jcr.rest.client.domain.Repository;
import org.modeshape.web.jcr.rest.client.domain.Workspace;
import org.modeshape.web.jcr.rest.client.json.JsonRestClient;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@ThreadSafe
public final class ServerManager {
    private static final String PASSWORD_TAG = "password";
    private static final String REGISTRY_FILE = "serverRegistry.xml";
    public static final String SERVER_EXISTS_PROPERTY = "org.jboss.tools.modeshape.rest.serverExists";
    private static final String SERVER_TAG = "server";
    private static final String SERVERS_TAG = "servers";
    private static final String URL_TAG = "url";
    private static final String USER_TAG = "user";
    private final CopyOnWriteArrayList<IServerRegistryListener> listeners;
    private final IRestClient delegate;
    private final String stateLocationPath;
    private final List<ModeShapeServer> servers;
    private final ReadWriteLock serverLock = new ReentrantReadWriteLock();

    public ServerManager(String stateLocationPath, IRestClient restClient) {
        CheckArg.isNotNull((Object)restClient, (String)"restClient");
        this.servers = new ArrayList<ModeShapeServer>();
        this.stateLocationPath = stateLocationPath;
        this.delegate = restClient;
        this.listeners = new CopyOnWriteArrayList();
    }

    public ServerManager(String stateLocationPath) {
        this(stateLocationPath, (IRestClient)new JsonRestClient());
    }

    public boolean addRegistryListener(IServerRegistryListener listener) {
        CheckArg.isNotNull((Object)listener, (String)"listener");
        boolean result = this.listeners.addIfAbsent(listener);
        for (ModeShapeServer server : this.getServers()) {
            listener.serverRegistryChanged(ServerRegistryEvent.createNewEvent(this, server));
        }
        return result;
    }

    public org.modeshape.web.jcr.rest.client.Status addServer(ModeShapeServer server) {
        CheckArg.isNotNull((Object)server, (String)SERVER_TAG);
        return this.internalAddServer(server, true);
    }

    public ModeShapeServer findServer(String url, String user) {
        CheckArg.isNotNull((Object)url, (String)URL_TAG);
        CheckArg.isNotNull((Object)user, (String)USER_TAG);
        for (ModeShapeServer server : this.getServers()) {
            if (!url.equals(server.getOriginalUrl()) || !user.equals(server.getUser())) continue;
            return server;
        }
        return null;
    }

    public Collection<ModeShapeServer> getServers() {
        try {
            this.serverLock.readLock().lock();
            Collection<ModeShapeServer> collection = Collections.unmodifiableCollection(new ArrayList<ModeShapeServer>(this.servers));
            return collection;
        }
        finally {
            this.serverLock.readLock().unlock();
        }
    }

    private String getStateFileName() {
        String name = this.stateLocationPath;
        if (this.stateLocationPath != null) {
            name = String.valueOf(name) + File.separatorChar + REGISTRY_FILE;
        }
        return name;
    }

    public Collection<ModeShapeRepository> getRepositories(ModeShapeServer server) throws Exception {
        CheckArg.isNotNull((Object)server, (String)SERVER_TAG);
        try {
            this.serverLock.readLock().lock();
            if (this.isRegistered(server)) {
                Collection repositories = this.delegate.getRepositories(server.getDelegate());
                ArrayList<ModeShapeRepository> result = new ArrayList<ModeShapeRepository>(repositories.size());
                for (Repository repository : repositories) {
                    result.add(new ModeShapeRepository(repository, server));
                }
                Collection<ModeShapeRepository> collection = Collections.unmodifiableCollection(result);
                return collection;
            }
            throw new RuntimeException(NLS.bind((String)RestClientI18n.serverManagerUnregisteredServer, (Object)server.getShortDescription()));
        }
        finally {
            this.serverLock.readLock().unlock();
        }
    }

    public URL getUrl(File file, String path, ModeShapeWorkspace workspace) throws Exception {
        return this.delegate.getUrl(file, path, workspace.getDelegate());
    }

    public WorkspaceArea[] getWorkspaceAreas(ModeShapeWorkspace workspace) throws Exception {
        List rows = this.delegate.query(workspace.getDelegate(), "JCR-SQL2", "SELECT [jcr:path], [jcr:title] FROM [mode:publishArea]");
        WorkspaceArea[] workspaceAreas = new WorkspaceArea[rows.size()];
        int numRows = rows.size();
        int i = 0;
        while (i < numRows) {
            QueryRow row = (QueryRow)rows.get(i);
            workspaceAreas[i] = new WorkspaceArea(workspace, (String)row.getValue("jcr:path"), (String)row.getValue("jcr:title"));
            ++i;
        }
        return workspaceAreas;
    }

    public Collection<ModeShapeWorkspace> getWorkspaces(ModeShapeRepository repository) throws Exception {
        CheckArg.isNotNull((Object)repository, (String)"repository");
        try {
            this.serverLock.readLock().lock();
            if (this.isRegistered(repository.getServer())) {
                Collection workspaces = this.delegate.getWorkspaces(repository.getDelegate());
                ArrayList<ModeShapeWorkspace> result = new ArrayList<ModeShapeWorkspace>(workspaces.size());
                for (Workspace workspace : workspaces) {
                    result.add(new ModeShapeWorkspace(workspace, repository));
                }
                Collection<ModeShapeWorkspace> collection = Collections.unmodifiableCollection(result);
                return collection;
            }
            String msg = NLS.bind((String)RestClientI18n.serverManagerUnregisteredServer, (Object)repository.getServer().getShortDescription());
            throw new RuntimeException(msg);
        }
        finally {
            this.serverLock.readLock().unlock();
        }
    }

    private org.modeshape.web.jcr.rest.client.Status internalAddServer(ModeShapeServer server, boolean notifyListeners) {
        boolean added = false;
        try {
            this.serverLock.writeLock().lock();
            if (!this.isRegistered(server)) {
                added = this.servers.add(server);
            }
        }
        finally {
            this.serverLock.writeLock().unlock();
        }
        if (added) {
            String serverExists = System.getProperty(SERVER_EXISTS_PROPERTY);
            if (serverExists == null) {
                System.setProperty(SERVER_EXISTS_PROPERTY, "true");
            }
            if (notifyListeners) {
                Exception[] errors = this.notifyRegistryListeners(ServerRegistryEvent.createNewEvent(this, server));
                return this.processRegistryListenerErrors(errors);
            }
            return org.modeshape.web.jcr.rest.client.Status.OK_STATUS;
        }
        return new org.modeshape.web.jcr.rest.client.Status(Status.Severity.ERROR, NLS.bind((String)RestClientI18n.serverExistsMsg, (Object)server.getShortDescription()), null);
    }

    private org.modeshape.web.jcr.rest.client.Status internalRemoveServer(ModeShapeServer server, boolean notifyListeners) {
        boolean removed = false;
        try {
            this.serverLock.writeLock().lock();
            for (ModeShapeServer registeredServer : this.servers) {
                if (!registeredServer.hasSameKey(server)) continue;
                removed = this.servers.remove(registeredServer);
                break;
            }
        }
        finally {
            this.serverLock.writeLock().unlock();
        }
        if (removed) {
            if (this.getServers().isEmpty()) {
                System.clearProperty(SERVER_EXISTS_PROPERTY);
            }
            if (notifyListeners) {
                Exception[] errors = this.notifyRegistryListeners(ServerRegistryEvent.createRemoveEvent(this, server));
                return this.processRegistryListenerErrors(errors);
            }
            return org.modeshape.web.jcr.rest.client.Status.OK_STATUS;
        }
        return new org.modeshape.web.jcr.rest.client.Status(Status.Severity.ERROR, NLS.bind((String)RestClientI18n.serverManagerRegistryRemoveUnexpectedError, (Object)server.getShortDescription()), null);
    }

    public boolean isRegistered(ModeShapeServer server) {
        CheckArg.isNotNull((Object)server, (String)SERVER_TAG);
        try {
            this.serverLock.readLock().lock();
            for (ModeShapeServer registeredServer : this.servers) {
                if (!registeredServer.hasSameKey(server)) continue;
                return true;
            }
            return false;
        }
        finally {
            this.serverLock.readLock().unlock();
        }
    }

    public org.modeshape.web.jcr.rest.client.Status markAsPublishArea(ModeShapeWorkspace workspace, String path) throws Exception {
        CheckArg.isNotNull((Object)workspace, (String)"workspace");
        CheckArg.isNotEmpty((String)path, (String)"path");
        return this.delegate.markAsPublishArea(workspace.getDelegate(), path, null, null);
    }

    private Exception[] notifyRegistryListeners(ServerRegistryEvent event) {
        ArrayList<Exception> errors = null;
        for (IServerRegistryListener l : this.listeners) {
            try {
                Exception[] problems = l.serverRegistryChanged(event);
                if (problems == null || problems.length == 0) continue;
                if (errors == null) {
                    errors = new ArrayList();
                }
                errors.addAll(Arrays.asList(problems));
            }
            catch (Exception e) {
                if (errors == null) {
                    errors = new ArrayList<Exception>();
                }
                errors.add(e);
            }
        }
        if (errors != null && !errors.isEmpty()) {
            return errors.toArray(new Exception[errors.size()]);
        }
        return null;
    }

    private org.modeshape.web.jcr.rest.client.Status processRegistryListenerErrors(Exception[] errors) {
        if (errors == null) {
            return org.modeshape.web.jcr.rest.client.Status.OK_STATUS;
        }
        ILog logger = Activator.getDefault().getLog();
        Exception[] exceptionArray = errors;
        int n = errors.length;
        int n2 = 0;
        while (n2 < n) {
            Exception error = exceptionArray[n2];
            logger.log((IStatus)new Status(4, "org.jboss.tools.modeshape.rest", RestClientI18n.serverManagerRegistryListenerError, (Throwable)error));
            ++n2;
        }
        return new org.modeshape.web.jcr.rest.client.Status(Status.Severity.WARNING, RestClientI18n.serverManagerRegistryListenerErrorsOccurred, null);
    }

    public org.modeshape.web.jcr.rest.client.Status ping(ModeShapeServer server) {
        CheckArg.isNotNull((Object)server, (String)SERVER_TAG);
        try {
            this.delegate.getRepositories(server.getDelegate());
            return new org.modeshape.web.jcr.rest.client.Status(Status.Severity.OK, RestClientI18n.serverManagerConnectionEstablishedMsg, null);
        }
        catch (Exception e) {
            return new org.modeshape.web.jcr.rest.client.Status(Status.Severity.ERROR, NLS.bind((String)RestClientI18n.serverManagerConnectionFailedMsg, (Object)e), null);
        }
    }

    public org.modeshape.web.jcr.rest.client.Status publish(ModeShapeWorkspace workspace, String path, File file, boolean version) {
        CheckArg.isNotNull((Object)workspace, (String)"workspace");
        CheckArg.isNotNull((Object)path, (String)"path");
        CheckArg.isNotNull((Object)file, (String)"file");
        ModeShapeServer server = workspace.getServer();
        if (this.isRegistered(server)) {
            try {
                if (version) {
                    return this.delegate.publish(workspace.getDelegate(), path, file, true);
                }
                return this.delegate.publish(workspace.getDelegate(), path, file);
            }
            catch (Exception error) {
                return new org.modeshape.web.jcr.rest.client.Status(Status.Severity.ERROR, NLS.bind((String)RestClientI18n.serverValidationError, (Object)server.getOriginalUrl()), (Throwable)error);
            }
        }
        throw new RuntimeException(NLS.bind((String)RestClientI18n.serverManagerUnregisteredServer, (Object)server.getShortDescription()));
    }

    public boolean removeRegistryListener(IServerRegistryListener listener) {
        CheckArg.isNotNull((Object)listener, (String)"listener");
        return this.listeners.remove(listener);
    }

    public org.modeshape.web.jcr.rest.client.Status removeServer(ModeShapeServer server) {
        CheckArg.isNotNull((Object)server, (String)SERVER_TAG);
        return this.internalRemoveServer(server, true);
    }

    public org.modeshape.web.jcr.rest.client.Status restoreState() {
        if (this.stateLocationPath != null && this.stateFileExists()) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = factory.newDocumentBuilder();
                Document doc = docBuilder.parse(new File(this.getStateFileName()));
                Element root = doc.getDocumentElement();
                NodeList servers = root.getChildNodes();
                int size = servers.getLength();
                int i = 0;
                while (i < size) {
                    NamedNodeMap attributeMap;
                    Node server = servers.item(i);
                    if (server.getNodeType() != 3 && (attributeMap = server.getAttributes()) != null) {
                        Node urlNode = attributeMap.getNamedItem(URL_TAG);
                        Node userNode = attributeMap.getNamedItem(USER_TAG);
                        Node passwordNode = attributeMap.getNamedItem(PASSWORD_TAG);
                        String pswd = passwordNode == null ? null : new String(Base64.decode((String)passwordNode.getNodeValue()), "UTF-8");
                        this.addServer(new ModeShapeServer(urlNode.getNodeValue(), userNode.getNodeValue(), pswd, pswd != null));
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                return new org.modeshape.web.jcr.rest.client.Status(Status.Severity.ERROR, NLS.bind((String)RestClientI18n.errorRestoringServerRegistry, (Object)this.getStateFileName()), (Throwable)e);
            }
        }
        return org.modeshape.web.jcr.rest.client.Status.OK_STATUS;
    }

    public org.modeshape.web.jcr.rest.client.Status saveState() {
        if (this.stateLocationPath != null && !this.getServers().isEmpty()) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = factory.newDocumentBuilder();
                Document doc = docBuilder.newDocument();
                Element root = doc.createElement(SERVERS_TAG);
                doc.appendChild(root);
                for (ModeShapeServer server : this.getServers()) {
                    Element serverElement = doc.createElement(SERVER_TAG);
                    root.appendChild(serverElement);
                    serverElement.setAttribute(URL_TAG, server.getOriginalUrl());
                    serverElement.setAttribute(USER_TAG, server.getUser());
                    if (!server.isPasswordBeingPersisted()) continue;
                    serverElement.setAttribute(PASSWORD_TAG, Base64.encodeBytes((byte[])server.getPassword().getBytes()));
                }
                DOMSource source = new DOMSource(doc);
                StreamResult resultXML = new StreamResult(new FileOutputStream(this.getStateFileName()));
                TransformerFactory transFactory = TransformerFactory.newInstance();
                Transformer transformer = transFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                transformer.transform(source, resultXML);
            }
            catch (Exception e) {
                return new org.modeshape.web.jcr.rest.client.Status(Status.Severity.ERROR, NLS.bind((String)RestClientI18n.errorSavingServerRegistry, (Object)this.getStateFileName()), (Throwable)e);
            }
        }
        if (this.stateLocationPath != null && this.stateFileExists()) {
            try {
                new File(this.getStateFileName()).delete();
            }
            catch (Exception e) {
                return new org.modeshape.web.jcr.rest.client.Status(Status.Severity.ERROR, NLS.bind((String)RestClientI18n.errorDeletingServerRegistryFile, (Object)this.getStateFileName()), (Throwable)e);
            }
        }
        return org.modeshape.web.jcr.rest.client.Status.OK_STATUS;
    }

    private boolean stateFileExists() {
        return new File(this.getStateFileName()).exists();
    }

    public org.modeshape.web.jcr.rest.client.Status unmarkAsPublishArea(WorkspaceArea publishArea) throws Exception {
        CheckArg.isNotNull((Object)publishArea, (String)"publishArea");
        return this.delegate.unmarkAsPublishArea(publishArea.getWorkspace().getDelegate(), publishArea.getName());
    }

    public org.modeshape.web.jcr.rest.client.Status unpublish(ModeShapeWorkspace workspace, String path, File file) {
        CheckArg.isNotNull((Object)workspace, (String)"workspace");
        CheckArg.isNotNull((Object)path, (String)"path");
        CheckArg.isNotNull((Object)file, (String)"file");
        ModeShapeServer server = workspace.getServer();
        if (this.isRegistered(server)) {
            try {
                return this.delegate.unpublish(workspace.getDelegate(), path, file);
            }
            catch (Exception error) {
                return new org.modeshape.web.jcr.rest.client.Status(Status.Severity.ERROR, NLS.bind((String)RestClientI18n.serverValidationError, (Object)server.getOriginalUrl()), (Throwable)error);
            }
        }
        throw new RuntimeException(NLS.bind((String)RestClientI18n.serverManagerUnregisteredServer, (Object)server.getShortDescription()));
    }

    public org.modeshape.web.jcr.rest.client.Status updateServer(ModeShapeServer previousServerVersion, ModeShapeServer newServerVersion) {
        CheckArg.isNotNull((Object)previousServerVersion, (String)"previousServerVersion");
        CheckArg.isNotNull((Object)newServerVersion, (String)"newServerVersion");
        org.modeshape.web.jcr.rest.client.Status status = null;
        try {
            this.serverLock.writeLock().lock();
            status = this.internalRemoveServer(previousServerVersion, false);
            if (status.isOk()) {
                status = this.internalAddServer(newServerVersion, false);
                if (status.isOk()) {
                    Exception[] errors = this.notifyRegistryListeners(ServerRegistryEvent.createUpdateEvent(this, previousServerVersion, newServerVersion));
                    org.modeshape.web.jcr.rest.client.Status status2 = this.processRegistryListenerErrors(errors);
                    return status2;
                }
                org.modeshape.web.jcr.rest.client.Status status3 = new org.modeshape.web.jcr.rest.client.Status(Status.Severity.ERROR, NLS.bind((String)RestClientI18n.serverManagerRegistryUpdateAddError, (Object)status.getMessage()), status.getException());
                return status3;
            }
        }
        finally {
            this.serverLock.writeLock().unlock();
        }
        return new org.modeshape.web.jcr.rest.client.Status(Status.Severity.ERROR, NLS.bind((String)RestClientI18n.serverManagerRegistryUpdateRemoveError, (Object)status.getMessage()), status.getException());
    }
}

