/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.activemq.navigator;

import io.fabric8.activemq.facade.BrokerFacade;
import io.fabric8.activemq.facade.ProducerViewFacade;
import java.util.Collection;
import org.apache.activemq.broker.jmx.ProducerViewMBean;
import org.eclipse.swt.graphics.Image;
import org.fusesource.ide.commons.tree.RefreshableCollectionNode;
import org.fusesource.ide.jmx.activemq.ActiveMQJMXPlugin;
import org.fusesource.ide.jmx.activemq.navigator.BrokerNode;
import org.fusesource.ide.jmx.activemq.navigator.ProducerNode;
import org.fusesource.ide.jmx.activemq.navigator.QueueNode;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class QueueProducersNode
extends RefreshableCollectionNode
implements ImageProvider {
    private final BrokerNode brokerNode;
    private final BrokerFacade facade;
    private final QueueNode queueNode;

    public QueueProducersNode(QueueNode queueNode) {
        super((Node)queueNode);
        this.queueNode = queueNode;
        this.brokerNode = queueNode.getBrokerNode();
        this.facade = queueNode.getFacade();
    }

    public String toString() {
        return "Producers";
    }

    protected void loadChildren() {
        try {
            String name = this.queueNode.getName();
            Collection list = this.getFacade().getQueueProducers(name);
            if (list != null) {
                for (ProducerViewFacade mbean : list) {
                    this.addChild((Node)new ProducerNode((Node)this, (Node)this.queueNode, (ProducerViewMBean)mbean));
                }
            }
        }
        catch (Exception e) {
            this.brokerNode.handleException((Node)this, e);
        }
    }

    public void refresh() {
        this.getBrokerNode().refresh();
    }

    public BrokerNode getBrokerNode() {
        return this.brokerNode;
    }

    public Image getImage() {
        return ActiveMQJMXPlugin.getDefault().getImage("listeners.gif");
    }

    protected BrokerFacade getFacade() {
        return this.getBrokerNode().getFacade();
    }
}

