/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.xml.aspects.validation.rules;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.xml.XmlDocumentNode;
import org.teiid.designer.metamodels.xml.XmlDocumentPlugin;
import org.teiid.designer.metamodels.xsd.XsdUtil;

public class XmlDocumentNodeDatatypeRule
implements ObjectValidationRule {
    public void validate(EObject eObject, ValidationContext context) {
        if (eObject == null || !(eObject instanceof XmlDocumentNode)) {
            return;
        }
        XSDComponent xsdComponent = ((XmlDocumentNode)eObject).getXsdComponent();
        if (xsdComponent == null) {
            return;
        }
        XSDTypeDefinition typeDefn = XsdUtil.getType((XSDComponent)xsdComponent);
        if (typeDefn != null && typeDefn.eIsProxy() && eObject.eResource() != null && (typeDefn = (XSDTypeDefinition)EcoreUtil.resolve((EObject)typeDefn, (ResourceSet)eObject.eResource().getResourceSet())) == null) {
            Object[] params = new Object[]{((XmlDocumentNode)eObject).getName(), ((InternalEObject)XsdUtil.getType((XSDComponent)xsdComponent)).eProxyURI()};
            String msg = XmlDocumentPlugin.Util.getString("XmlDocumentNodeDatatypeRule.xml_doc_node_references_type_that_cannot_be_resolved", params);
            ValidationResultImpl result = new ValidationResultImpl((Object)eObject);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 2, msg);
            result.addProblem((ValidationProblem)problem);
            context.addResult((ValidationResult)result);
            return;
        }
        if (typeDefn instanceof XSDSimpleTypeDefinition) {
            XSDSimpleTypeDefinition simpleTypeDefn = (XSDSimpleTypeDefinition)typeDefn;
            DatatypeManager dtMgr = context.getDatatypeManager();
            if (!dtMgr.isEnterpriseDatatype((EObject)simpleTypeDefn)) {
                Object[] params = new Object[]{((XmlDocumentNode)eObject).getName()};
                String msg = XmlDocumentPlugin.Util.getString("XmlDocumentNodeDatatypeRule.xml_doc_node_must_reference_enterprise_datatype", params);
                ValidationResultImpl result = new ValidationResultImpl((Object)eObject);
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 2, msg);
                result.addProblem((ValidationProblem)problem);
                context.addResult((ValidationResult)result);
            }
        }
    }
}

