/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.mapping.PluginConstants;
import org.teiid.designer.mapping.factory.IMappableTree;
import org.teiid.designer.mapping.factory.ITreeToRelationalMapper;
import org.teiid.designer.mapping.factory.MappingClassBuilderStrategy;

public class IterationBasedBuilderStrategy
implements MappingClassBuilderStrategy {
    protected ITreeToRelationalMapper mapper;
    protected IMappableTree tree;

    @Override
    public Map buildMappingClassMap(EObject theTopNode, IMappableTree tree, ITreeToRelationalMapper mapper) {
        this.mapper = mapper;
        this.tree = tree;
        Map result = this.recursiveBuild(theTopNode, null, new HashMap());
        this.mapper = null;
        this.tree = null;
        return result;
    }

    protected Map recursiveBuild(EObject node, EObject currentMappingClassStorageNode, Map classAttributeMap) {
        if (this.mapper.isMappable(node)) {
            this.addAttributeToMap(node, currentMappingClassStorageNode, classAttributeMap);
        }
        for (EObject child : this.tree.getChildren(node)) {
            if (this.mapper.isMappable(child) && !this.mapper.allowsMappingClass(child)) {
                currentMappingClassStorageNode = this.addAttributeToMap(child, currentMappingClassStorageNode, classAttributeMap);
                continue;
            }
            if (this.shouldContainMappingClass(child)) {
                classAttributeMap.put(child, new ArrayList());
                this.recursiveBuild(child, child, classAttributeMap);
                continue;
            }
            this.recursiveBuild(child, currentMappingClassStorageNode, classAttributeMap);
        }
        return classAttributeMap;
    }

    protected boolean shouldContainMappingClass(EObject node) {
        boolean result = false;
        try {
            if (this.mapper.allowsMappingClass(node)) {
                if (this.mapper.canIterate(node)) {
                    result = true;
                } else if (this.mapper.isRecursive(node)) {
                    result = true;
                }
            }
        }
        catch (Exception e) {
            PluginConstants.Util.log((Throwable)e);
        }
        return result;
    }

    protected EObject addAttributeToMap(EObject node, EObject currentMappingClassStorageNode, Map classAttributeMap) {
        Collection<EObject> attributeNodes = null;
        if (currentMappingClassStorageNode == null) {
            EObject testNode = node;
            while (currentMappingClassStorageNode == null) {
                if (this.shouldContainMappingClass(testNode)) {
                    currentMappingClassStorageNode = testNode;
                    continue;
                }
                if (this.mapper.isTreeRoot(testNode)) {
                    currentMappingClassStorageNode = testNode;
                    continue;
                }
                EObject parent = this.tree.getParent(testNode);
                if (parent != null && parent == this.tree.getTreeRoot()) {
                    currentMappingClassStorageNode = testNode;
                    continue;
                }
                testNode = parent;
            }
        }
        if (!classAttributeMap.keySet().contains(currentMappingClassStorageNode)) {
            attributeNodes = new ArrayList();
            classAttributeMap.put(currentMappingClassStorageNode, attributeNodes);
        } else {
            attributeNodes = (Collection)classAttributeMap.get(currentMappingClassStorageNode);
        }
        attributeNodes.add(node);
        return currentMappingClassStorageNode;
    }
}

