/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.core.util;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.metamodels.core.CoreMetamodelPlugin;

public class UriValidator {
    static final String PREFIX = I18nUtil.getPropertyPrefix(UriValidator.class);
    private static final String URI_COMPONENTS_PREFIX = "uricomponents.";
    private static final String URI_LABEL = CoreMetamodelPlugin.Util.getString(String.valueOf(PREFIX) + "uri", new Object[0]);
    private static final int INVALID_FACTOR = -1;

    private static String createNullValueMessage(String theComponent) {
        return CoreMetamodelPlugin.Util.getString(String.valueOf(PREFIX) + "nullValue", (Object)theComponent);
    }

    private static IStatus createStatus(String theComponent, String theValue, boolean theIsValidFlag) {
        return new Status(UriValidator.getSeverity(theIsValidFlag), "org.teiid.designer.metamodels.core", UriValidator.getCode(theComponent, theIsValidFlag), UriValidator.createValidationMessage(theComponent, theValue, theIsValidFlag), null);
    }

    private static String createValidationMessage(String theComponent, String theValue, boolean theIsValidFlag) {
        if (theIsValidFlag) {
            return CoreMetamodelPlugin.Util.getString(String.valueOf(PREFIX) + "componentValid", new Object[]{theComponent, theValue});
        }
        return CoreMetamodelPlugin.Util.getString(String.valueOf(PREFIX) + "componentNotValid", new Object[]{theComponent, theValue});
    }

    private static int getCode(String theComponent, boolean theIsValidFlag) {
        int result = 1;
        if (URI_LABEL.equals(theComponent)) {
            result = 1;
        } else if (UriComponents.AUTHORITY.equals(theComponent)) {
            result = 10;
        } else if (UriComponents.DEVICE.equals(theComponent)) {
            result = 20;
        } else if (UriComponents.FRAGMENT.equals(theComponent)) {
            result = 30;
        } else if (UriComponents.JAR_AUTHORITY.equals(theComponent)) {
            result = 40;
        } else if (UriComponents.OPAQUE_PART.equals(theComponent)) {
            result = 50;
        } else if (UriComponents.QUERY.equals(theComponent)) {
            result = 60;
        } else if (UriComponents.SCHEME.equals(theComponent)) {
            result = 70;
        } else if (UriComponents.SEGMENT.equals(theComponent)) {
            result = 80;
        } else if (UriComponents.SEGMENTS.equals(theComponent)) {
            result = 90;
        }
        if (!theIsValidFlag) {
            result *= -1;
        }
        return result;
    }

    private static int getSeverity(boolean theIsValidFlag) {
        return theIsValidFlag ? 0 : 4;
    }

    public static boolean isValid(String theUri) {
        boolean result = false;
        if (CoreStringUtil.isEmpty((String)theUri)) {
            result = true;
        } else {
            try {
                URI.createURI((String)theUri);
                result = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return result;
    }

    public static IStatus validate(String theUri) {
        IStatus result = null;
        if (!CoreStringUtil.isEmpty((String)theUri)) {
            try {
                URI.createURI((String)theUri);
            }
            catch (IllegalArgumentException theException) {
                int code = -1;
                String uriMsg = theException.getMessage();
                String msg = null;
                if (uriMsg != null && uriMsg.length() > 0) {
                    String component = null;
                    if (uriMsg.indexOf("scheme") != -1) {
                        component = UriComponents.SCHEME;
                    } else if (uriMsg.indexOf("opaquePart") != -1) {
                        component = UriComponents.OPAQUE_PART;
                    } else if (uriMsg.indexOf("authority") != -1) {
                        component = CoreStringUtil.startsWithIgnoreCase((String)theUri, (String)"jar") ? UriComponents.JAR_AUTHORITY : UriComponents.AUTHORITY;
                    } else if (uriMsg.indexOf("device") != -1) {
                        component = UriComponents.DEVICE;
                    } else if (uriMsg.indexOf("segments") != -1) {
                        component = UriComponents.SEGMENTS;
                    } else if (uriMsg.indexOf("query") != -1) {
                        component = UriComponents.QUERY;
                    } else if (uriMsg.indexOf("fragment") != -1) {
                        component = UriComponents.FRAGMENT;
                    } else {
                        msg = uriMsg;
                    }
                    if (component != null) {
                        code = UriValidator.getCode(component, false);
                        msg = CoreMetamodelPlugin.Util.getString(String.valueOf(PREFIX) + "uriComponentInvalid", new Object[]{component, theUri});
                    }
                } else {
                    code = UriValidator.getCode(URI_LABEL, false);
                    msg = CoreMetamodelPlugin.Util.getString(String.valueOf(PREFIX) + "genericUriError", new Object[]{theUri});
                }
                result = new Status(UriValidator.getSeverity(false), "org.teiid.designer.metamodels.core", code, msg, null);
            }
        }
        if (result == null) {
            result = UriValidator.createStatus(URI_LABEL, theUri, true);
        }
        return result;
    }

    public static boolean isValidAuthority(String theAuthority) {
        return URI.validAuthority((String)theAuthority);
    }

    public static IStatus validateAuthority(String theAuthority) {
        return UriValidator.createStatus(UriComponents.AUTHORITY, theAuthority, UriValidator.isValidAuthority(theAuthority));
    }

    public static boolean isValidDevice(String theDevice) {
        return URI.validDevice((String)theDevice);
    }

    public static IStatus validateDevice(String theDevice) {
        return UriValidator.createStatus(UriComponents.DEVICE, theDevice, UriValidator.isValidDevice(theDevice));
    }

    public static boolean isValidFragment(String theFragment) {
        return URI.validFragment((String)theFragment);
    }

    public static IStatus validateFragment(String theFragment) {
        return UriValidator.createStatus(UriComponents.FRAGMENT, theFragment, UriValidator.isValidFragment(theFragment));
    }

    public static boolean isValidArchiveAuthority(String theArchiveAuthority) {
        return URI.validArchiveAuthority((String)theArchiveAuthority);
    }

    public static IStatus validateArchiveAuthority(String theArchiveAuthority) {
        return UriValidator.createStatus(UriComponents.JAR_AUTHORITY, theArchiveAuthority, UriValidator.isValidArchiveAuthority(theArchiveAuthority));
    }

    public static boolean isValidOpaquePart(String theOpaquePart) {
        return URI.validOpaquePart((String)theOpaquePart);
    }

    public static IStatus validateOpaquePart(String theOpaquePart) {
        return UriValidator.createStatus(UriComponents.OPAQUE_PART, theOpaquePart, UriValidator.isValidOpaquePart(theOpaquePart));
    }

    public static boolean isValidQuery(String theQuery) {
        return URI.validQuery((String)theQuery);
    }

    public static IStatus validateQuery(String theQuery) {
        return UriValidator.createStatus(UriComponents.QUERY, theQuery, UriValidator.isValidQuery(theQuery));
    }

    public static boolean isValidScheme(String theScheme) {
        return URI.validScheme((String)theScheme);
    }

    public static IStatus validateScheme(String theScheme) {
        return UriValidator.createStatus(UriComponents.SCHEME, theScheme, UriValidator.isValidScheme(theScheme));
    }

    public static boolean isValidSegment(String theSegment) {
        return URI.validSegment((String)theSegment);
    }

    public static IStatus validateSegment(String theSegment) {
        return UriValidator.createStatus(UriComponents.SEGMENT, theSegment, UriValidator.isValidSegment(theSegment));
    }

    public static boolean isValidSegments(String[] theSegments) throws AssertionError {
        CoreArgCheck.isNotNull((Object)theSegments, (String)UriValidator.createNullValueMessage(UriComponents.SEGMENTS));
        return URI.validSegments((String[])theSegments);
    }

    public static IStatus validateSegments(String[] theSegments) throws AssertionError {
        CoreArgCheck.isNotNull((Object)theSegments, (String)UriValidator.createNullValueMessage(UriComponents.SEGMENTS));
        IStatus result = null;
        int i = 0;
        while (i < theSegments.length) {
            boolean valid = UriValidator.isValidSegment(theSegments[i]);
            if (!valid) {
                result = UriValidator.createStatus(UriComponents.SEGMENTS, theSegments[i], false);
                break;
            }
            ++i;
        }
        if (result == null) {
            result = new Status(0, "org.teiid.designer.metamodels.core", 90, CoreMetamodelPlugin.Util.getString(String.valueOf(PREFIX) + "allsegmentsvalid", new Object[0]), null);
        }
        return result;
    }

    private UriValidator() {
    }

    public static interface StatusCodes {
        public static final int VALID_URI = 1;
        public static final int INVALID_URI = -1;
        public static final int VALID_AUTHORITY = 10;
        public static final int INVALID_AUTHORITY = -10;
        public static final int VALID_DEVICE = 20;
        public static final int INVALID_DEVICE = -20;
        public static final int VALID_FRAGMENT = 30;
        public static final int INVALID_FRAGMENT = -30;
        public static final int VALID_ARCHIVE_AUTHORITY = 40;
        public static final int INVALID_ARCHIVE_AUTHORITY = -40;
        public static final int VALID_OPAQUE_PART = 50;
        public static final int INVALID_OPAQUE_PART = -50;
        public static final int VALID_QUERY = 60;
        public static final int INVALID_QUERY = -60;
        public static final int VALID_SCHEME = 70;
        public static final int INVALID_SCHEME = -70;
        public static final int VALID_SEGMENT = 80;
        public static final int INVALID_SEGMENT = -80;
        public static final int VALID_SEGMENTS = 90;
        public static final int INVALID_SEGMENTS = -90;
    }

    public static interface UriComponents {
        public static final String AUTHORITY = CoreMetamodelPlugin.Util.getString(String.valueOf(PREFIX) + "uricomponents." + "authority", new Object[0]);
        public static final String DEVICE = CoreMetamodelPlugin.Util.getString(String.valueOf(PREFIX) + "uricomponents." + "device", new Object[0]);
        public static final String FRAGMENT = CoreMetamodelPlugin.Util.getString(String.valueOf(PREFIX) + "uricomponents." + "fragment", new Object[0]);
        public static final String JAR_AUTHORITY = CoreMetamodelPlugin.Util.getString(String.valueOf(PREFIX) + "uricomponents." + "jarauthority", new Object[0]);
        public static final String OPAQUE_PART = CoreMetamodelPlugin.Util.getString(String.valueOf(PREFIX) + "uricomponents." + "opaquepart", new Object[0]);
        public static final String QUERY = CoreMetamodelPlugin.Util.getString(String.valueOf(PREFIX) + "uricomponents." + "query", new Object[0]);
        public static final String SCHEME = CoreMetamodelPlugin.Util.getString(String.valueOf(PREFIX) + "uricomponents." + "scheme", new Object[0]);
        public static final String SEGMENT = CoreMetamodelPlugin.Util.getString(String.valueOf(PREFIX) + "uricomponents." + "segment", new Object[0]);
        public static final String SEGMENTS = CoreMetamodelPlugin.Util.getString(String.valueOf(PREFIX) + "uricomponents." + "multiplesegment", new Object[0]);
    }
}

