/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.xml.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import junit.framework.TestCase;
import org.jboss.tools.common.xml.XMLUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

public class XMLUtilitiesTest
extends TestCase {
    public static final String ELEMENT_NAME = "ElementName";

    public final void testCreateDocumentBuilder() {
        XMLUtilitiesTest.assertNotNull((String)"Element builder without validation wasn't created", (Object)XMLUtilities.createDocumentBuilder());
    }

    public final void testCreateDocumentElementString() {
        Element element = XMLUtilities.createDocumentElement((String)ELEMENT_NAME);
        XMLUtilitiesTest.assertNotNull((Object)element);
        XMLUtilitiesTest.assertTrue((boolean)element.getNodeName().equals(ELEMENT_NAME));
    }

    public void testCreateDocumentBuilderBoolean() {
        XMLUtilitiesTest.assertNotNull((String)"Element builder with validation wasn't created", (Object)XMLUtilities.createDocumentBuilder((boolean)true));
    }

    public void testGetDocumentReaderEntityResolver() throws IOException {
        XMLUtilitiesTest.assertNotNull((Object)XMLUtilitiesTest.getGoodDocument());
    }

    public void testHasAttributeElementString() {
        Element element = XMLUtilitiesTest.getGoodDocument().getDocumentElement();
        XMLUtilitiesTest.assertTrue((boolean)XMLUtilities.hasAttribute((Element)element, (String)"attribute1"));
    }

    public void testGetChildrenElementsElementString() {
        Element element = XMLUtilitiesTest.getGoodDocument().getDocumentElement();
        XMLUtilitiesTest.assertTrue((XMLUtilities.getChildren((Element)element, (String)"child1").length == 4 ? 1 : 0) != 0);
    }

    public void testGetUniqueChildElementString() {
        Element element = XMLUtilitiesTest.getGoodDocument().getDocumentElement();
        XMLUtilitiesTest.assertNotNull((Object)XMLUtilities.getUniqueChild((Element)element, (String)"child1"));
    }

    public void testGetChildrenElementString() {
        Element element = XMLUtilitiesTest.getGoodDocument().getDocumentElement();
        XMLUtilitiesTest.assertTrue((XMLUtilities.getChildren((Element)element, (String)"child1").length == 4 ? 1 : 0) != 0);
    }

    public void testGetFirstChildElementString() {
        Element element = XMLUtilitiesTest.getGoodDocument().getDocumentElement();
        Element first = XMLUtilities.getFirstChild((Element)element, (String)"child1");
        XMLUtilitiesTest.assertTrue((boolean)first.getAttribute("first").equals("true"));
        first = XMLUtilities.getFirstChild((Element)element, (String)"child2");
        XMLUtilitiesTest.assertTrue((boolean)first.getAttribute("first").equals("true"));
        first = XMLUtilities.getFirstChild((Element)element, (String)"child10");
        XMLUtilitiesTest.assertNull((Object)first);
    }

    public static final Document getGoodDocument() {
        Document document;
        InputStream in = null;
        try {
            in = XMLUtilitiesTest.class.getResourceAsStream("XMLUtilitiesTest1.xml");
            Document document2 = XMLUtilities.getDocument((Reader)new InputStreamReader(in), (EntityResolver)XMLUtilities.EMPTY_RESOLVER);
            XMLUtilitiesTest.assertNotNull((Object)document2);
            document = document2;
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        return document;
    }
}

