/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.model;

import java.util.Comparator;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.teiid.core.designer.HashCodeUtil;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.extension.RelationalModelExtensionConstants;
import org.teiid.designer.relational.Messages;
import org.teiid.designer.relational.RelationalConstants;

public class RelationalReference
implements RelationalConstants,
RelationalModelExtensionConstants.PropertyKeysNoPrefix {
    public static final String KEY_NAME = "NAME";
    public static final String KEY_NAME_IN_SOURCE = "NAMEINSOURCE";
    public static final String KEY_DESCRIPTION = "DESCRIPTION";
    public static final int IGNORE = -1;
    public static final int CREATE_ANYWAY = 0;
    public static final int REPLACE = 1;
    public static final int CREATE_UNIQUE_NAME = 2;
    private int type = -1;
    private RelationalReference parent;
    private String name;
    private String nameInSource;
    private String description;
    private int processType;
    private IStatus currentStatus;
    private boolean isChecked = true;
    private int modelType = ModelType.PHYSICAL;
    private Properties extensionProperties = new Properties();
    private StringNameValidator nameValidator = new StringNameValidator();

    public RelationalReference() {
        this.processType = 0;
        this.currentStatus = Status.OK_STATUS;
        this.isChecked = true;
    }

    public RelationalReference(String name) {
        this.name = name;
        this.processType = 0;
        this.isChecked = true;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void inject(RelationalReference obj) {
    }

    public RelationalReference getParent() {
        return this.parent;
    }

    public void setParent(RelationalReference parent) {
        this.parent = parent;
        this.handleInfoChanged();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (StringUtilities.areDifferent((String)this.name, (String)name)) {
            this.name = name;
            this.handleInfoChanged();
        }
    }

    public String getNameInSource() {
        return this.nameInSource;
    }

    public void setNameInSource(String nameInSource) {
        if (StringUtilities.areDifferent((String)this.nameInSource, (String)nameInSource)) {
            this.nameInSource = nameInSource;
            this.handleInfoChanged();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (StringUtilities.areDifferent((String)this.description, (String)description)) {
            this.description = description;
            this.handleInfoChanged();
        }
    }

    public int getModelType() {
        return this.modelType;
    }

    public void setModelType(int value) {
        this.modelType = value;
    }

    public int getType() {
        return this.type;
    }

    protected void setType(int type) {
        this.type = type;
    }

    public int getProcessType() {
        return this.processType;
    }

    public void setDoProcessType(int value) {
        this.processType = value;
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setChecked(boolean isChecked) {
        this.isChecked = isChecked;
    }

    public void setExtensionProperties(Properties extProps) {
        this.clearExtensionProperties();
        if (extProps != null) {
            Set<Object> propKeys = extProps.keySet();
            for (Object propKey : propKeys) {
                String strKey = (String)propKey;
                String strValue = extProps.getProperty(strKey);
                int index = strKey.indexOf(58);
                if (index != -1) {
                    strKey = strKey.substring(index + 1);
                }
                if (strKey == null || strKey.equalsIgnoreCase("Supports ID Lookup")) continue;
                this.addExtensionProperty(strKey, strValue);
            }
        }
    }

    public void addExtensionProperty(String propName, String propValue) {
        if (propName != null) {
            this.extensionProperties.put(propName, propValue);
        }
    }

    public void removeExtensionProperty(String propName) {
        this.extensionProperties.remove(propName);
    }

    public void clearExtensionProperties() {
        this.extensionProperties.clear();
    }

    public Properties getExtensionProperties() {
        return this.extensionProperties;
    }

    public String getDisplayName() {
        return TYPE_NAMES[this.getType()];
    }

    public void setStatus(IStatus status) {
        this.currentStatus = status;
    }

    public IStatus getStatus() {
        return this.currentStatus;
    }

    public StringNameValidator getNameValidator() {
        return this.nameValidator;
    }

    public void setNameValidator(StringNameValidator nameValidator) {
        CoreArgCheck.isNotNull((Object)nameValidator, (String)"nameValidator");
        this.nameValidator = nameValidator;
    }

    protected void handleInfoChanged() {
        this.validate();
    }

    public final boolean nameIsValid() {
        if (this.getName() == null || this.getName().length() == 0) {
            return false;
        }
        String errorMessage = this.getNameValidator().checkValidName(this.getName());
        return errorMessage == null || errorMessage.isEmpty();
    }

    public void validate() {
        if (this.getName() == null || this.getName().length() == 0) {
            this.setStatus((IStatus)new Status(4, "org.teiid.designer.relational", NLS.bind((String)Messages.validate_error_nameCannotBeNullOrEmpty, (Object)this.getDisplayName())));
            return;
        }
        String errorMessage = this.getNameValidator().checkValidName(this.getName());
        if (errorMessage != null && !errorMessage.isEmpty()) {
            this.setStatus((IStatus)new Status(4, "org.teiid.designer.relational", errorMessage));
            return;
        }
        this.setStatus(Status.OK_STATUS);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(" : name = ").append(this.getName());
        return sb.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RelationalReference other = (RelationalReference)object;
        if (!(CoreStringUtil.valuesAreEqual((String)this.getName(), (String)other.getName()) && CoreStringUtil.valuesAreEqual((String)this.getNameInSource(), (String)other.getNameInSource()) && CoreStringUtil.valuesAreEqual((String)this.getDescription(), (String)other.getDescription()))) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        if (this.getModelType() != other.getModelType()) {
            return false;
        }
        if (this.getProcessType() != other.getProcessType()) {
            return false;
        }
        return this.getExtensionProperties().equals(other.getExtensionProperties());
    }

    public int hashCode() {
        int result = HashCodeUtil.hashCode((int)0, (int)this.getType());
        result = HashCodeUtil.hashCode((int)result, (int)this.getType());
        result = HashCodeUtil.hashCode((int)result, (int)this.getModelType());
        result = HashCodeUtil.hashCode((int)result, (int)this.getProcessType());
        if (!CoreStringUtil.isEmpty((String)this.getName())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getName()});
        }
        if (!CoreStringUtil.isEmpty((String)this.getNameInSource())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getNameInSource()});
        }
        if (this.getDescription() != null && !this.getDescription().isEmpty()) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getDescription()});
        }
        if (this.extensionProperties != null && !this.extensionProperties.isEmpty()) {
            for (String string : this.extensionProperties.keySet()) {
                String value = this.extensionProperties.getProperty(string);
                result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{string});
                result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{value});
            }
        }
        return result;
    }

    public class ReferenceComparator
    implements Comparator<RelationalReference> {
        @Override
        public int compare(RelationalReference x, RelationalReference y) {
            RelationalReference xParent = x.getParent();
            RelationalReference yParent = y.getParent();
            if (xParent == null || yParent == null) {
                return x.getName().compareTo(y.getName());
            }
            int parentResult = xParent.getName().compareTo(yParent.getName());
            if (parentResult != 0) {
                return parentResult;
            }
            return x.getName().compareTo(y.getName());
        }
    }
}

