/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.teiid.core.designer.HashCodeUtil;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.metamodels.relational.aspects.validation.RelationalStringNameValidator;
import org.teiid.designer.relational.Messages;
import org.teiid.designer.relational.model.RelationalColumn;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.model.RelationalTable;

public class RelationalIndex
extends RelationalReference {
    public static final String KEY_AUTO_UPDATE = "AUTOUPDATE";
    public static final String KEY_FILTER_CONDITION = "FILTERCONDITION";
    public static final String KEY_NULLABLE = "NULLABLE";
    public static final String KEY_UNIQUE = "UNIQUE";
    public static final boolean DEFAULT_AUTO_UPDATE = false;
    public static final String DEFAULT_FILTER_CONDITION = null;
    public static final boolean DEFAULT_NULLABLE = false;
    public static final boolean DEFAULT_UNIQUE = false;
    private List<RelationalColumn> columns;
    private boolean autoUpdate;
    private String filterCondition;
    private boolean nullable;
    private boolean unique;
    private boolean existingTable;
    private RelationalTable relationalTable;

    public RelationalIndex() {
        this.setType(13);
        this.columns = new ArrayList<RelationalColumn>();
        this.setNameValidator((StringNameValidator)new RelationalStringNameValidator(false));
    }

    public RelationalIndex(String name) {
        super(name);
        this.setType(13);
        this.columns = new ArrayList<RelationalColumn>();
        this.setNameValidator((StringNameValidator)new RelationalStringNameValidator(false));
    }

    @Override
    public RelationalIndex clone() {
        RelationalIndex clonedIndex = new RelationalIndex(this.getName());
        clonedIndex.setNameInSource(this.getNameInSource());
        clonedIndex.setDescription(this.getDescription());
        clonedIndex.setModelType(this.getModelType());
        clonedIndex.setUnique(this.isUnique());
        clonedIndex.setAutoUpdate(this.isAutoUpdate());
        clonedIndex.setFilterCondition(this.getFilterCondition());
        clonedIndex.setNullable(this.isNullable());
        for (RelationalColumn col : this.getColumns()) {
            clonedIndex.addColumn(col);
        }
        return clonedIndex;
    }

    @Override
    public void inject(RelationalReference originalIndex) {
        super.inject(originalIndex);
        RelationalIndex theIndex = (RelationalIndex)originalIndex;
        this.setName(theIndex.getName());
        this.setNameInSource(theIndex.getNameInSource());
        this.setDescription(theIndex.getDescription());
        this.setModelType(theIndex.getModelType());
        this.setFilterCondition(theIndex.getFilterCondition());
        this.setNullable(theIndex.isNullable());
        this.setAutoUpdate(theIndex.isAutoUpdate());
        this.setUnique(theIndex.isUnique());
        this.getColumns().clear();
        for (RelationalColumn col : theIndex.getColumns()) {
            this.addColumn(col);
        }
    }

    public List<RelationalColumn> getColumns() {
        return this.columns;
    }

    public void addColumn(RelationalColumn column) {
        this.columns.add(column);
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public void setAutoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public String getFilterCondition() {
        return this.filterCondition;
    }

    public void setFilterCondition(String filterCondition) {
        this.filterCondition = filterCondition;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public boolean usesExistingTable() {
        return this.existingTable;
    }

    public void setUsesExistingTable(boolean usesExistingTable) {
        this.existingTable = usesExistingTable;
    }

    public RelationalTable getRelationalTable() {
        return this.relationalTable;
    }

    public void setRelationalTable(RelationalTable relationalTable) {
        this.relationalTable = relationalTable;
    }

    public void setProperties(Properties props) {
        for (Object key : props.keySet()) {
            String keyStr = (String)key;
            String value = props.getProperty(keyStr);
            if (value != null && value.length() == 0) continue;
            if (keyStr.equalsIgnoreCase("NAME")) {
                this.setName(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase("NAMEINSOURCE")) {
                this.setNameInSource(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase("DESCRIPTION")) {
                this.setDescription(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_NULLABLE)) {
                this.setNullable(Boolean.parseBoolean(value));
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_UNIQUE)) {
                this.setUnique(Boolean.parseBoolean(value));
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_AUTO_UPDATE)) {
                this.setAutoUpdate(Boolean.parseBoolean(value));
                continue;
            }
            if (!keyStr.equalsIgnoreCase(KEY_FILTER_CONDITION)) continue;
            this.setFilterCondition(value);
        }
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getStatus().getSeverity() == 4) {
            return;
        }
        for (RelationalColumn col : this.getColumns()) {
            if (col.getStatus().getSeverity() != 4) continue;
            this.setStatus((IStatus)new Status(4, "org.teiid.designer.relational", col.getStatus().getMessage()));
            return;
        }
        for (RelationalColumn outerColumn : this.getColumns()) {
            for (RelationalColumn innerColumn : this.getColumns()) {
                if (outerColumn == innerColumn || !outerColumn.getName().equalsIgnoreCase(innerColumn.getName())) continue;
                this.setStatus((IStatus)new Status(4, "org.teiid.designer.relational", NLS.bind((String)Messages.validate_error_duplicateColumnNamesReferencedInIndex, (Object)this.getName())));
            }
        }
        if (this.getColumns().isEmpty()) {
            this.setStatus((IStatus)new Status(2, "org.teiid.designer.relational", NLS.bind((String)Messages.validate_warning_noColumnReferencesDefined, (Object)this.getName())));
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(" : name = ").append(this.getName());
        if (!this.getColumns().isEmpty()) {
            sb.append("\n\t").append(this.getColumns().size()).append(" columns");
            for (RelationalColumn col : this.getColumns()) {
                sb.append("\n\tcol = ").append(col);
            }
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RelationalIndex other = (RelationalIndex)object;
        if (!CoreStringUtil.valuesAreEqual((String)this.getFilterCondition(), (String)other.getFilterCondition())) {
            return false;
        }
        if (this.isAutoUpdate() != other.isAutoUpdate() || this.isNullable() != other.isNullable() || this.isUnique() != other.isUnique()) {
            return false;
        }
        if (this.relationalTable == null ? other.relationalTable != null : !this.relationalTable.equals(other.relationalTable)) {
            return false;
        }
        List<RelationalColumn> thisColumns = this.getColumns();
        List<RelationalColumn> thatColumns = other.getColumns();
        if (thisColumns.size() != thatColumns.size()) {
            return false;
        }
        return thisColumns.isEmpty() || thisColumns.containsAll(thatColumns);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (!CoreStringUtil.isEmpty((String)this.getFilterCondition())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getFilterCondition()});
        }
        result = HashCodeUtil.hashCode((int)result, (boolean)this.isAutoUpdate());
        result = HashCodeUtil.hashCode((int)result, (boolean)this.isNullable());
        result = HashCodeUtil.hashCode((int)result, (boolean)this.isUnique());
        if (this.relationalTable != null) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.relationalTable});
        }
        List<RelationalColumn> cols = this.getColumns();
        for (RelationalColumn col : cols) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{col});
        }
        return result;
    }
}

