/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.view.logs;

import com.google.common.base.Objects;
import io.fabric8.insight.log.LogFilter;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.fusesource.ide.commons.Activator;
import org.fusesource.ide.commons.Viewers;
import org.fusesource.ide.commons.ui.Menus;
import org.fusesource.ide.commons.ui.Selections;
import org.fusesource.ide.commons.ui.Widgets;
import org.fusesource.ide.commons.ui.views.TableViewSupport;
import org.fusesource.ide.commons.util.Function1;
import org.fusesource.ide.fabric8.core.dto.LogEventDTO;
import org.fusesource.ide.fabric8.ui.FabricPlugin;
import org.fusesource.ide.fabric8.ui.view.logs.HasLogBrowser;
import org.fusesource.ide.fabric8.ui.view.logs.ILogBrowser;
import org.fusesource.ide.fabric8.ui.view.logs.LocationLabelProvider;
import org.fusesource.ide.fabric8.ui.view.logs.LogContext;
import org.fusesource.ide.fabric8.ui.view.logs.LogLevelImageProvider;
import org.fusesource.ide.fabric8.ui.view.logs.LogMessages;
import org.fusesource.ide.fabric8.ui.view.logs.actions.OpenStackTraceAction;

public class LogsView
extends TableViewSupport
implements LogContext,
ISelectionListener {
    public static final String ID = LogsView.class.getName();
    private ILogBrowser browser;
    private final Set<LogEventDTO> logEventList = Collections.synchronizedSet(new TreeSet());
    private long logPollTime = 5000L;
    private Job job;
    private boolean newColumnsMayAppear = false;
    private boolean columnsEverChange = false;
    private LogFilter logFilter = new LogFilter();
    private boolean filterChanged;
    private OpenStackTraceAction openStackAction;

    public LogsView() {
        this.job = new Job("Querying logs..."){

            protected IStatus run(IProgressMonitor monitor) {
                if (!LogsView.this.logEventList.isEmpty()) {
                    LogsView.this.logFilter.setCount(50);
                }
                LogsView.this.logFilter.setBeforeTimestamp(Long.valueOf(System.currentTimeMillis()));
                LogsView.this.queryLogs();
                if (!Widgets.isDisposed((Control)LogsView.this.getControl())) {
                    this.schedule(LogsView.this.logPollTime);
                } else {
                    FabricPlugin.getLogger().warning("Control disposed to not rescheduling query job");
                }
                return Status.OK_STATUS;
            }
        };
        this.openStackAction = new OpenStackTraceAction(this, LogMessages.openStackTrace);
        this.setDoubleClickAction((Action)this.openStackAction);
    }

    protected String getHelpID() {
        return ID;
    }

    public String getColumnConfigurationId() {
        return ID;
    }

    protected void addToolBarActions(IToolBarManager manager) {
        super.addToolBarActions(manager);
        Menus.addAction((IContributionManager)manager, (Object)((Object)this.openStackAction));
    }

    protected void addLocalMenus(IMenuManager manager) {
        super.addLocalMenus(manager);
        Menus.addAction((IContributionManager)manager, (Object)((Object)this.openStackAction));
    }

    protected void removeToolBarActions(IToolBarManager manager) {
        Menus.removeAction((IContributionManager)manager, (Object)((Object)this.openStackAction));
        super.removeToolBarActions(manager);
    }

    protected void removeLocalMenus(IMenuManager manager) {
        Menus.removeAction((IContributionManager)manager, (Object)((Object)this.openStackAction));
        super.removeLocalMenus(manager);
    }

    @Override
    public LogFilter getLogFilter() {
        return this.logFilter;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        if (site != null) {
            site.getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        }
        this.job.schedule();
    }

    public LogEventDTO getSelectedEvent() {
        return (LogEventDTO)Selections.getFirstSelection((Viewer)this.getViewer());
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.aboutToBeShown();
    }

    public void dispose() {
        this.job.cancel();
        IViewSite site = this.getViewSite();
        if (site != null) {
            site.getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        }
        super.dispose();
    }

    protected void queryLogs() {
        try {
            if (!Widgets.isValidFromOtherThread((Widget)this.getControl())) {
                FabricPlugin.getLogger().warning("Control not valid so not querying logs...");
                return;
            }
            boolean value = this.filterChanged;
            if (this.browser != null) {
                this.filterChanged = false;
                if (value) {
                    this.logFilter.setAfterTimestamp(null);
                    this.logFilter.setBeforeTimestamp(null);
                }
                this.browser.queryLogs(this, value);
            }
        }
        catch (Throwable e) {
            Activator.getLogger().warning("Failed to query logs: " + e, e);
        }
    }

    @Override
    public void addLogResults(final List<LogEventDTO> events) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                for (LogEventDTO event : events) {
                    if (event == null) continue;
                    LogsView.this.logEventList.add(event);
                }
                LogsView.this.onLogEventsChanged();
            }
        });
    }

    protected void onLogEventsChanged() {
        if (this.columnsEverChange) {
            if (this.newColumnsMayAppear) {
                this.createViewer();
            } else {
                this.recreateColumns();
                Viewers.refresh((Viewer)this.getViewer());
            }
        } else {
            Viewers.refresh((Viewer)this.getViewer());
        }
    }

    protected void setLogEvents(final List<LogEventDTO> list) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                LogsView.this.logEventList.clear();
                LogsView.this.logEventList.addAll(list);
                LogsView.this.onLogEventsChanged();
            }
        });
    }

    protected void createViewer() {
        super.createViewer();
    }

    public void refresh() {
        this.job.schedule();
    }

    protected void createColumns() {
        int bounds = 100;
        int column = 0;
        this.clearColumns();
        Object function = new Function1(){

            public Object apply(Object element) {
                LogEventDTO log = (LogEventDTO)element;
                if (log != null) {
                    return log.getEventTimestamp();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Time");
        function = new Function1(){

            public Object apply(Object element) {
                LogEventDTO log = (LogEventDTO)element;
                if (log != null) {
                    return log.getEventhost();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Host");
        function = new Function1(){

            public Object apply(Object element) {
                LogEventDTO log = (LogEventDTO)element;
                if (log != null) {
                    return log.getContainer();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Container");
        function = new Function1(){

            public Object apply(Object element) {
                LogEventDTO log = (LogEventDTO)element;
                if (log != null) {
                    return log.getLogLevel();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Level", (CellLabelProvider)new LogLevelImageProvider());
        function = new Function1(){

            public Object apply(Object element) {
                LogEventDTO log = (LogEventDTO)element;
                if (log != null) {
                    return log.getLogger();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Category");
        function = new Function1(){

            public Object apply(Object element) {
                LogEventDTO log = (LogEventDTO)element;
                if (log != null) {
                    return log.getThreadName();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Thread");
        function = new Function1(){

            public Object apply(Object element) {
                LogEventDTO log = (LogEventDTO)element;
                if (log != null) {
                    String msg = log.getLogMessage();
                    if (msg.indexOf(10) != -1) {
                        return log.getLogMessage().substring(0, log.getLogMessage().indexOf(10));
                    }
                    return log.getLogMessage();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Message");
        function = new Function1(){

            public Object apply(Object element) {
                return element;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Location", (CellLabelProvider)new LocationLabelProvider());
        function = new Function1(){

            public Object apply(Object element) {
                LogEventDTO log = (LogEventDTO)element;
                if (log != null) {
                    return log.getPropertiesMap();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Properties");
        function = new Function1(){

            public Object apply(Object element) {
                LogEventDTO log = (LogEventDTO)element;
                if (log != null) {
                    return log.getSeq();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "ID");
        function = new Function1(){

            public Object apply(Object element) {
                LogEventDTO log = (LogEventDTO)element;
                if (log != null) {
                    return log.getException();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Exception");
    }

    protected void configureViewer() {
        this.setInput(this.logEventList);
    }

    protected IStructuredContentProvider createContentProvider() {
        return ArrayContentProvider.getInstance();
    }

    public void setExchangeBrowser(ILogBrowser browser) {
        if (!Objects.equal((Object)this.browser, (Object)browser)) {
            this.browser = browser;
            this.onFilterChanged();
            this.logEventList.clear();
            this.setInput(this.logEventList);
            Viewers.refreshAsync((Viewer)this.getViewer());
        }
        this.refresh();
    }

    protected void onFilterChanged() {
        this.filterChanged = true;
        super.onFilterChanged();
        this.logFilter.setCount(0);
        this.logFilter.setBeforeTimestamp(Long.valueOf(System.currentTimeMillis()));
        this.refresh();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.isRelevantSelectionSource(part, selection)) {
            return;
        }
        ILogBrowser browser = null;
        Object o = Selections.getFirstSelection((ISelection)selection);
        if (o instanceof ILogBrowser) {
            browser = (ILogBrowser)o;
        } else if (o instanceof HasLogBrowser) {
            browser = ((HasLogBrowser)o).getLogBrowser();
        }
        this.setExchangeBrowser(browser);
        this.onFilterChanged();
    }

    private boolean isRelevantSelectionSource(IWorkbenchPart part, ISelection selection) {
        boolean process = false;
        if (part.getClass().getName().equals("org.fusesource.ide.fabric8.ui.navigator.FabricNavigator")) {
            process = true;
        }
        return process;
    }
}

