/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.navigator;

import java.util.HashMap;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.fusesource.ide.commons.Viewers;
import org.fusesource.ide.commons.tree.RefreshableNode;
import org.fusesource.ide.fabric8.ui.navigator.Fabric;
import org.fusesource.ide.fabric8.ui.navigator.FabricEvent;
import org.fusesource.ide.fabric8.ui.navigator.FabricListener;
import org.fusesource.ide.fabric8.ui.navigator.FabricNavigator;
import org.fusesource.ide.fabric8.ui.navigator.Fabrics;
import org.fusesource.ide.fabric8.ui.navigator.cloud.CloudsNode;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class FabricsContentProvider
implements ITreeContentProvider,
ILabelProvider,
IStructuredContentProvider,
FabricListener,
IChangeListener {
    private HashMap<RefreshableNode, DelayProxy> loading = new HashMap();
    private Viewer viewer;
    private FabricNavigator navigator;

    public void dispose() {
        this.removeFabricListener();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        if (newInput instanceof FabricNavigator) {
            this.removeFabricListener();
            this.navigator = (FabricNavigator)((Object)newInput);
            this.navigator.getFabrics().addFabricListener(this);
            this.navigator.getCloudsNode().addChangeListener(this);
        }
    }

    protected void removeFabricListener() {
        if (this.navigator != null) {
            this.navigator.getFabrics().removeFabricListener(this);
            this.navigator.getCloudsNode().removeChangeListener(this);
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof FabricNavigator) {
            FabricNavigator navigator = (FabricNavigator)((Object)parentElement);
            return new Object[]{navigator.getFabrics(), navigator.getCloudsNode()};
        }
        if (parentElement instanceof CloudsNode) {
            return ((CloudsNode)((Object)parentElement)).getChildren();
        }
        if (parentElement instanceof Fabrics) {
            return ((Fabrics)((Object)parentElement)).getChildren();
        }
        if (parentElement instanceof RefreshableNode) {
            return this.loadAndGetChildren(parentElement);
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof Node) {
            return ((Node)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        RefreshableNode node;
        if (element instanceof DelayProxy) {
            return false;
        }
        if (element instanceof Fabric) {
            return ((Fabric)element).isConnected();
        }
        if (element instanceof RefreshableNode && (node = (RefreshableNode)element).isLoaded()) {
            return node.getChildren().length > 0;
        }
        return true;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getImage(Object element) {
        ImageProvider provider;
        Image image;
        if (element instanceof ImageProvider && (image = (provider = (ImageProvider)element).getImage()) != null) {
            return image;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof FabricNavigator) {
            return "Fabrics";
        }
        if (element instanceof DelayProxy) {
            return "...loading...";
        }
        return element.toString();
    }

    protected synchronized Object[] loadAndGetChildren(final Object parent) {
        final RefreshableNode w = (RefreshableNode)parent;
        if (w.isLoaded()) {
            return w.getChildren();
        }
        Job job = new Job("Loading " + parent + "..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Loading children of " + w + "...", 1);
                    w.getChildren();
                    monitor.done();
                }
                finally {
                    FabricsContentProvider.this.loading.remove(w);
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (FabricsContentProvider.this.viewer instanceof StructuredViewer) {
                            ((StructuredViewer)FabricsContentProvider.this.viewer).refresh(parent);
                        } else {
                            FabricsContentProvider.this.viewer.refresh();
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        if (this.loading.containsKey((RefreshableNode)parent)) {
            return new Object[]{this.loading.get((RefreshableNode)parent)};
        }
        DelayProxy p = new DelayProxy(w);
        this.loading.put(w, p);
        job.schedule();
        return new Object[]{p};
    }

    @Override
    public void onFabricEvent(FabricEvent fabricEvent) {
        this.fireRefresh(fabricEvent.getFabric(), true);
    }

    public void handleChange(ChangeEvent event) {
        this.fireRefresh((Object)this.navigator.getCloudsNode(), true);
    }

    private void fireRefresh(Object node, boolean full) {
        this.refreshTreeViewer(this.viewer, node, full);
    }

    public void refreshTreeViewer(final Viewer viewer, final Object node, final boolean full) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (Viewers.isValid((Viewer)viewer)) {
                    TreeViewer tv = (TreeViewer)viewer;
                    if (full || node == null || !(viewer instanceof StructuredViewer)) {
                        viewer.refresh();
                        if (node != null) {
                            tv.expandToLevel(node, 1);
                        } else {
                            tv.expandToLevel((Object)FabricsContentProvider.this.navigator.getFabrics(), 1);
                        }
                    } else {
                        ((StructuredViewer)viewer).refresh(node);
                        tv.expandToLevel(node, 1);
                    }
                }
            }
        });
    }

    public static class DelayProxy {
        public RefreshableNode wrapper;

        public DelayProxy(RefreshableNode node) {
            this.wrapper = node;
        }
    }
}

