/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.actions.jclouds;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.fusesource.ide.commons.ui.ICanValidate;
import org.fusesource.ide.commons.ui.Selections;
import org.fusesource.ide.commons.ui.form.FormSupport;
import org.fusesource.ide.fabric8.ui.actions.Messages;
import org.fusesource.ide.fabric8.ui.actions.jclouds.CloudDetails;
import org.fusesource.ide.fabric8.ui.actions.jclouds.CloudDetailsCachedData;
import org.fusesource.ide.fabric8.ui.actions.jclouds.JClouds;
import org.fusesource.ide.fabric8.ui.actions.jclouds.JCloudsLabelProvider;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.Providers;

public class CloudDetailsForm
extends FormSupport {
    private ComboViewer providerNameField;
    private ComboViewer apiNameField;
    private Text endpointField;
    private Text identityField;
    private CloudDetails details = new CloudDetails();
    private Text nameField;
    private Color originalColor;

    public CloudDetailsForm(ICanValidate validator) {
        super(validator);
    }

    protected boolean isMandatory(Object bean, String propertyName) {
        return !Objects.equal((Object)propertyName, (Object)"ownerId") && !Objects.equal((Object)propertyName, (Object)"provider") && !Objects.equal((Object)propertyName, (Object)"api") && !Objects.equal((Object)propertyName, (Object)"endpoint");
    }

    public CloudDetails getDetails() {
        return this.details;
    }

    public void setDetails(CloudDetails details) {
        this.details = details;
    }

    public void setFocus() {
        if (this.nameField != null) {
            this.nameField.setFocus();
        }
    }

    public void createTextFields(Composite parent) {
        ApiMetadata api;
        Composite inner = this.createSectionComposite(Messages.jclouds_cloudDetails, new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        this.nameField = this.createBeanPropertyTextField(inner, (Object)this.details, "name", Messages.jclouds_nameLabel, Messages.jclouds_nameTooltip);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Providers.class.getClassLoader());
            this.providerNameField = this.createBeanPropertyCombo(inner, (Object)this.details, "provider", Messages.jclouds_providerNameLabel, Messages.jclouds_providerNameTooltip, JClouds.getComputeProviders());
            this.apiNameField = this.createBeanPropertyCombo(inner, (Object)this.details, "api", Messages.jclouds_apiNameLabel, Messages.jclouds_apiNameTooltip, JClouds.getComputeApis());
            this.providerNameField.getCombo().select(0);
            this.apiNameField.getCombo().select(0);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        this.providerNameField.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProviderMetadata item = (ProviderMetadata)Selections.getFirstSelection((ISelection)event.getSelection());
                CloudDetailsForm.this.apiNameField.getCombo().setEnabled(item == JClouds.EMPTY_PROVIDER);
                CloudDetailsForm.this.validate();
            }
        });
        this.apiNameField.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ApiMetadata item = (ApiMetadata)Selections.getFirstSelection((ISelection)event.getSelection());
                CloudDetailsForm.this.providerNameField.getCombo().setEnabled(item == JClouds.EMPTY_API);
                CloudDetailsForm.this.validate();
            }
        });
        ProviderMetadata provider = this.details.getProvider();
        if (provider != null) {
            this.providerNameField.setSelection((ISelection)new StructuredSelection((Object)provider));
        }
        if ((api = this.details.getApi()) != null) {
            this.apiNameField.setSelection((ISelection)new StructuredSelection((Object)api));
        }
        this.endpointField = this.createBeanPropertyTextField(inner, (Object)this.details, "endpoint", Messages.jclouds_endpointLabel, Messages.jclouds_endpointTooltip);
        this.originalColor = this.endpointField.getBackground();
        this.identityField = this.createBeanPropertyTextField(inner, (Object)this.details, "identity", Messages.jclouds_identityLabel, Messages.jclouds_identityTooltip);
        this.createBeanPropertyTextField(inner, (Object)this.details, "credential", Messages.jclouds_credentialLabel, Messages.jclouds_credentialTooltip, 0x400800);
        this.createBeanPropertyTextField(inner, (Object)this.details, "ownerId", Messages.jclouds_ownerLabel, Messages.jclouds_ownerTooltip, 0x400800);
        this.endpointField.setEnabled(false);
        this.apiNameField.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CloudDetailsForm.this.endpointField.setEnabled(!event.getSelection().isEmpty() && !Selections.getFirstSelection((ISelection)event.getSelection()).equals(JClouds.EMPTY_API));
                if (CloudDetailsForm.this.endpointField.isEnabled()) {
                    CloudDetailsForm.this.endpointField.setBackground(Display.getCurrent().getSystemColor(3));
                    CloudDetailsForm.this.endpointField.setFocus();
                } else {
                    CloudDetailsForm.this.endpointField.setText("");
                    CloudDetailsForm.this.endpointField.setBackground(CloudDetailsForm.this.originalColor);
                }
            }
        });
        this.endpointField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CloudDetailsForm.this.endpointField.getText().trim().length() > 0) {
                    CloudDetailsForm.this.endpointField.setBackground(CloudDetailsForm.this.originalColor);
                } else {
                    CloudDetailsForm.this.endpointField.setBackground(Display.getCurrent().getSystemColor(3));
                }
            }
        });
    }

    protected ComboViewer createBeanPropertyCombo(Composite parent, Object bean, String propertyName, String labelText, String tooltip, Iterable<?> input) {
        ComboViewer answer = this.createBeanPropertyCombo(parent, bean, propertyName, labelText, tooltip, 2056);
        answer.setInput((Object)Lists.newArrayList(input));
        answer.setLabelProvider((IBaseLabelProvider)JCloudsLabelProvider.getInstance());
        return answer;
    }

    public void okPressed() {
        CloudDetailsCachedData.getInstance(this.details).startLoadingDataJobs();
    }

    public boolean isValid() {
        ApiMetadata api = (ApiMetadata)Selections.getFirstSelection((ISelection)this.apiNameField.getSelection());
        ProviderMetadata provider = (ProviderMetadata)Selections.getFirstSelection((ISelection)this.providerNameField.getSelection());
        return super.isValid() && (api != JClouds.EMPTY_API && this.endpointField.getText().trim().length() > 0 || provider != JClouds.EMPTY_PROVIDER);
    }
}

