/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.actions.jclouds;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.fusesource.ide.commons.jobs.Jobs;
import org.fusesource.ide.fabric8.ui.FabricPlugin;
import org.fusesource.ide.fabric8.ui.actions.jclouds.CloudDetails;
import org.fusesource.ide.fabric8.ui.actions.jclouds.CloudDetailsCachedData;
import org.fusesource.ide.fabric8.ui.actions.jclouds.JClouds;
import org.jclouds.compute.ComputeService;
import org.jclouds.rest.AuthorizationException;

public class CloudConnectJob
extends Job {
    private final CloudDetailsCachedData cacheData;
    private final CloudDetails details;
    private final Job[] nextJobs;
    private boolean cancelled = false;

    public CloudConnectJob(CloudDetailsCachedData cacheData, Job ... nextJobs) {
        super("Connect to cloud");
        this.cacheData = cacheData;
        this.details = cacheData.getDetails();
        this.nextJobs = nextJobs;
    }

    public CloudDetails getDetails() {
        return this.details;
    }

    public ComputeService getComputeClient() {
        return this.cacheData.getComputeClient();
    }

    public void setComputeClient(ComputeService computeClient) {
        this.cacheData.setComputeClient(computeClient);
    }

    protected IStatus run(IProgressMonitor monitor) {
        block7: {
            if (this.details.getApi() == JClouds.EMPTY_API && this.details.getProvider() == JClouds.EMPTY_PROVIDER) {
                return Status.OK_STATUS;
            }
            try {
                ComputeService computeClient = this.cacheData.getComputeClient();
                if (computeClient == null) {
                    FabricPlugin.getLogger().debug("Starting to connect to " + (Object)((Object)this.details));
                    computeClient = CloudDetails.createComputeService(this.details);
                }
                if (computeClient != null) {
                    this.setComputeClient(computeClient);
                    this.onConnected(computeClient, monitor);
                }
            }
            catch (AuthorizationException e) {
                if (!this.cancelled) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            FabricPlugin.showUserError("Could not authorize cloud details", e.getMessage(), (Exception)e);
                        }
                    });
                }
            }
            catch (Exception e) {
                if (this.cancelled) break block7;
                return new Status(2, "org.fusesource.ide.fabric8.ui", "Failed to connect to cloud " + this.details.getName() + ". Reason: " + e, (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    protected void onConnected(ComputeService client, IProgressMonitor monitor) {
        Jobs.schedule((Job[])this.nextJobs);
    }

    public void canceling() {
        this.cancelled = true;
    }
}

