/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.fusesource.ide.commons.tree.Refreshable;
import org.fusesource.ide.commons.ui.Selections;
import org.fusesource.ide.fabric8.ui.actions.Messages;

public class RefreshAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    private StructuredViewer viewer;
    private String viewId;

    public RefreshAction() {
    }

    public RefreshAction(String viewId) {
        this.viewId = viewId;
        this.setText(Messages.RefreshAction_text);
        this.setDescription(Messages.RefreshAction_description);
        this.setToolTipText(Messages.RefreshAction_tooltip);
    }

    private void refreshObjectNode(Object onode) {
        if (onode == null) {
            return;
        }
        if (onode instanceof Refreshable) {
            Refreshable refreshable = (Refreshable)onode;
            refreshable.refresh();
            this.refreshViewer(onode);
        }
    }

    public boolean isEnabled() {
        Object o = this.getSelectedObject();
        return o instanceof Refreshable;
    }

    public void run() {
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb == null) {
            return;
        }
        IWorkbenchWindow aww = wb.getActiveWorkbenchWindow();
        if (aww == null) {
            return;
        }
        IWorkbenchPage ap = aww.getActivePage();
        if (ap == null) {
            return;
        }
        ISelection sel = this.getSelection(ap);
        if (sel == null) {
            this.refreshViewer(null);
        } else if (sel instanceof TreeSelection) {
            TreeSelection treeSelection = (TreeSelection)sel;
            this.refreshObjectNode(treeSelection.getFirstElement());
        } else if (sel instanceof StructuredSelection) {
            StructuredSelection ss = (StructuredSelection)sel;
            this.refreshObjectNode(ss.getFirstElement());
        }
    }

    protected Object getSelectedObject() {
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb == null) {
            return null;
        }
        IWorkbenchWindow aww = wb.getActiveWorkbenchWindow();
        if (aww == null) {
            return null;
        }
        IWorkbenchPage ap = aww.getActivePage();
        if (ap == null) {
            return null;
        }
        ISelection sel = this.getSelection(ap);
        return Selections.getFirstSelection((ISelection)sel);
    }

    protected ISelection getSelection(IWorkbenchPage ap) {
        return ap.getSelection(this.viewId);
    }

    private void refreshViewer(Object node) {
        if (this.viewer != null) {
            if (node == null) {
                this.viewer.refresh();
            } else {
                this.viewer.refresh(node);
            }
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void setViewer(StructuredViewer viewer) {
        this.viewer = viewer;
    }
}

