/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.actions;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.fusesource.ide.commons.ui.config.ConfigurationDetails;
import org.fusesource.ide.fabric8.ui.FabricPlugin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class FabricDetails
extends ConfigurationDetails {
    private static WritableList fabricDetailList = WritableList.withElementType(FabricDetails.class);
    private static AtomicBoolean loadedDetalList = new AtomicBoolean(false);
    private static FabricDetails exemplar = new FabricDetails();
    private String name;
    private String urls;
    private String userName = "";
    private String password = "";
    private String zkPassword;

    public static void reloadDetailList() {
        fabricDetailList.clear();
        FabricDetails.load((Collection<FabricDetails>)fabricDetailList);
    }

    public static WritableList getDetailList() {
        if (loadedDetalList.compareAndSet(false, true)) {
            FabricDetails.load((Collection<FabricDetails>)fabricDetailList);
        }
        return fabricDetailList;
    }

    public static FabricDetails newInstance(String fabricName, String uris) {
        return new FabricDetails(fabricName, uris);
    }

    public static FabricDetails asFabricDetails(Object element) {
        if (element instanceof FabricDetails) {
            return (FabricDetails)((Object)element);
        }
        return null;
    }

    protected static void load(Collection<FabricDetails> cloudDetailList) {
        Preferences node = exemplar.getConfigurationNode();
        try {
            String[] childrenNames;
            String[] stringArray = childrenNames = node.childrenNames();
            int n = childrenNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                cloudDetailList.add(new FabricDetails(name, node.node(name)));
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            FabricPlugin.showUserError("Failed to load fabric details", e.getMessage(), (Exception)((Object)e));
        }
    }

    public FabricDetails() {
        this("Local Fabric", "http://localhost:8181/jolokia/");
    }

    public FabricDetails(String name, String urls) {
        this.name = name;
        this.urls = urls.startsWith("http://") && urls.endsWith("/jolokia/") ? urls : (urls.contains(",") ? String.format("http://%s:8181/jolokia/", urls.substring(0, urls.indexOf(44)).trim()) : String.format("http://%s:8181/jolokia/", urls.trim()));
    }

    public FabricDetails(String id, Preferences node) {
        super(id);
        this.name = node.get("name", "");
        this.urls = node.get("urls", "");
        this.userName = node.get("userName", "admin");
        this.password = node.get("password", "admin");
        this.zkPassword = node.get("zkPassword", "");
    }

    public static FabricDetails copy(FabricDetails copy) {
        Preferences node = exemplar.getConfigurationNode();
        String id = copy.getId();
        return new FabricDetails(id, node.node(id));
    }

    protected void store(Preferences node) {
        node.put("name", this.name);
        node.put("urls", this.urls);
        node.put("userName", this.userName);
        node.put("password", this.password);
        node.put("zkPassword", this.zkPassword);
    }

    public String toString() {
        return "FabricDetails(" + this.name + ", " + this.urls + ")";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrls() {
        return this.urls;
    }

    public void setUrls(String urls) {
        this.urls = urls;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setZkPassword(String zkPassword) {
        this.zkPassword = zkPassword;
    }

    public String getZkPassword() {
        return this.zkPassword;
    }
}

