/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.actions;

import com.google.common.base.Supplier;
import java.util.List;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.fusesource.ide.commons.ui.Shells;
import org.fusesource.ide.commons.ui.actions.ActionSupport;
import org.fusesource.ide.fabric8.core.dto.VersionDTO;
import org.fusesource.ide.fabric8.core.dto.VersionSequenceDTO;
import org.fusesource.ide.fabric8.ui.FabricPlugin;
import org.fusesource.ide.fabric8.ui.actions.Messages;
import org.fusesource.ide.fabric8.ui.navigator.Fabric;
import org.fusesource.ide.fabric8.ui.navigator.Fabrics;
import org.fusesource.ide.fabric8.ui.navigator.VersionNode;
import org.fusesource.ide.fabric8.ui.navigator.VersionsNode;
import org.jboss.tools.jmx.core.tree.Node;

public class CreateVersionAction
extends ActionSupport {
    private Supplier<VersionDTO> oldVersionSupplier;
    private Fabric fabric;

    public CreateVersionAction(VersionsNode versionsNode) {
        super(Messages.createVersionMenuLabel, Messages.createVersionDescription, FabricPlugin.getDefault().getImageDescriptor("new_version.png"));
        if (versionsNode != null) {
            this.fabric = versionsNode.getFabric();
        }
        this.setVersioNode(null);
    }

    public CreateVersionAction(VersionNode versionNode) {
        super(Messages.createVersionMenuLabel, Messages.createVersionDescription, FabricPlugin.getDefault().getImageDescriptor("new_version.png"));
        if (versionNode != null) {
            this.fabric = versionNode.getFabric();
        }
        this.setVersioNode(versionNode);
    }

    public ImageDescriptor getImageDescriptor() {
        return FabricPlugin.getDefault().getImageDescriptor("version.png");
    }

    public void run() {
        InputDialog dialog;
        int result;
        String defaultValue = "";
        VersionDTO latestVersion = (VersionDTO)this.oldVersionSupplier.get();
        if (latestVersion != null) {
            VersionSequenceDTO next = latestVersion.getVersionSequence().next();
            while (next != null && this.getVersionNode(next.getName()) != null) {
                next = next.next();
            }
            if (next != null) {
                defaultValue = next.getName();
            }
        }
        if ((result = (dialog = new InputDialog(Shells.getShell(), Messages.createVersionDialogTitle, Messages.createVersionDialogMessage, defaultValue, null)).open()) == 0) {
            String newVersion = dialog.getValue();
            this.createVersion(newVersion);
        }
    }

    protected VersionNode getVersionNode(String version) {
        List existingVersions = this.fabric.getVersionsNode().getChildrenList();
        for (Node n : existingVersions) {
            if (n == null || !(n instanceof VersionNode) || !((VersionNode)n).getVersionId().equals(version)) continue;
            return (VersionNode)n;
        }
        return null;
    }

    protected void createVersion(String newVersion) {
        VersionDTO oldVersion = (VersionDTO)this.oldVersionSupplier.get();
        FabricPlugin.getLogger().debug("Creating new version " + newVersion + " from old " + Fabrics.getVersionName(oldVersion));
        if (oldVersion != null) {
            this.fabric.getFabricService().createVersion(oldVersion.getId(), newVersion);
        } else {
            this.fabric.getFabricService().createVersion(newVersion);
        }
        this.fabric.getVersionsNode().refresh();
    }

    public VersionDTO getLatestVersion() {
        return Fabrics.getLatestVersion(this.fabric.getFabricService());
    }

    public void setVersioNode(final VersionNode versionNode) {
        this.oldVersionSupplier = new Supplier<VersionDTO>(){

            public VersionDTO get() {
                if (versionNode != null) {
                    return versionNode.getVersion();
                }
                return CreateVersionAction.this.getLatestVersion();
            }
        };
    }

    public void setFabric(Fabric fabric) {
        this.fabric = fabric;
    }
}

