/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.actions;

import org.fusesource.ide.commons.ui.actions.ActionSupport;
import org.fusesource.ide.fabric8.ui.FabricPlugin;
import org.fusesource.ide.fabric8.ui.actions.CreateSshContainerDialog;
import org.fusesource.ide.fabric8.ui.actions.Messages;
import org.fusesource.ide.fabric8.ui.navigator.ContainerNode;
import org.fusesource.ide.fabric8.ui.navigator.Fabric;
import org.fusesource.ide.fabric8.ui.navigator.ProfileNode;
import org.fusesource.ide.fabric8.ui.navigator.VersionNode;

public class CreateSshContainerAction
extends ActionSupport {
    public static final boolean createLocalAgents = true;
    private VersionNode versionNode;
    private final ContainerNode agentNode;
    private ProfileNode profileNode;

    public CreateSshContainerAction(VersionNode versionNode, ContainerNode agentNode, ProfileNode selectedProfile) {
        super(Messages.createSshAgentMenuLabel, Messages.createSshAgentToolTip, FabricPlugin.getDefault().getImageDescriptor("new_ssh_container.png"));
        this.versionNode = versionNode;
        this.agentNode = agentNode;
        this.profileNode = selectedProfile;
    }

    public CreateSshContainerAction(Fabric fabric) {
        super(Messages.createSshAgentMenuLabel, Messages.createSshAgentToolTip, FabricPlugin.getDefault().getImageDescriptor("new_ssh_container.png"));
        this.versionNode = fabric != null ? fabric.getDefaultVersionNode() : null;
        this.agentNode = null;
        this.profileNode = null;
    }

    public void run() {
        this.showCreateAgentDialog();
    }

    public ProfileNode getProfileNode() {
        return this.profileNode;
    }

    public void setProfileNode(ProfileNode profileNode) {
        this.profileNode = profileNode;
    }

    public void setFabric(Fabric fabric) {
        if (fabric != null) {
            this.versionNode = fabric.getDefaultVersionNode();
        }
    }

    protected void showCreateAgentDialog() {
        CreateSshContainerDialog dialog = new CreateSshContainerDialog(this.versionNode, this.agentNode, this.versionNode.getFabric().getNewAgentName(), this.profileNode);
        dialog.open();
    }
}

