/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.fusesource.ide.commons.ui.ContextMenuProvider;
import org.fusesource.ide.commons.ui.Selections;
import org.fusesource.ide.fabric8.ui.FabricPlugin;
import org.fusesource.ide.fabric8.ui.actions.DoubleClickAction;
import org.fusesource.ide.fabric8.ui.actions.RefreshAction;

public class FabricExplorerActionProvider
extends CommonActionProvider {
    private ICommonActionExtensionSite site;
    private DoubleClickAction doubleClickAction;
    private RefreshAction refreshAction;

    public void init(ICommonActionExtensionSite site) {
        super.init(site);
        this.site = site;
        String viewId = site.getViewSite().getId();
        this.doubleClickAction = new DoubleClickAction();
        this.refreshAction = new RefreshAction(viewId);
        StructuredViewer viewer = site.getStructuredViewer();
        this.refreshAction.setViewer(viewer);
        FabricPlugin.getLogger().debug("============================= View ID: " + viewId);
    }

    public StructuredViewer getStructuredViewer() {
        return this.site.getStructuredViewer();
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.doubleClickAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        menu.appendToGroup("additions", (IAction)this.refreshAction);
        Object o = Selections.getFirstSelection((ISelection)this.site.getStructuredViewer().getSelection());
        if (o instanceof ContextMenuProvider) {
            ContextMenuProvider cmp = (ContextMenuProvider)o;
            cmp.provideContextMenu(menu);
        }
    }
}

