/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.fusesource.ide.fabric8.core.connector.Fabric8Connector;
import org.fusesource.ide.fabric8.core.connector.Fabric8ConnectorType;
import org.fusesource.ide.fabric8.core.connector.Fabric8Facade;
import org.fusesource.ide.fabric8.core.connector.JolokiaFabric8Connector;
import org.fusesource.ide.fabric8.core.dto.ContainerDTO;
import org.fusesource.ide.fabric8.core.dto.VersionDTO;
import org.fusesource.ide.fabric8.ui.FabricConnectionListener;
import org.fusesource.ide.fabric8.ui.FabricPlugin;
import org.fusesource.ide.fabric8.ui.actions.FabricDetails;
import org.fusesource.ide.fabric8.ui.navigator.Fabric;

public class FabricConnector {
    private final Fabric fabric;
    private final FabricDetails details;
    private Fabric8Facade fabricService;
    private Fabric8Connector con;
    private final String url;
    private AtomicBoolean connected = new AtomicBoolean(false);
    private ArrayList<FabricConnectionListener> connectionListeners = new ArrayList();

    public FabricConnector(Fabric fabric) {
        this.fabric = fabric;
        this.details = fabric.getDetails();
        this.url = this.details.getUrls();
        this.initialize();
    }

    protected void initialize() {
        FabricPlugin.getLogger().debug("Starting to connect Fabric on: " + this.url);
        this.con = new Fabric8Connector((Fabric8ConnectorType)JolokiaFabric8Connector.getFabric8Connector((String)this.details.getUserName(), (String)this.details.getPassword(), (String)this.url));
    }

    public List<ContainerDTO> getAgents() {
        Fabric8Facade service = this.getFabricService();
        if (service != null) {
            return service.getContainers();
        }
        return new ArrayList<ContainerDTO>();
    }

    public List<VersionDTO> getVersions() {
        Fabric8Facade service = this.getFabricService();
        if (service != null) {
            return service.getVersions();
        }
        return new ArrayList<VersionDTO>();
    }

    public String getName() {
        return this.details.getName();
    }

    public String getUrl() {
        return this.url;
    }

    public String getDefaultVersionId() {
        VersionDTO defaultVersion;
        Fabric8Facade service = this.getFabricService();
        if (service != null && (defaultVersion = service.getDefaultVersion()) != null) {
            return defaultVersion.getId();
        }
        return null;
    }

    public Fabric8Facade getFabricService() {
        this.isConnected();
        return this.fabricService;
    }

    public synchronized void connect() throws IOException {
        this.initialize();
        this.con.connect();
        if (!this.con.isConnected()) {
            this.notifyListeners("DISCONNECTED");
            throw new IOException("Unable to connect to Fabric. Please make sure Fabric is running on the specified host, the used ports are not blocked and the ZooKeeper password is correct. Also check if the Fabric8 version is supported (version >= 1.2).");
        }
        this.connected.set(true);
        this.fabricService = this.con.getConnection().getFabricFacade();
        this.notifyListeners("CONNECTED");
    }

    public synchronized void disconnect() {
        this.dispose();
        this.connected.set(false);
        this.notifyListeners("DISCONNECTED");
    }

    public boolean isConnected() {
        boolean c;
        if (!this.connected.get()) {
            return false;
        }
        boolean bl = c = this.con != null && this.con.isConnected();
        if (c) {
            this.connected.set(c);
            return this.connected.get();
        }
        if (this.connected.get() && !c) {
            try {
                this.connect();
            }
            catch (IOException ex) {
                FabricPlugin.getLogger().error((Throwable)ex);
                this.disconnect();
                FabricPlugin.showUserError("Connection failed...", "Unable to connect to Fabric. Please make sure Fabric is running on the specified host, the used ports are not blocked and the ZooKeeper password is correct. Also check if the Fabric8 version is supported (version >= 1.2).", ex);
                return false;
            }
        }
        return this.connected.get();
    }

    public void dispose() {
        if (this.con != null) {
            this.con.disconnect();
        }
        this.fabricService = null;
    }

    public synchronized void addFabricConnectionListener(FabricConnectionListener listener) {
        if (!this.connectionListeners.contains(listener)) {
            this.connectionListeners.add(listener);
        }
    }

    public synchronized void removeFabricConnectionListener(FabricConnectionListener listener) {
        if (this.connectionListeners.contains(listener)) {
            this.connectionListeners.remove(listener);
        }
    }

    private void notifyListeners(String eventType) {
        HashSet<FabricConnectionListener> copy = new HashSet<FabricConnectionListener>(this.connectionListeners);
        for (FabricConnectionListener l : copy) {
            if (eventType.equals("CONNECTED")) {
                l.onFabricConnected();
                continue;
            }
            l.onFabricDisconnected();
        }
    }
}

