/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.xml.modelextension.impl;

import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.CoreFactory;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.core.extension.ExtensionFactory;
import org.teiid.designer.metamodels.core.extension.ExtensionPackage;
import org.teiid.designer.metamodels.core.extension.XAttribute;
import org.teiid.designer.metamodels.core.extension.XClass;
import org.teiid.designer.metamodels.core.extension.XPackage;
import org.teiid.designer.metamodels.relational.RelationalPackage;
import org.teiid.designer.modelgenerator.xml.XmlImporterUiPlugin;
import org.teiid.designer.modelgenerator.xml.modelextension.ExtensionManager;

public abstract class ExtensionManagerImpl
implements ExtensionManager {
    private XPackage thePackage;
    private XClass theCatalogXClass;
    protected XClass theTableXClass;
    protected XClass theColumnXClass;
    protected XClass theSchemaXClass;

    @Override
    public XPackage getPackage() {
        return this.thePackage;
    }

    @Override
    public void loadModelExtensions(IContainer targetModelLocation, IProgressMonitor monitor) throws ModelerCoreException {
        Path modelPath = new Path(this.validateFileName(this.getModelFileName()));
        IFile iFile = targetModelLocation.getFile((IPath)modelPath);
        if (!iFile.exists()) {
            this.createModelExtensions(iFile, targetModelLocation, monitor);
        } else {
            this.loadModelExtension(targetModelLocation);
        }
    }

    void createModelExtensions(IFile file, IContainer targetModelLocation, IProgressMonitor monitor) throws ModelerCoreException {
        ModelResource modelExtension = ModelerCore.create((IFile)file);
        ModelAnnotation annotation = CoreFactory.eINSTANCE.createModelAnnotation();
        annotation.setPrimaryMetamodelUri(RelationalPackage.eINSTANCE.getNsURI());
        annotation.setModelType(ModelType.EXTENSION_LITERAL);
        ExtensionPackage xPackage = ExtensionPackage.eINSTANCE;
        ExtensionFactory xFactory = xPackage.getExtensionFactory();
        this.thePackage = xFactory.createXPackage();
        this.thePackage.setName(this.getPackageName());
        this.thePackage.setNsPrefix(this.getPackagePrefix());
        this.thePackage.setNsURI(this.getPackageNsUri());
        try {
            modelExtension.getEmfResource().getContents().add((Object)annotation);
            modelExtension.getEmfResource().getContents().add((Object)this.thePackage);
        }
        catch (ModelWorkspaceException e1) {
            ModelerCoreException mbe = new ModelerCoreException();
            mbe.initCause((Throwable)e1);
            throw mbe;
        }
        this.createEnums(xFactory);
        if (this.getCatalogName() != null && "" != this.getCatalogName()) {
            this.theCatalogXClass = xFactory.createXClass();
            this.theCatalogXClass.setExtendedClass(RelationalPackage.eINSTANCE.getCatalog());
            this.theCatalogXClass.setName(this.getCatalogName());
            this.thePackage.getEClassifiers().add((Object)this.theCatalogXClass);
            this.createCatalogExtensions(xFactory, this.theCatalogXClass);
        }
        if (this.getSchemaName() != null && "" != this.getSchemaName()) {
            this.theSchemaXClass = xFactory.createXClass();
            this.theSchemaXClass.setExtendedClass(RelationalPackage.eINSTANCE.getSchema());
            this.theSchemaXClass.setName(this.getSchemaName());
            this.thePackage.getEClassifiers().add((Object)this.theSchemaXClass);
            this.createSchemaExtensions(xFactory, this.theSchemaXClass);
        }
        if (this.getTableName() != null && "" != this.getTableName()) {
            this.theTableXClass = xFactory.createXClass();
            this.theTableXClass.setExtendedClass(RelationalPackage.eINSTANCE.getBaseTable());
            this.theTableXClass.setName(this.getTableName());
            this.thePackage.getEClassifiers().add((Object)this.theTableXClass);
            this.createTableExtensions(xFactory, this.theTableXClass);
        }
        if (this.getColumnName() != null && "" != this.getColumnName()) {
            this.theColumnXClass = xFactory.createXClass();
            this.theColumnXClass.setExtendedClass(RelationalPackage.eINSTANCE.getColumn());
            this.theColumnXClass.setName(this.getColumnName());
            this.thePackage.getEClassifiers().add((Object)this.theColumnXClass);
            this.createColumnExtensions(xFactory, this.theColumnXClass);
        }
        try {
            modelExtension.save(monitor, false);
        }
        catch (ModelWorkspaceException e) {
            ModelerCoreException mbe = new ModelerCoreException();
            mbe.initCause((Throwable)e);
            throw mbe;
        }
    }

    void loadModelExtension(IContainer targetModelLocation) throws ModelerCoreException {
        String extPath;
        Container cntr;
        try {
            cntr = ModelerCore.getModelContainer();
        }
        catch (CoreException e) {
            ModelerCoreException mbe = new ModelerCoreException();
            mbe.initCause((Throwable)e);
            throw mbe;
        }
        cntr.getPackageRegistry().put((Object)"http://www.metamatrix.com/metamodels/Extension", (Object)ExtensionPackage.eINSTANCE);
        IFile extensionFile = targetModelLocation.getProject().getFile((IPath)new Path(this.validateFileName(this.getModelFileName())));
        try {
            extPath = ModelUtil.getLocation((IResource)extensionFile).toOSString();
        }
        catch (CoreException ex) {
            ModelerCoreException mbe = new ModelerCoreException();
            mbe.initCause((Throwable)ex);
            throw mbe;
        }
        URI fileURI = URI.createFileURI((String)extPath);
        Resource xPkg = cntr.getResource(fileURI, true);
        EList resources = xPkg.getContents();
        this.thePackage = null;
        for (Object next : resources) {
            if (!(next instanceof XPackage)) continue;
            this.thePackage = (XPackage)next;
        }
        if (this.thePackage == null) {
            throw new RuntimeException(XmlImporterUiPlugin.getDefault().getPluginUtil().getString("ExtensionManager.package.null.after.load", new Object[0]));
        }
        EList enums = this.getPackage().getEClassifiers();
        Iterator iter = enums.iterator();
        while (iter.hasNext()) {
            this.assignClassifier((EClassifier)iter.next());
        }
        this.theTableXClass = this.thePackage.findXClass(RelationalPackage.eINSTANCE.getBaseTable());
        EList attributes = this.theTableXClass.getEAllAttributes();
        iter = attributes.iterator();
        while (iter.hasNext()) {
            this.assignAttribute((XAttribute)iter.next());
        }
        this.theColumnXClass = this.thePackage.findXClass(RelationalPackage.eINSTANCE.getColumn());
        attributes = this.theColumnXClass.getEAllAttributes();
        iter = attributes.iterator();
        while (iter.hasNext()) {
            this.assignAttribute((XAttribute)iter.next());
        }
    }

    private String validateFileName(String fileName) {
        String result = fileName.endsWith(".xmi") ? fileName : String.valueOf(fileName) + ".xmi";
        return result;
    }

    @Override
    public void assignAttribute(XAttribute attribute) {
    }

    @Override
    public void assignClassifier(EClassifier classifier) {
    }

    @Override
    public void createColumnExtensions(ExtensionFactory factory, XClass column) {
    }

    @Override
    public void createEnums(ExtensionFactory factory) {
    }

    @Override
    public void createTableExtensions(ExtensionFactory factory, XClass table) {
    }

    @Override
    public void createCatalogExtensions(ExtensionFactory factory, XClass catalog) {
    }

    @Override
    public void createSchemaExtensions(ExtensionFactory factory, XClass schema) {
    }

    @Override
    public String getColumnName() {
        return "";
    }

    @Override
    public String getCatalogName() {
        return "";
    }

    @Override
    public String getSchemaName() {
        return "";
    }

    @Override
    public String getTableName() {
        return "";
    }
}

