/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.processor;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.compare.selector.ModelSelector;
import org.teiid.designer.modelgenerator.processor.DatatypeFinder;
import org.teiid.designer.modelgenerator.processor.NullDatatypeFinder;

public class XsdDatatypeFinder
implements DatatypeFinder {
    private final ModelSelector datatypeModelSelector;
    private final DatatypeFinder bidtSelector;
    private boolean initialized;
    private final Map datatypeByName;

    public XsdDatatypeFinder(ModelSelector modelSelector, DatatypeFinder bidtSelector) {
        CoreArgCheck.isNotNull((Object)modelSelector);
        this.datatypeModelSelector = modelSelector;
        this.bidtSelector = bidtSelector != null ? bidtSelector : new NullDatatypeFinder();
        this.initialized = false;
        this.datatypeByName = new HashMap();
    }

    @Override
    public EObject findDatatype(String name) throws CoreException {
        LinkedList cached;
        if (!this.initialized) {
            this.initialize();
        }
        if (name != null && (cached = (LinkedList)this.datatypeByName.get(name)) != null && cached.size() != 0) {
            return (EObject)cached.getFirst();
        }
        return this.bidtSelector.findDatatype(name);
    }

    @Override
    public EObject findDatatype(URI uri) throws CoreException {
        LinkedList cached;
        if (!this.initialized) {
            this.initialize();
        }
        if (uri != null && (cached = (LinkedList)this.datatypeByName.get(uri.toString())) != null && cached.size() != 0) {
            return (EObject)cached.getFirst();
        }
        return this.bidtSelector.findDatatype(uri);
    }

    @Override
    public List findAllDatatypes(String name) throws CoreException {
        List bitypes;
        if (!this.initialized) {
            this.initialize();
        }
        LinkedList result = new LinkedList();
        if (name != null) {
            LinkedList cached = (LinkedList)this.datatypeByName.get(name);
            result.addAll(cached);
        }
        if ((bitypes = this.bidtSelector.findAllDatatypes(name)) != null && bitypes.size() != 0) {
            result.addAll(bitypes);
        }
        return result;
    }

    @Override
    public List findAllDatatypes(URI uri) throws CoreException {
        List bitypes;
        if (!this.initialized) {
            this.initialize();
        }
        LinkedList result = new LinkedList();
        if (uri != null) {
            LinkedList cached = (LinkedList)this.datatypeByName.get(uri.toString());
            result.addAll(cached);
        }
        if ((bitypes = this.bidtSelector.findAllDatatypes(uri)) != null && bitypes.size() != 0) {
            result.addAll(bitypes);
        }
        return result;
    }

    protected synchronized void initialize() throws CoreException {
        List roots = this.datatypeModelSelector.getRootObjects();
        for (EObject root : roots) {
            if (!(root instanceof XSDSchema)) continue;
            XSDSchema schema = (XSDSchema)root;
            EList typeDefns = schema.getTypeDefinitions();
            for (XSDTypeDefinition typeDefn : typeDefns) {
                URI uri;
                if (!(typeDefn instanceof XSDSimpleTypeDefinition)) continue;
                XSDSimpleTypeDefinition sdt = (XSDSimpleTypeDefinition)typeDefn;
                String name = sdt.getName();
                if (name != null && name.trim().length() != 0) {
                    LinkedList sdts = this.findListInMap(this.datatypeByName, name);
                    sdts.add(sdt);
                }
                if ((uri = EcoreUtil.getURI((EObject)sdt)) == null) continue;
                String uriString = uri.toString();
                LinkedList sdts = this.findListInMap(this.datatypeByName, uriString);
                sdts.add(sdt);
            }
        }
    }

    protected LinkedList findListInMap(Map map, Object key) {
        Object value = map.get(key);
        if (value == null) {
            LinkedList result = new LinkedList();
            map.put(key, result);
            return result;
        }
        if (value instanceof List) {
            return (LinkedList)value;
        }
        LinkedList result = new LinkedList();
        result.add(value);
        map.put(key, result);
        return result;
    }
}

