/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.roles.ui.wizard.panels;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.roles.ui.Messages;
import org.teiid.designer.roles.ui.wizard.DataRoleWizard;
import org.teiid.designer.roles.ui.wizard.dialogs.AbstractAddOrEditTitleDialog;
import org.teiid.designer.roles.ui.wizard.panels.DataRolePanel;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class AllowedLanguagesPanel
extends DataRolePanel {
    private ListViewer allowedLanguagesViewer;
    Button addButton;
    Button removeButton;

    public AllowedLanguagesPanel(Composite parent, DataRoleWizard wizard) {
        super(parent, wizard);
    }

    @Override
    void createControl() {
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(this.getPrimaryPanel());
        GridDataFactory.fillDefaults().applyTo((Control)this.getPrimaryPanel());
        this.allowedLanguagesViewer = new ListViewer(this.getPrimaryPanel(), 2816);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo(this.allowedLanguagesViewer.getControl());
        Composite toolbarPanel = WidgetFactory.createPanel((Composite)this.getPrimaryPanel(), (int)0, (int)2, (int)1, (int)2);
        this.addButton = WidgetFactory.createButton((Composite)toolbarPanel, (int)4);
        this.addButton.setText(Messages.add);
        this.addButton.setToolTipText(Messages.addAllowedLanguageTooltip);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AllowedLanguagesPanel.this.handleAdd();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeButton = WidgetFactory.createButton((Composite)toolbarPanel, (int)4);
        this.removeButton.setText(Messages.remove);
        this.removeButton.setToolTipText(Messages.removeAllowedLanguageTooltip);
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AllowedLanguagesPanel.this.handleRemove();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    void handleAdd() {
        AddLanguageDialog dialog = new AddLanguageDialog(this.getPrimaryPanel().getShell());
        if (dialog.open() == 0) {
            String language = dialog.getLanguage();
            this.getWizard().getTreeProvider().addAllowedLanguage(language);
            this.refresh();
            this.allowedLanguagesViewer.setSelection((ISelection)new StructuredSelection((Object)language), true);
        }
    }

    void handleRemove() {
        String selectedLanguage = this.getSelectedLanguage();
        assert (selectedLanguage != null);
        this.getWizard().getTreeProvider().removeAllowedLanguage(selectedLanguage);
        this.allowedLanguagesViewer.remove((Object)selectedLanguage);
        this.allowedLanguagesViewer.refresh();
    }

    private String getSelectedLanguage() {
        IStructuredSelection selection = (IStructuredSelection)this.allowedLanguagesViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (String)selection.getFirstElement();
    }

    @Override
    public void refresh() {
        this.allowedLanguagesViewer.getList().removeAll();
        for (String value : this.getWizard().getTreeProvider().getAllowedLanguages()) {
            this.allowedLanguagesViewer.add((Object)value);
        }
    }

    class AddLanguageDialog
    extends AbstractAddOrEditTitleDialog {
        private String selectedLanguage;
        private ListViewer languageViewer;

        public AddLanguageDialog(Shell parentShell) {
            super(parentShell, Messages.selectAllowedLanguage, Messages.selectAllowedLanguageMessage, false);
        }

        @Override
        protected void createCustomArea(Composite parent) {
            Group group = WidgetFactory.createGroup((Composite)parent, (String)Messages.allowedLanguages, (int)768, (int)2);
            this.languageViewer = new ListViewer((Composite)group, 2816);
            GridDataFactory.fillDefaults().grab(true, true).span(1, 1).applyTo(this.languageViewer.getControl());
            for (String lang : AllowedLanguagesPanel.this.getWizard().getAllowedLanguages()) {
                this.languageViewer.add((Object)lang);
            }
            this.languageViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)AddLanguageDialog.this.languageViewer.getSelection();
                    if (selection.isEmpty()) {
                        AddLanguageDialog.this.selectedLanguage = null;
                        AddLanguageDialog.this.getButton(0).setEnabled(false);
                    }
                    AddLanguageDialog.this.selectedLanguage = (String)selection.getFirstElement();
                    AddLanguageDialog.this.getButton(0).setEnabled(true);
                }
            });
        }

        public String getLanguage() {
            CoreArgCheck.isEqual((int)this.getReturnCode(), (int)0);
            return this.selectedLanguage;
        }

        @Override
        protected void handleInputChanged() {
        }

        @Override
        protected void validate() {
        }
    }
}

