/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.roles.ui.wizard;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.roles.Crud;
import org.teiid.designer.roles.DataRole;
import org.teiid.designer.roles.Permission;
import org.teiid.designer.roles.ui.Messages;
import org.teiid.designer.roles.ui.RolesUiPlugin;
import org.teiid.designer.roles.ui.wizard.DataRolesModelTreeProvider;
import org.teiid.designer.roles.ui.wizard.panels.AllowedLanguagesPanel;
import org.teiid.designer.roles.ui.wizard.panels.ColumnMaskingPanel;
import org.teiid.designer.roles.ui.wizard.panels.CrudPanel;
import org.teiid.designer.roles.ui.wizard.panels.RowBasedSecurityPanel;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.graphics.GlobalUiColorManager;
import org.teiid.designer.ui.common.text.StyledTextEditor;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.Dialog;
import org.teiid.designer.ui.common.widget.IListPanelController;
import org.teiid.designer.ui.common.widget.ListPanel;
import org.teiid.designer.ui.common.widget.ListPanelAdapter;
import org.teiid.designer.ui.common.wizard.AbstractWizard;

public class DataRoleWizard
extends AbstractWizard {
    private static final String I18N_PREFIX = "NewDataRoleWizard.";
    private static final String TITLE = Messages.dataRoleWizardTitle;
    private static final String EDIT_TITLE = Messages.editDataRoleWizardEditTitle;
    private static final ImageDescriptor IMAGE = RolesUiPlugin.getInstance().getImageDescriptor("icons/full/wizban/dataPolicyWizard.png");
    private static final String GENERATED_DEFAULT_NAME = "Data Role";
    private static final String SYS_ADMIN_TABLE_TARGET = "sysadmin";
    private static final String SYS_TABLE_TARGET = "sys";
    private DataRole existingDataRole;
    private Container tempContainer;
    private boolean isEdit = false;
    private WizardPage wizardPage;
    private CTabItem descTabItem;
    private CTabItem permissionsTabItem;
    private CTabItem roleNamesTabItem;
    private CTabItem optionsTabItem;
    private Text dataRoleNameText;
    private StyledTextEditor descriptionTextEditor;
    private Button allowSystemTablesCheckBox;
    private Button readSysCB;
    private Button executeSysCB;
    private Button anyAuthenticatedCheckBox;
    private Button allowCreateTempTablesCheckBox;
    private Button grantAllCheckBox;
    private ListPanel mappedRolesPanel;
    private CTabItem crudTabItem;
    private CrudPanel crudPanel;
    private CTabItem rowBasedCTabItem;
    private RowBasedSecurityPanel rowBasedSecurityPanel;
    private CTabItem columnsMaskingCTabItem;
    private ColumnMaskingPanel columnMaskingPanel;
    private CTabItem allowedLanguagesCTabItem;
    private AllowedLanguagesPanel allowLanguagesPanel;
    private DataRolesModelTreeProvider treeProvider;
    private String dataRoleName;
    private String description;
    private Set<String> mappedRoleNames;
    private boolean allowSystemTables;
    private boolean allowSystemRead;
    private boolean allowSystemExecute;
    private boolean anyAuthentication;
    private boolean allowCreateTempTables;
    private boolean grantAll;
    String roleNameTextEntry;
    private Set<String> allowedLanguages;
    private Set<String> otherDataRoleNames;

    private static String getString(String id) {
        return RolesUiPlugin.UTIL.getString(I18N_PREFIX + id, new Object[0]);
    }

    public DataRoleWizard(Container tempContainer, DataRole existingDataRole, Set<String> allowedLanguages, Set<String> otherDataRoleNames) {
        super((AbstractUIPlugin)RolesUiPlugin.getInstance(), TITLE, IMAGE);
        this.tempContainer = tempContainer;
        this.allowedLanguages = allowedLanguages;
        this.otherDataRoleNames = otherDataRoleNames;
        this.existingDataRole = existingDataRole;
        if (existingDataRole == null) {
            this.dataRoleName = StringUtilities.getUniqueName((String)GENERATED_DEFAULT_NAME, otherDataRoleNames, (boolean)true, (boolean)true, (int)1000);
            this.isEdit = false;
            this.allowSystemTables = true;
            this.anyAuthentication = false;
            this.allowCreateTempTables = false;
            this.grantAll = false;
            this.mappedRoleNames = new HashSet<String>();
        } else {
            this.dataRoleName = existingDataRole.getName();
            this.description = existingDataRole.getDescription();
            this.allowCreateTempTables = existingDataRole.allowCreateTempTables();
            this.anyAuthentication = existingDataRole.isAnyAuthenticated();
            this.grantAll = existingDataRole.doGrantAll();
            this.allowSystemTables = existingDataRole.getPermissionsMap().get(SYS_ADMIN_TABLE_TARGET) != null;
            this.isEdit = true;
            this.setWindowTitle(EDIT_TITLE);
            this.mappedRoleNames = new HashSet<String>(existingDataRole.getRoleNames());
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.wizardPage = new WizardPage(DataRoleWizard.class.getSimpleName(), TITLE, null){

            public void createControl(Composite parent) {
                this.setControl((Control)DataRoleWizard.this.createPageControl(parent));
            }
        };
        this.wizardPage.setPageComplete(false);
        if (this.isEdit) {
            this.wizardPage.setMessage(Messages.initialNewDataRoleMessage);
            this.wizardPage.setTitle(EDIT_TITLE);
        } else {
            this.wizardPage.setMessage(Messages.initialEditDataRoleMessage);
        }
        this.addPage((IWizardPage)this.wizardPage);
    }

    Composite createPageControl(Composite parent) {
        this.treeProvider = new DataRolesModelTreeProvider();
        Composite mainPanel = new Composite(parent, 0);
        GridData pgGD = new GridData(1808);
        mainPanel.setLayoutData((Object)pgGD);
        mainPanel.setLayout((Layout)new GridLayout(2, false));
        WidgetFactory.createLabel((Composite)mainPanel, (String)Messages.name);
        this.dataRoleNameText = WidgetFactory.createTextField((Composite)mainPanel, (int)768, (int)1, (String)this.dataRoleName);
        this.dataRoleNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DataRoleWizard.this.dataRoleName = DataRoleWizard.this.dataRoleNameText.getText();
                DataRoleWizard.this.validateInputs();
            }
        });
        new Label(mainPanel, 0);
        CTabFolder mainTabFolder = WidgetFactory.createTabFolder((Composite)mainPanel, (int)0);
        mainTabFolder.setLayout((Layout)new GridLayout(1, false));
        mainTabFolder.setBorderVisible(true);
        GridData folderGD = new GridData(1808);
        folderGD.horizontalSpan = 2;
        mainTabFolder.setLayoutData((Object)folderGD);
        this.createPermissionsTab(mainTabFolder);
        this.createOptionsTab(mainTabFolder);
        this.createRoleNamesTab(mainTabFolder);
        this.createDesciptionTab(mainTabFolder);
        mainTabFolder.setSelection(this.permissionsTabItem);
        if (this.isEdit) {
            this.loadExistingPermissions();
        }
        return mainPanel;
    }

    void createDesciptionTab(CTabFolder mainTabFolder) {
        this.descTabItem = new CTabItem(mainTabFolder, 0);
        this.descTabItem.setText(Messages.desciption);
        this.descriptionTextEditor = new StyledTextEditor((Composite)mainTabFolder, 2882);
        GridData descGridData = new GridData(1808);
        descGridData.horizontalSpan = 2;
        descGridData.heightHint = 50;
        descGridData.minimumHeight = 30;
        descGridData.grabExcessVerticalSpace = true;
        this.descriptionTextEditor.setLayoutData((Object)descGridData);
        if (this.description != null) {
            this.descriptionTextEditor.setText(this.description);
        } else {
            this.descriptionTextEditor.setText("");
        }
        this.descriptionTextEditor.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                DataRoleWizard.this.description = DataRoleWizard.this.descriptionTextEditor.getText();
                DataRoleWizard.this.handleDescriptionChanged();
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        this.descTabItem.setControl((Control)this.descriptionTextEditor.getTextWidget());
    }

    void createPermissionsTab(CTabFolder mainTabFolder) {
        this.permissionsTabItem = new CTabItem(mainTabFolder, 0);
        this.permissionsTabItem.setText(Messages.permissions);
        Composite permissionsPanel = WidgetFactory.createPanel((Composite)mainTabFolder, (int)1808, (int)2, (int)2);
        GridData modelsGridData = new GridData(1808);
        modelsGridData.horizontalSpan = 2;
        modelsGridData.heightHint = 220;
        modelsGridData.minimumHeight = 220;
        modelsGridData.grabExcessVerticalSpace = true;
        modelsGridData.horizontalIndent = 5;
        modelsGridData.verticalIndent = 5;
        permissionsPanel.setLayoutData((Object)modelsGridData);
        Label infoLabel = new Label(permissionsPanel, 0);
        infoLabel.setText(Messages.permissionsTabHelpText);
        infoLabel.setForeground(GlobalUiColorManager.EMPHASIS_COLOR);
        GridData gd_1 = new GridData();
        gd_1.horizontalSpan = 2;
        infoLabel.setLayoutData((Object)gd_1);
        new Label(permissionsPanel, 0);
        CTabFolder tabFolder = WidgetFactory.createTabFolder((Composite)permissionsPanel);
        tabFolder.setBorderVisible(true);
        this.crudTabItem = new CTabItem(tabFolder, 0);
        this.crudTabItem.setText(Messages.model);
        this.crudPanel = new CrudPanel((Composite)tabFolder, this);
        this.crudTabItem.setControl((Control)this.crudPanel.getPrimaryPanel());
        this.rowBasedCTabItem = new CTabItem(tabFolder, 0);
        this.rowBasedCTabItem.setText(Messages.conditions);
        this.rowBasedSecurityPanel = new RowBasedSecurityPanel((Composite)tabFolder, this);
        this.rowBasedCTabItem.setControl((Control)this.rowBasedSecurityPanel.getPrimaryPanel());
        this.columnsMaskingCTabItem = new CTabItem(tabFolder, 0);
        this.columnsMaskingCTabItem.setText(Messages.columnMasking);
        this.columnMaskingPanel = new ColumnMaskingPanel((Composite)tabFolder, this);
        this.columnsMaskingCTabItem.setControl((Control)this.columnMaskingPanel.getPrimaryPanel());
        this.allowedLanguagesCTabItem = new CTabItem(tabFolder, 0);
        this.allowedLanguagesCTabItem.setText(Messages.allowedLanguages);
        this.allowLanguagesPanel = new AllowedLanguagesPanel((Composite)tabFolder, this);
        this.allowedLanguagesCTabItem.setControl((Control)this.allowLanguagesPanel.getPrimaryPanel());
        tabFolder.setSelection(this.crudTabItem);
        this.permissionsTabItem.setControl((Control)permissionsPanel);
    }

    void createRoleNamesTab(CTabFolder mainTabFolder) {
        this.roleNamesTabItem = new CTabItem(mainTabFolder, 0);
        this.roleNamesTabItem.setText(Messages.mappedRoleNames);
        this.roleNamesTabItem.setToolTipText(Messages.mappedRoleNamesTabDescription);
        Composite roleNamespanel = WidgetFactory.createPanel((Composite)mainTabFolder, (int)0, (int)768, (int)2);
        this.anyAuthenticatedCheckBox = WidgetFactory.createCheckBox((Composite)roleNamespanel, (String)DataRoleWizard.getString("anyAuthenticatedCheckbox.label"), (int)0, (int)1, (boolean)this.anyAuthentication);
        this.anyAuthenticatedCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DataRoleWizard.this.anyAuthentication = DataRoleWizard.this.anyAuthenticatedCheckBox.getSelection();
                if (DataRoleWizard.this.mappedRolesPanel != null) {
                    DataRoleWizard.this.mappedRolesPanel.setEnabled(!DataRoleWizard.this.anyAuthentication);
                }
            }
        });
        ListPanelAdapter ctrlr = new ListPanelAdapter(){

            public Object[] addButtonSelected() {
                String label;
                String title = DataRoleWizard.getString("roleInputDialog.title");
                String textEntry = DataRoleWizard.this.showTextEntryDialog(title, label = DataRoleWizard.getString("roleInputDialog.label"), null);
                if (textEntry == null || textEntry.length() <= 0) {
                    return Collections.EMPTY_LIST.toArray();
                }
                DataRoleWizard.this.mappedRoleNames.add(textEntry);
                DataRoleWizard.this.handleMappedRoleNameChanged();
                return new String[]{textEntry};
            }

            public Object[] removeButtonSelected(IStructuredSelection selection) {
                Object[] objArray;
                Object[] objectArray = objArray = selection.toArray();
                int n = objArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    DataRoleWizard.this.mappedRoleNames.remove(obj);
                    ++n2;
                }
                DataRoleWizard.this.handleMappedRoleNameChanged();
                return objArray;
            }

            public Object editButtonSelected(IStructuredSelection selection) {
                String label;
                Object[] objArray = selection.toArray();
                String title = DataRoleWizard.getString("roleInputDialog.title");
                String textEntry = DataRoleWizard.this.showTextEntryDialog(title, label = DataRoleWizard.getString("roleInputDialog.label"), (String)objArray[0]);
                if (textEntry == null || textEntry.length() <= 0) {
                    return null;
                }
                DataRoleWizard.this.mappedRoleNames.add(textEntry);
                DataRoleWizard.this.handleMappedRoleNameChanged();
                return textEntry;
            }

            public void itemsSelected(IStructuredSelection selection) {
                Object[] objArray = selection.toArray();
                boolean enableEdit = true;
                enableEdit = objArray == null ? false : objArray.length != 1;
                DataRoleWizard.this.mappedRolesPanel.getButton(InternalUiConstants.Widgets.EDIT_BUTTON).setEnabled(enableEdit);
            }
        };
        this.mappedRolesPanel = new ListPanel(roleNamespanel, " ", (IListPanelController)ctrlr, 768, 2);
        GridData rolesGridData = new GridData(1808);
        rolesGridData.horizontalSpan = 2;
        rolesGridData.heightHint = 80;
        rolesGridData.minimumHeight = 80;
        rolesGridData.grabExcessVerticalSpace = true;
        this.mappedRolesPanel.setLayoutData((Object)rolesGridData);
        this.mappedRolesPanel.getButton(InternalUiConstants.Widgets.EDIT_BUTTON).setEnabled(false);
        this.mappedRolesPanel.getButton(InternalUiConstants.Widgets.REMOVE_BUTTON).setEnabled(false);
        this.mappedRolesPanel.setEnabled(!this.anyAuthentication);
        this.roleNamesTabItem.setControl((Control)roleNamespanel);
    }

    void createOptionsTab(CTabFolder mainTabFolder) {
        this.optionsTabItem = new CTabItem(mainTabFolder, 0);
        this.optionsTabItem.setText(Messages.options);
        this.optionsTabItem.setToolTipText(Messages.optionsTabDescription);
        Composite miscOptionsGroup = WidgetFactory.createPanel((Composite)mainTabFolder, (int)768, (int)2, (int)3);
        this.allowCreateTempTablesCheckBox = WidgetFactory.createCheckBox((Composite)miscOptionsGroup, (String)DataRoleWizard.getString("allowCreateTempTablesCheckBox.label"), (int)768, (int)1, (boolean)this.anyAuthentication);
        this.allowCreateTempTablesCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DataRoleWizard.this.allowCreateTempTables = DataRoleWizard.this.allowCreateTempTablesCheckBox.getSelection();
            }
        });
        this.grantAllCheckBox = WidgetFactory.createCheckBox((Composite)miscOptionsGroup, (String)DataRoleWizard.getString("grantAllCheckBox.label"), (int)768, (int)1, (boolean)this.grantAll);
        this.grantAllCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DataRoleWizard.this.grantAll = DataRoleWizard.this.grantAllCheckBox.getSelection();
            }
        });
        Group sysTablesGroup = WidgetFactory.createGroup((Composite)miscOptionsGroup, (String)DataRoleWizard.getString("systemTablesAccess.label"), (int)768, (int)2, (int)2);
        this.allowSystemTablesCheckBox = WidgetFactory.createCheckBox((Composite)sysTablesGroup, (String)DataRoleWizard.getString("systemTablesCheckbox.label"), (int)0, (int)2, (boolean)this.allowSystemTables);
        this.allowSystemTablesCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DataRoleWizard.this.allowSystemTables = DataRoleWizard.this.allowSystemTablesCheckBox.getSelection();
                DataRoleWizard.this.readSysCB.setEnabled(DataRoleWizard.this.allowSystemTables);
                DataRoleWizard.this.executeSysCB.setEnabled(DataRoleWizard.this.allowSystemTables);
                if (DataRoleWizard.this.allowSystemTables) {
                    DataRoleWizard.this.readSysCB.setSelection(true);
                    DataRoleWizard.this.allowSystemRead = true;
                }
            }
        });
        Group sysTablesPermissions = WidgetFactory.createGroup((Composite)sysTablesGroup, (String)"", (int)768, (int)2, (int)1);
        this.readSysCB = WidgetFactory.createCheckBox((Composite)sysTablesPermissions, (String)Messages.read.toUpperCase(), (int)0, (int)1, (boolean)false);
        this.readSysCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DataRoleWizard.this.allowSystemRead = DataRoleWizard.this.readSysCB.getSelection();
                if (!DataRoleWizard.this.allowSystemRead && !DataRoleWizard.this.allowSystemExecute) {
                    DataRoleWizard.this.allowSystemTables = false;
                    DataRoleWizard.this.allowSystemTablesCheckBox.setSelection(false);
                    DataRoleWizard.this.allowSystemTables = false;
                } else {
                    DataRoleWizard.this.allowSystemTablesCheckBox.setSelection(true);
                    DataRoleWizard.this.allowSystemTables = true;
                }
            }
        });
        this.executeSysCB = WidgetFactory.createCheckBox((Composite)sysTablesPermissions, (String)Messages.execute.toUpperCase(), (int)0, (int)1, (boolean)false);
        this.executeSysCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DataRoleWizard.this.allowSystemExecute = DataRoleWizard.this.executeSysCB.getSelection();
                if (!DataRoleWizard.this.allowSystemRead && !DataRoleWizard.this.allowSystemExecute) {
                    DataRoleWizard.this.allowSystemTables = false;
                    DataRoleWizard.this.allowSystemTablesCheckBox.setSelection(false);
                    DataRoleWizard.this.allowSystemTables = false;
                } else {
                    DataRoleWizard.this.allowSystemTablesCheckBox.setSelection(true);
                    DataRoleWizard.this.allowSystemTables = true;
                }
            }
        });
        this.optionsTabItem.setControl((Control)miscOptionsGroup);
    }

    public void refreshAllTabs() {
        this.crudPanel.refresh();
        this.rowBasedSecurityPanel.refresh();
        this.columnMaskingPanel.refresh();
    }

    private void loadExistingPermissions() {
        this.dataRoleName = this.existingDataRole.getName();
        this.anyAuthentication = this.existingDataRole.isAnyAuthenticated();
        this.allowCreateTempTables = this.existingDataRole.allowCreateTempTables();
        this.grantAll = this.existingDataRole.doGrantAll();
        this.dataRoleNameText.setText(this.existingDataRole.getName());
        this.mappedRolesPanel.addItems(this.existingDataRole.getRoleNames().toArray());
        this.descriptionTextEditor.setText(this.existingDataRole.getDescription());
        this.treeProvider.loadPermissions(this.existingDataRole.getPermissions());
        boolean foundSystemPermission = false;
        for (Permission perm : this.existingDataRole.getPermissions()) {
            if (!perm.getTargetName().equalsIgnoreCase(SYS_ADMIN_TABLE_TARGET) && !perm.getTargetName().equalsIgnoreCase(SYS_TABLE_TARGET)) continue;
            this.allowSystemTables = true;
            this.allowSystemTablesCheckBox.setSelection(this.allowSystemTables);
            foundSystemPermission = true;
            this.allowSystemRead = perm.getCRUDValue(Crud.Type.READ);
            this.readSysCB.setSelection(this.allowSystemRead);
            this.allowSystemExecute = perm.getCRUDValue(Crud.Type.EXECUTE);
            this.executeSysCB.setSelection(this.allowSystemExecute);
            this.readSysCB.setEnabled(this.allowSystemTables);
            this.executeSysCB.setEnabled(this.allowSystemTables);
        }
        if (!foundSystemPermission) {
            this.allowSystemTables = false;
            this.allowSystemTablesCheckBox.setSelection(false);
            this.readSysCB.setEnabled(this.allowSystemTables);
            this.executeSysCB.setEnabled(this.allowSystemTables);
        }
        this.anyAuthenticatedCheckBox.setSelection(this.anyAuthentication);
        this.allowCreateTempTablesCheckBox.setSelection(this.allowCreateTempTables);
        this.mappedRolesPanel.setEnabled(!this.anyAuthentication);
        this.grantAllCheckBox.setEnabled(true);
        this.refreshAll();
        this.validateInputs();
    }

    private void refreshAll() {
        this.crudPanel.refresh();
        this.rowBasedSecurityPanel.refresh();
        this.columnMaskingPanel.refresh();
        this.allowLanguagesPanel.refresh();
    }

    public boolean canFinish() {
        boolean canFinish = true;
        return canFinish;
    }

    public boolean finish() {
        return true;
    }

    private void handleMappedRoleNameChanged() {
        if (this.anyAuthentication || this.mappedRoleNames.isEmpty()) {
            this.mappedRoleNames.clear();
        }
    }

    private void handleDescriptionChanged() {
    }

    public DataRole getFinalDataRole() {
        if (this.existingDataRole == null) {
            this.existingDataRole = new DataRole(this.dataRoleName);
        }
        this.existingDataRole.setName(this.dataRoleName);
        this.existingDataRole.setAnyAuthenticated(this.anyAuthentication);
        this.existingDataRole.setAllowCreateTempTables(this.allowCreateTempTables);
        this.existingDataRole.setGrantAll(this.grantAll);
        this.existingDataRole.setDescription(this.description);
        this.existingDataRole.setPermissions(this.treeProvider.getPermissions());
        Permission systemPerm = (Permission)this.existingDataRole.getPermissionsMap().get(SYS_ADMIN_TABLE_TARGET);
        if (this.allowSystemTables) {
            if (systemPerm == null) {
                this.existingDataRole.addPermission(new Permission(SYS_ADMIN_TABLE_TARGET, Boolean.valueOf(false), Boolean.valueOf(this.allowSystemRead), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(this.allowSystemExecute), Boolean.valueOf(false)));
            }
        } else if (systemPerm != null) {
            this.existingDataRole.removePermission(systemPerm);
        }
        if (!this.anyAuthentication && !this.mappedRoleNames.isEmpty()) {
            this.existingDataRole.setRoleNames(this.mappedRoleNames);
        } else {
            this.existingDataRole.getRoleNames().clear();
        }
        return this.existingDataRole;
    }

    public DataRolesModelTreeProvider getTreeProvider() {
        return this.treeProvider;
    }

    public Container getTempContainer() {
        return this.tempContainer;
    }

    public Set<String> getAllowedLanguages() {
        return this.allowedLanguages;
    }

    public void validateInputs() {
        if (this.dataRoleName == null || this.dataRoleName.length() == 0) {
            this.wizardPage.setErrorMessage(DataRoleWizard.getString("nullNameMessage"));
            this.wizardPage.setPageComplete(false);
            return;
        }
        if (this.otherDataRoleNames.contains(this.dataRoleName)) {
            this.wizardPage.setErrorMessage(NLS.bind((String)Messages.dataRoleExists_0_Message, (Object)this.dataRoleName));
            this.wizardPage.setPageComplete(false);
            return;
        }
        this.wizardPage.setErrorMessage(null);
        this.wizardPage.setMessage(DataRoleWizard.getString("okToFinishMessage"));
        this.wizardPage.setPageComplete(true);
    }

    String showTextEntryDialog(String title, final String label, String initialText) {
        final String text = initialText;
        Shell shell = this.wizardPage.getShell();
        Dialog dlg = new Dialog(shell, title){

            protected Control createDialogArea(Composite parent) {
                Composite dlgPanel = (Composite)super.createDialogArea(parent);
                dlgPanel.setLayoutData((Object)new GridData(400, 80));
                Group group = WidgetFactory.createGroup((Composite)dlgPanel, (String)label, (int)1808, (int)1, (int)1);
                final Text nameText = WidgetFactory.createTextField((Composite)group, (int)768);
                if (text != null) {
                    nameText.setText(text);
                }
                nameText.setSelection(0);
                nameText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent event) {
                        this.handleModifyText(nameText);
                    }
                });
                return dlgPanel;
            }

            protected void createButtonsForButtonBar(Composite parent) {
                super.createButtonsForButtonBar(parent);
                this.getButton(0).setEnabled(false);
            }

            void handleModifyText(Text nameText) {
                String newName = nameText.getText();
                boolean valid = newName.length() > 0;
                this.getButton(0).setEnabled(valid);
                if (valid) {
                    DataRoleWizard.this.roleNameTextEntry = nameText.getText();
                }
            }
        };
        if (dlg.open() == 0) {
            return this.roleNameTextEntry;
        }
        return null;
    }
}

