/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xml.ui.wizards;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.xsd.XSDElementDeclaration;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.mapping.factory.MappingClassBuilderStrategy;
import org.teiid.designer.ui.wizards.INewModelWizardContributor;
import org.teiid.designer.xml.ui.ModelerXmlUiConstants;
import org.teiid.designer.xml.ui.wizards.NewDocumentWizardModel;
import org.teiid.designer.xml.ui.wizards.NewVirtualDocumentWizardPage;
import org.teiid.designer.xml.ui.wizards.PreviewVirtualDocumentWizardPage;
import org.teiid.designer.xml.ui.wizards.VirtualDocumentStatisticsWizardPage;
import org.teiid.designer.xml.ui.wizards.XMLDocumentWizard;

public class VirtualDocumentWizardContributor
implements INewModelWizardContributor,
ModelerXmlUiConstants {
    private IWizardPage[] pages;
    private NewVirtualDocumentWizardPage newVirtualDocumentPage;
    private VirtualDocumentStatisticsWizardPage statsPage;
    private PreviewVirtualDocumentWizardPage previewVDocPage;
    private IWizardPage priorPage;
    private NewDocumentWizardModel model;
    private XSDElementDeclaration[] docRoots;
    private MappingClassBuilderStrategy strategy;

    public boolean canFinishEarly(IWizardPage theCurrentPage) {
        return true;
    }

    public void createWizardPages(ISelection selection, IResource targetResource, IPath targetFilePath, MetamodelDescriptor descriptor, boolean isVirtual) {
        this.model = new NewDocumentWizardModel();
        this.newVirtualDocumentPage = new NewVirtualDocumentWizardPage(this.model, selection);
        this.model.setSource(this.newVirtualDocumentPage);
        this.statsPage = new VirtualDocumentStatisticsWizardPage(this.model);
        this.previewVDocPage = new PreviewVirtualDocumentWizardPage(this.model);
        this.pages = new IWizardPage[]{this.newVirtualDocumentPage, this.statsPage, this.previewVDocPage};
        if (this.docRoots != null) {
            this.newVirtualDocumentPage.setXsdRoots(this.docRoots);
        }
        if (this.strategy != null) {
            this.newVirtualDocumentPage.setMappingClassBuilderStrategy(this.strategy);
        }
    }

    public void doCancel() {
    }

    public void doFinish(ModelResource modelResource, IProgressMonitor monitor) {
        IWizardContainer container = this.previewVDocPage.getWizard().getContainer();
        XMLDocumentWizard.finishWizard(this.newVirtualDocumentPage, this.previewVDocPage, modelResource, container, this.model);
    }

    public IWizardPage[] getWizardPages() {
        return this.pages;
    }

    public void inputChanged(ISelection selection, IResource targetResource, MetamodelDescriptor descriptor, boolean isVirtual) {
    }

    public void currentPageChanged(IWizardPage page) {
        IWizard wizard = page.getWizard();
        if (wizard instanceof Wizard) {
            Wizard wiz = (Wizard)wizard;
            wiz.setNeedsProgressMonitor(true);
        }
        try {
            XMLDocumentWizard.DocSrcUpdater dsi = this.priorPage == this.newVirtualDocumentPage && page == this.statsPage ? new XMLDocumentWizard.DocSrcUpdater(this.statsPage, true, this.model.getSelectedFragmentCount()) : (page == this.previewVDocPage ? new XMLDocumentWizard.DocSrcUpdater(this.previewVDocPage, true, this.model.getEstimatedNodeCount()) : null);
            if (dsi != null) {
                wizard.getContainer().run(true, true, (IRunnableWithProgress)dsi);
            }
        }
        catch (Exception ex) {
            Util.log((Throwable)ex);
        }
        this.priorPage = page;
    }

    public void setDocumentRoots(XSDElementDeclaration[] theRoots) {
        this.docRoots = theRoots;
        if (this.newVirtualDocumentPage != null) {
            this.newVirtualDocumentPage.setXsdRoots(theRoots);
        }
    }

    public void setMappingClassBuilderStrategy(MappingClassBuilderStrategy theStrategy) {
        this.strategy = theStrategy;
        if (this.newVirtualDocumentPage != null) {
            this.newVirtualDocumentPage.setMappingClassBuilderStrategy(theStrategy);
        }
    }
}

