/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xml.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.metamodels.xml.XmlDocumentBuilderImpl;
import org.teiid.designer.metamodels.xml.XmlElement;
import org.teiid.designer.ui.common.wizard.AbstractWizard;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.xml.ui.ModelerXmlUiConstants;
import org.teiid.designer.xml.ui.ModelerXmlUiPlugin;
import org.teiid.designer.xml.ui.wizards.NumberOfLevelsWizardPage;

public class NumberOfLevelsWizard
extends AbstractWizard
implements ModelerXmlUiConstants {
    private NumberOfLevelsWizardPage page;

    public NumberOfLevelsWizard() {
        super((AbstractUIPlugin)ModelerXmlUiPlugin.getDefault(), null, null);
    }

    public boolean finish() {
        final XmlElement element = this.getSelectedElement();
        final int levels = this.page.getValue();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor theMonitor) {
                ModelResource mr = ModelUtilities.getModelResourceForModelObject((EObject)element);
                if (mr != null) {
                    ModelEditorManager.openInEditMode((Object)mr, (boolean)true, (int)0);
                }
                String description = Util.getString("NumberOfLevelsWizard.transactionText", new Object[0]);
                boolean started = ModelerCore.startTxn((boolean)true, (boolean)true, (String)description, (Object)this);
                boolean succeeded = false;
                try {
                    try {
                        XmlDocumentBuilderImpl builder = new XmlDocumentBuilderImpl(levels);
                        builder.buildDocument(element, theMonitor);
                        succeeded = true;
                    }
                    catch (Exception theException) {
                        String msg = Util.getString("NumberOfLevelsWizard.buildErrorMessage", new Object[0]);
                        Util.log(4, (Throwable)theException, msg);
                        if (started) {
                            if (succeeded) {
                                ModelerCore.commitTxn();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                        theMonitor.done();
                    }
                }
                finally {
                    if (started) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                    theMonitor.done();
                }
            }
        };
        try {
            IWizardContainer container = this.getContainer();
            container.run(false, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)Util.getString("NumberOfLevelsWizard.error", new Object[0]), (String)realException.getMessage());
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.page = new NumberOfLevelsWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    protected XmlElement getSelectedElement() {
        ISelection selection;
        IWorkbenchWindow window = ModelerXmlUiPlugin.getDefault().getCurrentWorkbenchWindow();
        if (window != null && (selection = window.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            if (ssel instanceof XmlElement) {
                return (XmlElement)ssel;
            }
            Object firstElement = ssel.getFirstElement();
            if (firstElement instanceof XmlElement) {
                return (XmlElement)firstElement;
            }
            return null;
        }
        return null;
    }
}

