/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xml.ui.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDTypeDefinition;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.metamodels.xml.XmlAttribute;
import org.teiid.designer.metamodels.xml.XmlContainerNode;
import org.teiid.designer.metamodels.xml.XmlDocumentBuilderImpl;
import org.teiid.designer.metamodels.xml.XmlDocumentEntity;
import org.teiid.designer.metamodels.xml.XmlDocumentNode;
import org.teiid.designer.metamodels.xml.XmlElement;
import org.teiid.designer.metamodels.xml.XmlFragment;
import org.teiid.designer.metamodels.xml.XmlRoot;
import org.teiid.designer.metamodels.xml.util.XmlDocumentUtil;
import org.teiid.designer.ui.OverlayImageIcon;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.tree.AbstractTreeContentProvider;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.DefaultTreeViewerController;
import org.teiid.designer.ui.common.widget.ITreeViewerController;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.xml.IVirtualDocumentFragmentSource;
import org.teiid.designer.xml.ui.ModelerXmlUiConstants;
import org.teiid.designer.xml.ui.ModelerXmlUiPlugin;

public class EditVirtualDocumentsPanel
extends Composite
implements IVirtualDocumentFragmentSource {
    static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final XmlFragment[] EMPTY_FRAGMENT_ARRAY = new XmlFragment[0];
    CheckboxTreeViewer viewer;
    VDocContentProvider content;
    VDocTreeViewerController controller;
    XmlFragment[] roots;
    Set wasStopped = new HashSet();
    Set wasRecursive = new HashSet();
    int stopExpansion;

    public EditVirtualDocumentsPanel(Composite parent) {
        super(parent, 0);
        this.initializeGUI();
    }

    private void initializeGUI() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        EditVirtualDocumentsPanel useParent = this;
        this.controller = new VDocTreeViewerController();
        this.content = new VDocContentProvider();
        this.viewer = (CheckboxTreeViewer)WidgetFactory.createTreeViewer((Composite)useParent, (int)32, (ITreeViewerController)this.controller);
        this.viewer.setContentProvider((IContentProvider)this.content);
        VDocLabelProvider vdocLabelProvider = new VDocLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)vdocLabelProvider);
        this.viewer.getTree().addDisposeListener((DisposeListener)vdocLabelProvider);
        this.viewer.setInput((Object)this.roots);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new VDocSelectionListener());
        Control tree = this.viewer.getControl();
        tree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                EditVirtualDocumentsPanel.this.stopExpansion = 0;
            }

            public void keyReleased(KeyEvent e) {
                EditVirtualDocumentsPanel.this.stopExpansion = 0;
            }
        });
        tree.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                EditVirtualDocumentsPanel.this.stopExpansion = 0;
            }

            public void mouseDown(MouseEvent e) {
                EditVirtualDocumentsPanel.this.stopExpansion = 0;
            }

            public void mouseUp(MouseEvent e) {
                EditVirtualDocumentsPanel.this.stopExpansion = 0;
            }
        });
    }

    static void buildNextLevelFromSchema(XmlElement element) {
        ModelResource mr = ModelUtilities.getModelResourceForModelObject((EObject)element);
        if (mr != null && !mr.isOpen()) {
            ModelEditorManager.activate((ModelResource)mr, (boolean)true);
        }
        try {
            XmlDocumentBuilderImpl builder = new XmlDocumentBuilderImpl(1);
            builder.buildDocument(element, null);
        }
        catch (Exception theException) {
            String msg = ModelerXmlUiConstants.Util.getString("NumberOfLevelsWizard.buildErrorMessage", new Object[0]);
            ModelerXmlUiConstants.Util.log(4, (Throwable)theException, msg);
        }
        XmlDocumentUtil.setAllExcluded((XmlDocumentEntity)element, (boolean)true);
    }

    public XmlFragment[] getFragments(ModelResource modelResource, IProgressMonitor monitor) {
        ArrayList<XmlFragment> rv = new ArrayList<XmlFragment>(this.roots.length);
        int i = 0;
        while (i < this.roots.length) {
            XmlFragment root = this.roots[i];
            try {
                boolean panelHidden;
                boolean bl = panelHidden = !this.isVisible();
                if (this.viewer.getChecked((Object)root) || panelHidden) {
                    EditVirtualDocumentsPanel.pruneChildren((XmlDocumentEntity)root, this.wasStopped, this.wasRecursive);
                    rv.add(root);
                } else {
                    ModelerCore.getModelEditor().delete((EObject)root, false);
                }
            }
            catch (ModelerCoreException ex) {
                ModelerXmlUiConstants.Util.log((Throwable)ex);
            }
            ++i;
        }
        return rv.toArray(EMPTY_FRAGMENT_ARRAY);
    }

    public Collection getRoots(IProgressMonitor monitor) {
        if (this.roots == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(this.roots);
    }

    public boolean haveFragmentsChanged() {
        return true;
    }

    public void updateSourceFragments(boolean isVisible, IProgressMonitor monitor) {
    }

    private static void pruneChildren(XmlDocumentEntity node, Set wasStopped, Set wasRecursive) throws ModelerCoreException {
        ArrayList kids = new ArrayList(node.eContents());
        int i = 0;
        while (i < kids.size()) {
            XmlDocumentEntity kid = (XmlDocumentEntity)kids.get(i);
            if (XmlDocumentUtil.isExcluded((Object)kid, (boolean)false)) {
                ModelerCore.getModelEditor().delete((EObject)kid, false);
            } else {
                boolean hasElements;
                if (!XmlDocumentUtil.isIncomplete((Object)kid)) {
                    EditVirtualDocumentsPanel.pruneChildren(kid, wasStopped, wasRecursive);
                }
                if (!(hasElements = XmlDocumentUtil.hasElementChildren((XmlDocumentEntity)kid))) {
                    if (kid instanceof XmlContainerNode) {
                        ModelerCore.getModelEditor().delete((EObject)kid);
                    } else {
                        if (wasStopped.contains(kid)) {
                            XmlDocumentUtil.setIncomplete((Object)kid, (boolean)true);
                        }
                        if (wasRecursive.contains(kid)) {
                            XmlDocumentUtil.setRecursive((Object)kid, (boolean)true);
                        }
                    }
                }
            }
            ++i;
        }
    }

    public XmlFragment[] getStartingFragments() {
        return this.roots;
    }

    public void setFragments(XmlFragment[] docRoots) {
        this.roots = docRoots;
    }

    public void setStartingFragments(XmlFragment[] docRoots, final boolean isVisible, final IProgressMonitor monitor) {
        this.roots = docRoots;
        if (this.viewer != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (isVisible) {
                        EditVirtualDocumentsPanel.this.viewer.setInput((Object)EditVirtualDocumentsPanel.this.roots);
                    }
                }
            });
            int i = 0;
            while (i < docRoots.length) {
                EditVirtualDocumentsPanel.walkTreeAndCheck((ITreeContentProvider)this.content, docRoots[i], isVisible ? this.viewer : null, monitor);
                ++i;
            }
            monitor.subTask(ModelerXmlUiConstants.Util.getString("EditVirtualDocumentsPanel.subtaskDisplaying", new Object[0]));
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (EditVirtualDocumentsPanel.this.roots.length > 0) {
                        EditVirtualDocumentsPanel.this.viewer.setSelection((ISelection)new StructuredSelection((Object)EditVirtualDocumentsPanel.this.roots[0]));
                        int i = 0;
                        while (i < EditVirtualDocumentsPanel.this.roots.length) {
                            XmlFragment fragment = EditVirtualDocumentsPanel.this.roots[i];
                            EditVirtualDocumentsPanel.this.viewer.setChecked((Object)fragment, true);
                            EditVirtualDocumentsPanel.this.controller.checkRequiredChildren(fragment);
                            if (isVisible) {
                                monitor.worked(1);
                            }
                            ++i;
                        }
                    }
                }
            });
        }
    }

    private static void walkTreeAndCheck(ITreeContentProvider tcp, final Object current, final CheckboxTreeViewer viewer, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        boolean onlyAttributeKids = true;
        Object[] kids = null;
        if (!XmlDocumentUtil.isIncomplete((Object)current)) {
            if (viewer != null) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        viewer.setChecked(current, true);
                    }
                });
            }
            kids = tcp.getChildren(current);
            int i = 0;
            while (i < kids.length) {
                if (monitor.isCanceled()) {
                    return;
                }
                Object kid = kids[i];
                EditVirtualDocumentsPanel.walkTreeAndCheck(tcp, kid, viewer, monitor);
                if (!(kid instanceof XmlAttribute)) {
                    onlyAttributeKids = false;
                }
                ++i;
            }
        } else {
            EditVirtualDocumentsPanel.setExcluded(current, true);
        }
        if (monitor.isCanceled()) {
            return;
        }
        if (viewer != null && kids != null && kids.length > 0 && !onlyAttributeKids) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    viewer.expandToLevel(current, 1);
                }
            });
        }
        monitor.worked(1);
    }

    static void setExcluded(Object element, boolean exclude) {
        boolean startedTxn = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set Excluded", null);
        boolean succeeded = false;
        try {
            XmlDocumentUtil.setExcluded((Object)element, (boolean)exclude);
            succeeded = true;
        }
        finally {
            if (startedTxn) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    private static class ImageKey {
        private Image image;
        private boolean recursive;
        private boolean incomplete;
        private int cardinality;

        public ImageKey(Image image, boolean recursive, boolean incomplete, int cardinality) {
            this.image = image;
            this.recursive = recursive;
            this.incomplete = incomplete;
            this.cardinality = cardinality;
        }

        public int getCardinality() {
            return this.cardinality;
        }

        public boolean isIncomplete() {
            return this.incomplete;
        }

        public Image getImage() {
            return this.image;
        }

        public boolean isRecursive() {
            return this.recursive;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            ImageKey castedObj = (ImageKey)o;
            return (this.image == null ? castedObj.image == null : this.image.equals((Object)castedObj.image)) && this.recursive == castedObj.recursive && this.incomplete == castedObj.incomplete && this.cardinality == castedObj.cardinality;
        }

        public int hashCode() {
            int hashCode = 1;
            hashCode = 31 * hashCode + (this.image == null ? 0 : this.image.hashCode());
            hashCode = 31 * hashCode + (this.recursive ? 1231 : 1237);
            hashCode = 31 * hashCode + this.cardinality;
            return hashCode;
        }
    }

    class VDocContentProvider
    extends AbstractTreeContentProvider {
        VDocContentProvider() {
        }

        public boolean hasChildren(Object element) {
            if (EditVirtualDocumentsPanel.this.stopExpansion > 1) {
                return false;
            }
            if (element == EditVirtualDocumentsPanel.this.roots && EditVirtualDocumentsPanel.this.roots.length > 0) {
                return true;
            }
            if (XmlDocumentUtil.isIncomplete((Object)element)) {
                if (element instanceof XmlDocumentNode) {
                    XmlDocumentNode dnode = (XmlDocumentNode)element;
                    boolean isComplex = XmlDocumentUtil.hasComplexType((Object)dnode);
                    if (!isComplex) {
                        XmlDocumentUtil.setIncomplete((Object)element, (boolean)false);
                    }
                    return isComplex;
                }
                return true;
            }
            return !((XmlDocumentEntity)element).eContents().isEmpty();
        }

        public Object[] getChildren(Object element) {
            if (EditVirtualDocumentsPanel.this.stopExpansion > 1) {
                return EMPTY_OBJECT_ARRAY;
            }
            if (element == EditVirtualDocumentsPanel.this.roots) {
                return EditVirtualDocumentsPanel.this.roots;
            }
            if (XmlDocumentUtil.isIncomplete((Object)element)) {
                EditVirtualDocumentsPanel.this.wasStopped.add(element);
                if (XmlDocumentUtil.isRecursive((Object)element)) {
                    EditVirtualDocumentsPanel.this.wasRecursive.add(element);
                }
                EditVirtualDocumentsPanel.buildNextLevelFromSchema((XmlElement)element);
                if (EditVirtualDocumentsPanel.this.viewer.getChecked(element)) {
                    EditVirtualDocumentsPanel.setExcluded(element, false);
                }
            }
            return ((XmlDocumentEntity)element).eContents().toArray();
        }

        public Object getParent(Object element) {
            if (element == EditVirtualDocumentsPanel.this.roots) {
                return null;
            }
            if (element instanceof XmlFragment) {
                return EditVirtualDocumentsPanel.this.roots;
            }
            return ((XmlDocumentEntity)element).eContainer();
        }
    }

    static class VDocLabelProvider
    extends ModelExplorerLabelProvider
    implements DisposeListener {
        Map classToLabelProvider = new HashMap();
        private HashMap decoratedImageRegistry = new HashMap();
        private List temporaryImages = new ArrayList();
        private List newDecoratedImages = new ArrayList();

        VDocLabelProvider() {
        }

        private String getDatatypeText(XSDComponent xsdc) {
            if (xsdc == null) {
                return "";
            }
            Class<?> xclass = xsdc.getClass();
            IItemLabelProvider provider = (IItemLabelProvider)this.classToLabelProvider.get(xclass);
            if (provider == null) {
                AdapterFactory adapterFactory = ModelerCore.getMetamodelRegistry().getAdapterFactory();
                provider = (IItemLabelProvider)adapterFactory.adapt((Notifier)xsdc, IItemLabelProvider.class);
                this.classToLabelProvider.put(xclass, provider);
            }
            return provider.getText((Object)xsdc);
        }

        public String getText(Object element) {
            if (element instanceof XmlDocumentNode) {
                XmlDocumentNode xdn = (XmlDocumentNode)element;
                String rv = this.getDatatypeText(xdn.getXsdComponent());
                if (rv == null || rv.length() == 0) {
                    return super.getText(element);
                }
                return rv;
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            Image originalImage = super.getImage(element);
            boolean recursive = XmlDocumentUtil.isRecursive((Object)element);
            boolean incomplete = XmlDocumentUtil.hasComplexType((Object)element) && XmlDocumentUtil.isIncomplete((Object)element);
            int cardinality = XmlDocumentUtil.getCardinality((Object)element);
            ImageKey imageKey = new ImageKey(originalImage, recursive, incomplete, cardinality);
            return this.getDecoratedImage(imageKey);
        }

        private Image getDecoratedImage(ImageKey key) {
            Image decoratedImage = (Image)this.decoratedImageRegistry.get(key);
            if (decoratedImage == null) {
                Image cardinalityImage;
                Image originalImage;
                decoratedImage = originalImage = key.getImage();
                if (key.isRecursive()) {
                    decoratedImage = this.decorateWithTopLeftImage(decoratedImage, ModelerXmlUiPlugin.getDefault().getImage("icons/full/ovr16/recursive.gif"));
                }
                if (key.isIncomplete()) {
                    if (decoratedImage != originalImage) {
                        this.temporaryImages.add(decoratedImage);
                    }
                    decoratedImage = this.decorateWithTopRightImage(decoratedImage, ModelerXmlUiPlugin.getDefault().getImage("icons/full/ovr16/incomplete.gif"));
                }
                if ((cardinalityImage = this.getCardinalityImage(key.getCardinality())) != null) {
                    if (decoratedImage != originalImage) {
                        this.temporaryImages.add(decoratedImage);
                    }
                    decoratedImage = this.decorateWithBottomLeftImage(decoratedImage, cardinalityImage);
                }
                this.disposeTemporaryImages();
                if (decoratedImage != originalImage) {
                    this.newDecoratedImages.add(decoratedImage);
                }
                this.decoratedImageRegistry.put(key, decoratedImage);
            }
            return decoratedImage;
        }

        private Image getCardinalityImage(int cardinality) {
            Image cardinalityImage = null;
            switch (cardinality) {
                case 1: {
                    cardinalityImage = ModelerXmlUiPlugin.getDefault().getImage("icons/full/ovr16/XSDOccurrenceN.gif");
                    break;
                }
                case 2: {
                    cardinalityImage = ModelerXmlUiPlugin.getDefault().getImage("icons/full/ovr16/XSDOccurrenceNToM.gif");
                    break;
                }
                case 3: {
                    cardinalityImage = ModelerXmlUiPlugin.getDefault().getImage("icons/full/ovr16/XSDOccurrenceNToUnbounded.gif");
                    break;
                }
                case 7: {
                    cardinalityImage = ModelerXmlUiPlugin.getDefault().getImage("icons/full/ovr16/XSDOccurrenceZero.gif");
                    break;
                }
                case 9: {
                    cardinalityImage = ModelerXmlUiPlugin.getDefault().getImage("icons/full/ovr16/XSDOccurrenceZeroToOne.gif");
                    break;
                }
                case 8: {
                    cardinalityImage = ModelerXmlUiPlugin.getDefault().getImage("icons/full/ovr16/XSDOccurrenceZeroToN.gif");
                    break;
                }
                case 10: {
                    cardinalityImage = ModelerXmlUiPlugin.getDefault().getImage("icons/full/ovr16/XSDOccurrenceZeroToUnbounded.gif");
                    break;
                }
                case 4: {
                    cardinalityImage = ModelerXmlUiPlugin.getDefault().getImage("icons/full/ovr16/XSDOccurrenceOne.gif");
                    break;
                }
                case 5: {
                    cardinalityImage = ModelerXmlUiPlugin.getDefault().getImage("icons/full/ovr16/XSDOccurrenceOneToN.gif");
                    break;
                }
                case 6: {
                    cardinalityImage = ModelerXmlUiPlugin.getDefault().getImage("icons/full/ovr16/XSDOccurrenceOneToUnbounded.gif");
                }
            }
            return cardinalityImage;
        }

        private Image decorateWithTopLeftImage(Image originalImage, Image overlayImage) {
            OverlayImageIcon overlayIcon = new OverlayImageIcon(originalImage, overlayImage, 0);
            return overlayIcon.getImage();
        }

        private Image decorateWithTopRightImage(Image originalImage, Image overlayImage) {
            OverlayImageIcon overlayIcon = new OverlayImageIcon(originalImage, overlayImage, 1);
            return overlayIcon.getImage();
        }

        private Image decorateWithBottomLeftImage(Image originalImage, Image overlayImage) {
            OverlayImageIcon overlayIcon = new OverlayImageIcon(originalImage, overlayImage, 2);
            return overlayIcon.getImage();
        }

        private void disposeTemporaryImages() {
            while (this.temporaryImages.size() > 0) {
                Image tempImage = (Image)this.temporaryImages.remove(this.temporaryImages.size() - 1);
                tempImage.dispose();
            }
        }

        private void disposeNewDecoratedImages() {
            while (this.newDecoratedImages.size() > 0) {
                Image tempImage = (Image)this.newDecoratedImages.remove(this.newDecoratedImages.size() - 1);
                tempImage.dispose();
            }
        }

        public void widgetDisposed(DisposeEvent e) {
            this.disposeNewDecoratedImages();
        }
    }

    class VDocSelectionListener
    implements ISelectionChangedListener {
        private TreeItem lastColored;

        VDocSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object nodeData;
            if (this.lastColored != null && !this.lastColored.isDisposed()) {
                this.lastColored.setBackground(null);
            }
            if (XmlDocumentUtil.isRecursive((Object)(nodeData = SelectionUtilities.getSelectedObject((ISelection)event.getSelection())))) {
                XSDTypeDefinition sType = XmlDocumentUtil.findXSDType((Object)nodeData);
                TreeItem parent = EditVirtualDocumentsPanel.this.viewer.getTree().getSelection()[0].getParentItem();
                while (parent != null) {
                    XmlElement parentElement;
                    XSDTypeDefinition pType;
                    Object parentData = parent.getData();
                    if (parentData instanceof XmlElement && (pType = XmlDocumentUtil.findXSDType((Object)(parentElement = (XmlElement)parentData))).equals(sType)) {
                        this.lastColored = parent;
                        parent.setBackground(DiagramUiConstants.Colors.VIRTUAL_GROUP_BKGRND);
                        break;
                    }
                    parent = parent.getParentItem();
                }
            }
        }
    }

    class VDocTreeViewerController
    extends DefaultTreeViewerController {
        VDocTreeViewerController() {
        }

        public void checkedStateToggled(TreeItem item) {
            boolean shouldExclude = !item.getChecked();
            Object nodeData = item.getData();
            EditVirtualDocumentsPanel.setExcluded(nodeData, shouldExclude);
            if (shouldExclude) {
                this.excludeNodeAndChildren((ITreeContentProvider)EditVirtualDocumentsPanel.this.content, nodeData);
            } else {
                this.checkRequiredAncestors(nodeData);
                this.checkDefaultChildren(nodeData);
            }
        }

        public boolean isItemCheckable(TreeItem item) {
            Object d = item.getData();
            return this.isUserCheckable(d);
        }

        public void update(TreeItem item, boolean selected) {
            Object d = item.getData();
            if (!this.isUserCheckable(d) && item.getChecked()) {
                this.checkRequiredAncestors(d);
                EditVirtualDocumentsPanel.this.viewer.setChecked(d, true);
                EditVirtualDocumentsPanel.setExcluded(d, false);
            } else if (EditVirtualDocumentsPanel.this.viewer.getChecked(d)) {
                this.checkRequiredAncestors(d);
                this.checkRequiredChildren(d);
            }
        }

        public void itemDoubleClicked(DoubleClickEvent event) {
            this.treeExpanded(SelectionUtilities.getSelectedObject((ISelection)event.getSelection()));
        }

        public void itemExpanded(TreeExpansionEvent event) {
            ++EditVirtualDocumentsPanel.this.stopExpansion;
            this.treeExpanded(event.getElement());
        }

        private void treeExpanded(final Object nodeData) {
            if (EditVirtualDocumentsPanel.this.viewer.getChecked(nodeData)) {
                this.checkRequiredChildren(nodeData);
            }
            if (EditVirtualDocumentsPanel.this.wasStopped.contains(nodeData)) {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ((VDocTreeViewerController)VDocTreeViewerController.this).EditVirtualDocumentsPanel.this.viewer.refresh(nodeData);
                    }
                });
            }
        }

        private boolean isUserCheckable(Object d) {
            return !(d instanceof XmlRoot) && (d instanceof XmlElement || d instanceof XmlFragment || d instanceof XmlContainerNode || d instanceof XmlAttribute);
        }

        private void excludeNodeAndChildren(ITreeContentProvider tcp, Object nodeData) {
            Object[] kids = !XmlDocumentUtil.isIncomplete((Object)nodeData) && tcp.hasChildren(nodeData) ? tcp.getChildren(nodeData) : EMPTY_OBJECT_ARRAY;
            int i = 0;
            while (i < kids.length) {
                Object kid = kids[i];
                if (EditVirtualDocumentsPanel.this.viewer.getChecked(kid)) {
                    this.excludeNodeAndChildren(tcp, kid);
                }
                ++i;
            }
            EditVirtualDocumentsPanel.setExcluded(nodeData, true);
            EditVirtualDocumentsPanel.this.viewer.setChecked(nodeData, false);
        }

        public void checkRequiredChildren(Object nodeData) {
            Object[] kids = !XmlDocumentUtil.isIncomplete((Object)nodeData) && EditVirtualDocumentsPanel.this.content.hasChildren(nodeData) ? EditVirtualDocumentsPanel.this.content.getChildren(nodeData) : EMPTY_OBJECT_ARRAY;
            int i = 0;
            while (i < kids.length) {
                Object kid = kids[i];
                if (!this.isUserCheckable(kid)) {
                    EditVirtualDocumentsPanel.this.viewer.setChecked(kid, true);
                    EditVirtualDocumentsPanel.setExcluded(kid, false);
                }
                ++i;
            }
        }

        private void checkDefaultChildren(Object nodeData) {
            Object[] kids = !XmlDocumentUtil.isIncomplete((Object)nodeData) && EditVirtualDocumentsPanel.this.content.hasChildren(nodeData) ? EditVirtualDocumentsPanel.this.content.getChildren(nodeData) : EMPTY_OBJECT_ARRAY;
            int i = 0;
            while (i < kids.length) {
                Object kid = kids[i];
                if (kid instanceof XmlAttribute || kid instanceof XmlElement && !XmlDocumentUtil.hasComplexType((Object)kid)) {
                    EditVirtualDocumentsPanel.this.viewer.setChecked(kid, true);
                    EditVirtualDocumentsPanel.setExcluded(kid, false);
                }
                ++i;
            }
        }

        private void checkRequiredAncestors(Object nodeData) {
            Object parent = EditVirtualDocumentsPanel.this.content.getParent(nodeData);
            while (parent != null && !EditVirtualDocumentsPanel.this.viewer.getChecked(parent)) {
                EditVirtualDocumentsPanel.this.viewer.setChecked(parent, true);
                EditVirtualDocumentsPanel.setExcluded(parent, false);
                this.checkRequiredChildren(parent);
                parent = EditVirtualDocumentsPanel.this.content.getParent(parent);
            }
        }
    }
}

