/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.parametized.server;

import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.ide.eclipse.as.core.server.IServerModeDetails;
import org.jboss.ide.eclipse.as.core.server.internal.LocalServerModeDetails;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossDefaultLaunchArguments;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossExtendedProperties;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.ide.eclipse.as.rse.core.RSEServerModeDetails;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ServerProfileModel;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.jboss.tools.as.test.core.internal.utils.ServerParameterUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

@RunWith(value=Parameterized.class)
public class ServerDefaultLaunchArgsTest
extends TestCase {
    private String serverType;
    private IServer server;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return ServerParameterUtils.asCollection(ServerParameterUtils.getJBossServerTypeParameters());
    }

    public ServerDefaultLaunchArgsTest(String serverType) {
        this.serverType = serverType;
    }

    @Before
    public void setUp() {
        this.server = ServerCreationTestUtils.createMockServerWithRuntime(this.serverType, String.valueOf(((Object)((Object)this)).getClass().getName()) + this.serverType);
    }

    @After
    public void tearDown() throws Exception {
        ServerCreationTestUtils.deleteAllServersAndRuntimes();
    }

    @Test
    public void testServerDefaults() {
        ServerDefaultLaunchArgsTest.forceStart("org.jboss.ide.eclipse.as.rse.core");
        IServerModeDetails ret = (IServerModeDetails)Platform.getAdapterManager().getAdapter((Object)this.server, IServerModeDetails.class);
        ServerDefaultLaunchArgsTest.assertNotNull((Object)ret);
        ServerDefaultLaunchArgsTest.assertTrue((boolean)(ret instanceof LocalServerModeDetails));
        JBossExtendedProperties props1 = (JBossExtendedProperties)Platform.getAdapterManager().getAdapter((Object)this.server, JBossExtendedProperties.class);
        boolean as7Style = props1.getFileStructure() == 2;
        JBossDefaultLaunchArguments localArgs = (JBossDefaultLaunchArguments)props1.getDefaultLaunchArguments();
        localArgs.getStartDefaultProgramArgs();
        String vmArgs = localArgs.getStartDefaultVMArgs();
        if (as7Style) {
            ServerDefaultLaunchArgsTest.assertTrue((boolean)vmArgs.contains("mockedServers/" + this.serverType + "/standalone/configuration/logging.properties"));
        } else {
            boolean matches1a = vmArgs.matches(".*-Djava.endorsed.dirs=.*metadata/.plugins/org.jboss.tools.as.test.core/mockedServers/.*/lib/endorsed.*");
            ServerDefaultLaunchArgsTest.assertTrue((boolean)matches1a);
        }
        IServerWorkingCopy wc = this.server.createWorkingCopy();
        ServerProfileModel.setProfile((IServerWorkingCopy)wc, (String)"rse");
        wc.setAttribute("org.jboss.ide.eclipse.as.rse.core.RSEServerBaseDir", "standNOTalone");
        wc.setAttribute("org.jboss.ide.eclipse.as.rse.core.RSEServerHomeDir", "/home/otherUser/jboss");
        ServerExtendedProperties cfr_ignored_0 = (ServerExtendedProperties)Platform.getAdapterManager().getAdapter((Object)this.server, ServerExtendedProperties.class);
        String configVal = as7Style ? "standNOTalone.xml" : "myDefConfig";
        wc.setAttribute("org.jboss.ide.eclipse.as.rse.core.RSEServerConfig", configVal);
        try {
            this.server = wc.save(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ce) {
            ServerDefaultLaunchArgsTest.fail((String)ce.getMessage());
        }
        ret = (IServerModeDetails)Platform.getAdapterManager().getAdapter((Object)this.server, IServerModeDetails.class);
        ServerDefaultLaunchArgsTest.assertNotNull((Object)ret);
        ServerDefaultLaunchArgsTest.assertTrue((boolean)(ret instanceof RSEServerModeDetails));
        JBossExtendedProperties props2a = (JBossExtendedProperties)Platform.getAdapterManager().getAdapter((Object)this.server, JBossExtendedProperties.class);
        JBossDefaultLaunchArguments rseArgs = (JBossDefaultLaunchArguments)props2a.getDefaultLaunchArguments();
        rseArgs.getStartDefaultProgramArgs();
        vmArgs = rseArgs.getStartDefaultVMArgs();
        if (as7Style) {
            ServerDefaultLaunchArgsTest.assertTrue((boolean)vmArgs.contains("/home/otherUser/jboss/standNOTalone/configuration/logging.properties"));
            ServerDefaultLaunchArgsTest.assertTrue((boolean)vmArgs.contains("-Djboss.home.dir=/home/otherUser/jboss"));
        } else {
            ServerDefaultLaunchArgsTest.assertTrue((boolean)vmArgs.matches(".*-Djava.endorsed.dirs=/home/otherUser/jboss/lib/endorsed.*"));
        }
    }

    private static boolean forceStart(String bundleId) {
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle != null && bundle.getState() != 32) {
            try {
                bundle.start();
            }
            catch (BundleException bundleException) {}
        }
        return bundle.getState() == 32;
    }
}

