/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.commons.ui;

import java.util.Collection;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.fusesource.ide.commons.Activator;
import org.fusesource.ide.commons.util.Objects;

public class Menus {
    public static MenuItem getMenuItemByText(Menu menu, String label) {
        MenuItem[] items;
        MenuItem[] menuItemArray = items = menu.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            if (Objects.equal(label, item.getText())) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    public static void disposeItems(Menu menu) {
        MenuItem[] items;
        MenuItem[] menuItemArray = items = menu.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            Menu childMenu = item.getMenu();
            if (childMenu != null && !childMenu.isDisposed()) {
                Menus.disposeItems(childMenu);
                childMenu.dispose();
            }
            if (!item.isDisposed()) {
                item.dispose();
            }
            ++n2;
        }
    }

    public static void addAction(IContributionManager manager, Object actionOrContributionItem) {
        if (actionOrContributionItem instanceof IAction) {
            IAction action = (IAction)actionOrContributionItem;
            String id = Menus.getActionId(action);
            if (id == null || manager.find(id) != null) {
                return;
            }
            manager.add(action);
        } else if (actionOrContributionItem instanceof IContributionItem) {
            IContributionItem contributionItem = (IContributionItem)actionOrContributionItem;
            String id = Menus.getContributionItemId(contributionItem);
            if (id == null || manager.find(id) != null) {
                return;
            }
            manager.add(contributionItem);
        }
    }

    public static void addAction(IContributionManager manager, Collection<?> collection) {
        for (Object action : collection) {
            Menus.addAction(manager, action);
        }
    }

    public static void addAction(IToolBarManager manager, Collection<?> collection) {
        for (Object action : collection) {
            Menus.addAction((IContributionManager)manager, action);
        }
    }

    public static void removeAction(IContributionManager manager, Collection<?> collection) {
        for (Object action : collection) {
            Menus.removeAction(manager, action);
        }
    }

    public static void removeAction(IMenuManager manager, Collection<?> collection) {
        for (Object action : collection) {
            Menus.removeAction((IContributionManager)manager, action);
        }
    }

    public static void removeAction(IToolBarManager manager, Collection<?> collection) {
        for (Object action : collection) {
            Menus.removeAction((IContributionManager)manager, action);
        }
    }

    public static void removeAction(IContributionManager manager, Object actionOrContributionItem) {
        if (actionOrContributionItem instanceof IContributionItem) {
            IContributionItem item = (IContributionItem)actionOrContributionItem;
            manager.remove(item);
            String id = Menus.getContributionItemId(item);
            if (id != null) {
                manager.remove(id);
            }
        } else if (actionOrContributionItem instanceof IAction) {
            IAction action = (IAction)actionOrContributionItem;
            String id = Menus.getActionId(action);
            if (id != null) {
                manager.remove(id);
            } else {
                Activator.getLogger().debug("==== CANNOT remove action - no ID: " + action);
            }
        } else {
            Activator.getLogger().debug("==== CANNOT remove object - no ID: " + actionOrContributionItem);
        }
    }

    protected static String getActionId(IAction action) {
        String id = action.getId();
        if (id == null) {
            Activator.getLogger().debug("Warning no ID for action: " + action);
        }
        return id;
    }

    protected static String getContributionItemId(IContributionItem item) {
        String id = item.getId();
        if (id == null) {
            Activator.getLogger().debug("Warning no ID for contribution item: " + item);
        }
        return id;
    }
}

