/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.commons.camel.tools;

import de.pdark.decentxml.Attribute;
import de.pdark.decentxml.Comment;
import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.Namespace;
import de.pdark.decentxml.Node;
import de.pdark.decentxml.NodeFilter;
import de.pdark.decentxml.NodeWithChildren;
import de.pdark.decentxml.Parent;
import de.pdark.decentxml.Text;
import de.pdark.decentxml.Token;
import de.pdark.decentxml.XMLWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.camel.blueprint.CamelEndpointFactoryBean;
import org.fusesource.ide.commons.Activator;
import org.fusesource.ide.commons.camel.tools.SchemaFinder;
import org.fusesource.ide.commons.camel.tools.Strings;
import org.fusesource.ide.commons.camel.tools.XsdDetails;
import org.fusesource.ide.commons.util.IOUtils;
import org.xml.sax.SAXException;

public class CamelNamespaces {
    public static final String springNS = "http://camel.apache.org/schema/spring";
    public static final String blueprintNS = "http://camel.apache.org/schema/blueprint";
    public static final String[] camelNamespaces = new String[]{"http://camel.apache.org/schema/spring", "http://camel.apache.org/schema/blueprint"};
    public static final Namespace springNamespace = new Namespace("", "http://www.springframework.org/schema/beans");
    public static final Namespace droolsNamespace = new Namespace("drools", "http://drools.org/schema/drools-spring");
    public static final Namespace amqNamespace = new Namespace("", "http://activemq.apache.org/schema/core");
    private static Schema _schema;
    private static Set<String> elementsWithDescription;

    public static Set<String> elementsWithDescription() {
        if (elementsWithDescription == null) {
            String file = "camelDescriptionElements.txt";
            String text = "";
            URL url = CamelNamespaces.findResource(file, null);
            if (url != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    IOUtils.copy(url.openStream(), baos);
                    text = new String(baos.toByteArray(), "UTF-8");
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            } else {
                Activator.getLogger().warning("Could not find file " + file + " on the class path");
            }
            text = String.valueOf(text) + " camelContext";
            String[] arr = text.split(" ");
            elementsWithDescription = new HashSet<String>(Arrays.asList(arr));
        }
        return elementsWithDescription;
    }

    public static List<Node> nodesByNamespace(Document doc, String namespaceUri, final String localName) {
        NodeFilter<Node> filter = new NodeFilter<Node>(){

            public boolean matches(Node n) {
                if (n instanceof Element) {
                    Namespace ns = ((Element)n).getNamespace();
                    if (!((Element)n).getName().equals(localName)) {
                        return false;
                    }
                    CamelNamespaces.getNamespaceURI(n);
                    return ns != null;
                }
                return false;
            }
        };
        return CamelNamespaces.findNodes((NodeWithChildren)doc, filter);
    }

    public static List<Node> findNodes(NodeWithChildren node, NodeFilter<Node> filter) {
        List answer = node.getNodes(filter);
        List children = node.getNodes();
        for (Node child : children) {
            if (!(child instanceof Element)) continue;
            List<Node> childMatched = CamelNamespaces.findNodes((NodeWithChildren)((Element)child), filter);
            answer.addAll(childMatched);
        }
        return answer;
    }

    public static String nodeWithNamespacesToText(Node parseNode, Element namespacesNode) throws IOException {
        Node copy = parseNode.copy();
        if (copy instanceof Element && parseNode instanceof Element) {
            CamelNamespaces.moveCommentsIntoDescriptionElements((Element)copy, (Element)parseNode);
            CamelNamespaces.addParentNamespaces((Element)copy, namespacesNode.getParent());
        }
        return CamelNamespaces.xmlToText(copy);
    }

    public static void moveCommentsIntoDescriptionElements(Element e, Element root) {
        int idx = 0;
        List nodes = e.getNodes();
        Node[] nodeArray = nodes.toArray(new Node[nodes.size()]);
        int n = nodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            if (node instanceof Comment) {
                Comment c = (Comment)node;
                Token token = c.getToken();
                if (token != null) {
                    String text = token.getText().trim().replace("<!--", "").replace("-->", "").trim();
                    Element descr = CamelNamespaces.findOrCreateDescriptionOnNextElement(e, idx, (Parent)root);
                    if (descr == null) {
                        Activator.getLogger().warning("No description node found");
                        e.removeNode((Node)c);
                        Parent grandParent = root.getParent();
                        if (grandParent != null) {
                            grandParent.addNode(grandParent.nodeIndexOf((Node)root), (Node)c);
                        } else {
                            Activator.getLogger().warning("Cannot save the comment '" + text + "' as there's no parent in the DOM");
                        }
                    } else {
                        if (descr.getNodes().size() > 0) {
                            text = "\n" + text;
                        }
                        descr.addNode((Node)new Text(text));
                    }
                }
            } else if (node instanceof Element) {
                CamelNamespaces.moveCommentsIntoDescriptionElements((Element)node, root);
            }
            ++idx;
            ++n2;
        }
    }

    protected static Element findOrCreateDescriptionOnNextElement(Element element, int commentIndex, Parent root) {
        List nodes = element.getNodes();
        Node[] array = nodes.toArray(new Node[nodes.size()]);
        int i = commentIndex + 1;
        while (i < array.length) {
            if (array[i] instanceof Element && CamelNamespaces.elementsWithDescription().contains(element.getName())) {
                return CamelNamespaces.findOrCreateDescrptionElement((Element)array[i], root);
            }
            ++i;
        }
        return CamelNamespaces.findOrCreateDescrptionElement(element, root);
    }

    protected static Element findOrCreateDescrptionElement(Element element, Parent root) {
        for (Node node : element.getNodes()) {
            if (!(node instanceof Element) || !"description".equals(((Element)node).getName())) continue;
            return (Element)node;
        }
        Element parent = element.getParentElement();
        if (element == root || parent == null || parent == root) {
            return null;
        }
        if (elementsWithDescription.contains(element.getName())) {
            String ebn = element.getBeginName();
            int idx = ebn.indexOf(":");
            String name = idx > 0 ? String.valueOf(ebn.substring(0, idx + 1)) + "description" : "description";
            Element description = new Element(name, element.getNamespace());
            element.addNode(0, (Node)description);
            return description;
        }
        return CamelNamespaces.findOrCreateDescrptionElement(parent, root);
    }

    public static String xmlToText(Node node) throws IOException {
        StringWriter buffer = new StringWriter();
        XMLWriter writer = new XMLWriter((Writer)buffer);
        node.toXML(writer);
        writer.close();
        return buffer.toString();
    }

    public static String getNamespaceURI(Node node) {
        Namespace ns;
        if (node instanceof Element && (ns = ((Element)node).getNamespace()) != null) {
            String uri = ns.getURI();
            if (uri == null || uri.length() == 0) {
                String uriAttr;
                String string = uriAttr = ns.getPrefix().equals("") ? ((Element)node).getAttributeValue("xmlns") : null;
                if (uriAttr != null) {
                    return uriAttr;
                }
                return CamelNamespaces.getNamespaceURI((Node)((Element)node).getParent());
            }
            return uri;
        }
        return null;
    }

    public static void addParentNamespaces(Element element, Parent parent) {
        if (parent instanceof Element) {
            for (Attribute attr : ((Element)parent).getAttributes()) {
                String name = attr.getName();
                if (!name.startsWith("xmlns") || element.getAttribute(name) != null) continue;
                element.setAttribute(name, attr.getValue());
            }
            CamelNamespaces.addParentNamespaces(element, ((Element)parent).getParent());
        }
        if (parent == null && !Strings.isEmpty(element.getAttribute("xmlns").getValue()) && element.getBeginName().indexOf(":") != -1) {
            element.setAttribute("xmlns:" + element.getBeginName().substring(0, element.getBeginName().indexOf(":")), element.getAttribute("xmlns").getValue());
        }
    }

    public static Document getOwnerDocument(Node node) {
        if (node instanceof Element) {
            return ((Element)node).getDocument();
        }
        if (node instanceof Document) {
            return (Document)node;
        }
        return null;
    }

    public static void replaceChild(Parent parent, Node newChild, Node oldNode) {
        int idx = parent.nodeIndexOf(oldNode);
        if (idx < 0) {
            parent.addNode(newChild);
        } else {
            parent.removeNode(idx);
            parent.addNode(idx, newChild);
        }
    }

    public static URL findResource(String name, Iterable<ClassLoader> classLoaders) {
        if (classLoaders == null) {
            classLoaders = Arrays.asList(Thread.currentThread().getContextClassLoader(), CamelNamespaces.class.getClassLoader());
        }
        for (ClassLoader cl : classLoaders) {
            URL resource = CamelNamespaces.tryLoadClass(cl, name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    private static URL tryLoadClass(ClassLoader classLoader, String name) {
        try {
            return classLoader.getResource(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void loadSchemasWith(final SchemaFinder finder) throws IOException, SAXException {
        CamelNamespaces.loadSchemas(new SchemaFinder(){

            @Override
            public URL findSchema(XsdDetails xsd) {
                return finder.findSchema(xsd);
            }
        });
    }

    private static void loadSchemas(SchemaFinder loader) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        XsdDetails[] xsds = new XsdDetails[]{new XsdDetails("camel-spring.xsd", "http://camel.apache.org/schema/spring/camel-spring.xsd", org.apache.camel.spring.CamelEndpointFactoryBean.class), new XsdDetails("camel-blueprint.xsd", "http://camel.apache.org/schema/blueprint/camel-blueprint.xsd", CamelEndpointFactoryBean.class)};
        ArrayList<StreamSource> sources = new ArrayList<StreamSource>(xsds.length);
        XsdDetails[] xsdDetailsArray = xsds;
        int n = xsds.length;
        int n2 = 0;
        while (n2 < n) {
            XsdDetails xsdd = xsdDetailsArray[n2];
            URL url = loader.findSchema(xsdd);
            if (url != null) {
                sources.add(new StreamSource(url.openStream(), xsdd.getUri()));
            } else {
                System.out.println("Warning could not find local resource " + xsdd.getPath() + " on classpath");
                sources.add(new StreamSource(xsdd.getUri()));
            }
            ++n2;
        }
        _schema = factory.newSchema(sources.toArray(new Source[sources.size()]));
    }

    public static Schema camelSchemas() throws IOException, SAXException {
        if (_schema == null) {
            CamelNamespaces.loadSchemas(new SchemaFinder(){

                @Override
                public URL findSchema(XsdDetails details) {
                    return details.getClassLoader().getResource(details.getPath());
                }
            });
        }
        return _schema;
    }
}

