/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.relational.impl.custom;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.jdbc.metadata.JdbcTable;
import org.teiid.designer.jdbc.relational.impl.Context;
import org.teiid.designer.jdbc.relational.impl.RelationalModelProcessorImpl;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.RelationalFactory;
import org.teiid.designer.metamodels.relational.util.RelationalTypeMapping;

public class SqlServerModelProcessor
extends RelationalModelProcessorImpl {
    private static final String TEXT_TYPE_NAME = "TEXT";
    private static final String IMAGE_TYPE_NAME = "IMAGE";
    private static final String IDENTITY_STR = "identity";

    public SqlServerModelProcessor() {
    }

    public SqlServerModelProcessor(RelationalFactory factory) {
        super(factory);
    }

    public SqlServerModelProcessor(RelationalFactory factory, RelationalTypeMapping mapping) {
        super(factory, mapping);
    }

    @Override
    protected void updateModelAnnotation(ModelAnnotation modelAnnotation) {
        super.updateModelAnnotation(modelAnnotation);
        modelAnnotation.setMaxSetSize(16000);
    }

    @Override
    protected boolean checkExportedForeignKeysIfNoImportedForeignKeysFound() {
        return false;
    }

    @Override
    protected EObject findType(int jdbcType, String typeName, int length, int precision, int scale, List problems) {
        EObject result = null;
        String trimmedTypeName = typeName.trim();
        if (trimmedTypeName.toUpperCase().startsWith(TEXT_TYPE_NAME)) {
            result = this.findBuiltinType("clob", problems);
        } else if (trimmedTypeName.toUpperCase().startsWith(IMAGE_TYPE_NAME)) {
            result = this.findBuiltinType("blob", problems);
        } else if (trimmedTypeName.endsWith(IDENTITY_STR)) {
            int identIndex = trimmedTypeName.indexOf(IDENTITY_STR);
            String realType = trimmedTypeName.substring(0, identIndex).trim();
            result = this.findBuiltinType(realType, problems);
        }
        if (result != null) {
            return result;
        }
        return super.findType(jdbcType, typeName, length, precision, scale, problems);
    }

    @Override
    protected void setColumnInfo(Column column, JdbcTable tableNode, Context context, List problems, String name, int type, String typeName, int columnSize, int numDecDigits, int numPrecRadix, int nullable, String defaultValue, int charOctetLen) {
        super.setColumnInfo(column, tableNode, context, problems, name, type, typeName, columnSize, numDecDigits, numPrecRadix, nullable, defaultValue, charOctetLen);
        String trimmedTypeName = typeName.trim();
        if (trimmedTypeName.endsWith(IDENTITY_STR)) {
            int identIndex = trimmedTypeName.indexOf(IDENTITY_STR);
            String realType = trimmedTypeName.substring(0, identIndex).trim();
            column.setAutoIncremented(true);
            column.setNativeType(realType);
        }
    }
}

