/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.relational.aspects.sql;

import java.util.Properties;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.metamodel.aspect.AbstractMetamodelAspect;
import org.teiid.designer.core.metamodel.aspect.MetamodelEntity;
import org.teiid.designer.core.metamodel.aspect.sql.SqlModelSourceAspect;
import org.teiid.designer.jdbc.JdbcImportOptions;
import org.teiid.designer.jdbc.JdbcImportSettings;
import org.teiid.designer.jdbc.JdbcSource;
import org.teiid.designer.jdbc.JdbcSourceProperty;

public class JdbcSourceAspect
extends AbstractMetamodelAspect
implements SqlModelSourceAspect {
    public static final String ASPECT_ID = "sqlAspect";

    protected JdbcSourceAspect(MetamodelEntity entity) {
        super.setMetamodelEntity(entity);
        super.setID(ASPECT_ID);
    }

    public String getName(EObject eObject) {
        CoreArgCheck.isInstanceOf(JdbcSource.class, (Object)eObject);
        JdbcSource entity = (JdbcSource)eObject;
        return entity.getName();
    }

    public String getNameInSource(EObject eObject) {
        CoreArgCheck.isInstanceOf(JdbcSource.class, (Object)eObject);
        JdbcSource entity = (JdbcSource)eObject;
        return entity.getName();
    }

    public boolean isRecordType(char recordType) {
        return false;
    }

    public boolean isQueryable(EObject eObject) {
        return false;
    }

    public Properties getProperties(EObject eObject) {
        CoreArgCheck.isInstanceOf(JdbcSource.class, (Object)eObject);
        Properties props = new Properties();
        this.addJdbcSourceProperties((JdbcSource)eObject, props);
        TreeIterator iter = eObject.eAllContents();
        while (iter.hasNext()) {
            EObject eObj = (EObject)iter.next();
            if (eObj instanceof JdbcSourceProperty) {
                this.addJdbcSourcePropertyProperties((JdbcSourceProperty)eObj, props);
                continue;
            }
            if (eObj instanceof JdbcImportSettings) {
                this.addJdbcImportSettingProperties((JdbcImportSettings)eObj, props);
                continue;
            }
            if (!(eObj instanceof JdbcImportOptions)) continue;
            this.addJdbcImportOptionProperties((JdbcImportOptions)eObj, props);
        }
        return props;
    }

    private void addJdbcSourceProperties(JdbcSource source, Properties props) {
        String propNamePrefix = String.valueOf(JdbcSource.class.getName()) + ".";
        String propName = String.valueOf(propNamePrefix) + source.eClass().getEStructuralFeature(4).getName();
        if (source.getName() != null) {
            props.setProperty(propName, source.getName());
        }
        propName = String.valueOf(propNamePrefix) + source.eClass().getEStructuralFeature(6).getName();
        if (source.getDriverClass() != null) {
            props.setProperty(propName, source.getDriverClass());
        }
        propName = String.valueOf(propNamePrefix) + source.eClass().getEStructuralFeature(5).getName();
        if (source.getDriverName() != null) {
            props.setProperty(propName, source.getDriverName());
        }
        propName = String.valueOf(propNamePrefix) + source.eClass().getEStructuralFeature(7).getName();
        if (source.getUsername() != null) {
            props.setProperty(propName, source.getUsername());
        }
        propName = String.valueOf(propNamePrefix) + source.eClass().getEStructuralFeature(8).getName();
        if (source.getUrl() != null) {
            props.setProperty(propName, source.getUrl());
        }
    }

    private void addJdbcSourcePropertyProperties(JdbcSourceProperty sourcePropery, Properties props) {
        String propNamePrefix = String.valueOf(JdbcSourceProperty.class.getName()) + ".";
        String propName = String.valueOf(propNamePrefix) + sourcePropery.getName();
        if (sourcePropery.getValue() != null) {
            props.setProperty(propName, sourcePropery.getValue());
        }
    }

    private void addJdbcImportSettingProperties(JdbcImportSettings importSettings, Properties props) {
    }

    private void addJdbcImportOptionProperties(JdbcImportOptions importOptions, Properties props) {
        String propNamePrefix = String.valueOf(JdbcImportOptions.class.getName()) + ".";
        String propName = String.valueOf(propNamePrefix) + importOptions.getName();
        if (importOptions.getValue() != null) {
            props.setProperty(propName, importOptions.getValue());
        }
    }

    public void updateObject(EObject targetObject, EObject sourceObject) {
    }
}

