/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.relational;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.jdbc.JdbcException;
import org.teiid.designer.jdbc.JdbcImportSettings;
import org.teiid.designer.jdbc.JdbcManager;
import org.teiid.designer.jdbc.JdbcPlugin;
import org.teiid.designer.jdbc.JdbcSource;
import org.teiid.designer.jdbc.metadata.Includes;
import org.teiid.designer.jdbc.metadata.JdbcDatabase;
import org.teiid.designer.jdbc.metadata.JdbcNode;
import org.teiid.designer.jdbc.relational.ModelerJdbcRelationalConstants;
import org.teiid.designer.jdbc.relational.RelationalModelProcessor;
import org.teiid.designer.jdbc.relational.util.JdbcModelProcessorManager;
import org.teiid.designer.jdbc.relational.util.JdbcRelationalUtil;

public final class JdbcImporter
implements ModelerJdbcRelationalConstants {
    private ModelResource updatedModel;
    private JdbcSource src;
    private JdbcSource updateSrc;
    private JdbcDatabase db;
    private boolean isVdbSourceModel;
    private String vdbSourceModelName;
    private boolean reachedObjectsPage;
    private String schemaFilter;
    private String tableFilter;
    private String storedProcFilter;

    public JdbcDatabase getDatabase() {
        return this.db;
    }

    public JdbcSource getSource() {
        return this.src;
    }

    public ModelResource getUpdatedModel() {
        return this.updatedModel;
    }

    public void setDatabase(JdbcDatabase database) {
        this.db = database;
        this.setReachedObjectsPage(false);
    }

    public void setSource(JdbcSource source) {
        CoreArgCheck.isNotNull((Object)source);
        this.src = source;
    }

    public void setUpdatedModel(ModelResource model) throws ModelWorkspaceException {
        this.updatedModel = null;
        this.updateSrc = null;
        if (model != null) {
            for (Object obj : model.getAllRootEObjects()) {
                if (!(obj instanceof JdbcSource)) continue;
                this.updatedModel = model;
                try {
                    this.updateSrc = (JdbcSource)ModelerCore.getModelEditor().copy((EObject)((JdbcSource)obj));
                    this.setUpdatedModelSettings();
                    break;
                }
                catch (Exception err) {
                    throw new ModelWorkspaceException((Throwable)err);
                }
            }
        } else {
            try {
                this.setUpdatedModelSettings();
            }
            catch (Exception err) {
                throw new ModelWorkspaceException((Throwable)err);
            }
        }
    }

    public void setUpdatedModelSettings() throws JdbcException {
        if (this.db == null) {
            return;
        }
        JdbcImportSettings settings = null;
        if (this.updateSrc != null) {
            settings = this.updateSrc.getImportSettings();
        } else if (this.src != null) {
            settings = this.src.getImportSettings();
        }
        if (settings != null) {
            Iterator objIter = settings.getExcludedObjectPaths().iterator();
            while (objIter.hasNext()) {
                Path path = new Path((String)objIter.next());
                JdbcNode node = this.findNode((IPath)path, (JdbcNode)this.db);
                if (node == null) continue;
                node.setSelected(false);
            }
            Includes includes = this.db.getIncludes();
            EList types = settings.getIncludedTableTypes();
            includes.setIncludedTableTypes(types.toArray(new String[types.size()]));
            includes.setApproximateIndexes(settings.isIncludeApproximateIndexes());
            includes.setIncludeForeignKeys(settings.isIncludeForeignKeys());
            includes.setIncludeIndexes(settings.isIncludeIndexes());
            includes.setIncludeProcedures(settings.isIncludeProcedures());
            includes.setUniqueIndexesOnly(settings.isIncludeUniqueIndexes());
        }
    }

    public void connect(String password, IProgressMonitor monitor) throws CoreException, SQLException {
        this.disconnect();
        JdbcManager mgr = JdbcRelationalUtil.getJdbcManager();
        JdbcSource jdbcSrc = this.updateSrc != null ? this.updateSrc : this.src;
        Connection connection = mgr.createConnection(jdbcSrc, password, monitor);
        this.db = JdbcPlugin.getJdbcDatabase((JdbcSource)jdbcSrc, (Connection)connection);
    }

    public void connect(String password) throws CoreException, SQLException {
        this.connect(password, null);
    }

    public void disconnect() throws SQLException {
        Connection connection;
        if (this.db != null && (connection = this.db.getConnection()) != null) {
            connection.close();
        }
    }

    public JdbcNode findNode(IPath path, JdbcNode parent) throws JdbcException {
        String seg = path.segment(0);
        JdbcNode[] children = parent.getChildren();
        int ndx = children.length;
        while (--ndx >= 0) {
            JdbcNode child = children[ndx];
            if (!seg.equalsIgnoreCase(child.getName())) continue;
            if (path.segmentCount() > 1) {
                return this.findNode(path.removeFirstSegments(1), child);
            }
            return child;
        }
        return null;
    }

    public IStatus importModel() throws ModelWorkspaceException {
        return this.importModel(null);
    }

    public IStatus importModel(IProgressMonitor monitor) throws ModelWorkspaceException {
        RelationalModelProcessor processor = JdbcModelProcessorManager.createRelationalModelProcessor();
        IStatus status = processor.execute(this.updatedModel, this.db, this.updateSrc.getImportSettings(), monitor);
        return status;
    }

    public boolean isVdbSourceModel() {
        return this.isVdbSourceModel;
    }

    public void setIsVdbSourceModel(boolean isVdbSourceModel) {
        this.isVdbSourceModel = isVdbSourceModel;
    }

    public String getVdbSourceModelName() {
        return this.vdbSourceModelName;
    }

    public void setVdbSourceModelName(String name) {
        this.vdbSourceModelName = name;
    }

    public boolean isReachedObjectsPage() {
        return this.reachedObjectsPage;
    }

    public void setReachedObjectsPage(boolean reachedObjectsPage) {
        this.reachedObjectsPage = reachedObjectsPage;
    }

    public void setSchemaFilter(String schemaFilter) {
        this.schemaFilter = schemaFilter;
    }

    public void setTableFilter(String tableFilter) {
        this.tableFilter = tableFilter;
    }

    public void setStoredProcFilter(String storedProcFilter) {
        this.storedProcFilter = storedProcFilter;
    }

    public String getSchemaFilter() {
        return this.schemaFilter;
    }

    public String getTableFilter() {
        return this.tableFilter;
    }

    public String getStoredProcFilter() {
        return this.storedProcFilter;
    }
}

