/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.widget.accumulator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.UiPlugin;
import org.teiid.designer.ui.common.util.OrderableViewerSorter;
import org.teiid.designer.ui.common.widget.MessageLabel;
import org.teiid.designer.ui.common.widget.accumulator.IAccumulatedValuesChangeListener;
import org.teiid.designer.ui.common.widget.accumulator.IAccumulatorSource;

public class AccumulatorPanel
extends Composite
implements InternalUiConstants {
    public static final int DEFAULT_RESET_BUTTON_MARGIN_HEIGHT = 10;
    public static final int DEFAULT_LEFT_SIDE_WIDTH_HINT;
    public static final int DEFAULT_RIGHT_SIDE_WIDTH_HINT;
    public static final int DEFAULT_LEFT_AND_RIGHT_SIDE_HEIGHT_HINT;
    private IAccumulatorSource source;
    private ILabelProvider labelProvider = null;
    private Table rightTable;
    private TableViewer tableViewer;
    private Collection initialRightSideItems;
    private String leftSideLabelText = null;
    private String rightSideLabelText = null;
    private Button rightButton;
    private Button leftButton;
    private Button allRightButton;
    private Button allLeftButton;
    private Button upButton;
    private Button downButton;
    private Button resetButton;
    private Button sortButton;
    private int resetButtonMarginHeight;
    private int leftSideWidthHint;
    private int rightSideWidthHint;
    private int leftAndRightSideHeightHint;
    private boolean isSorting = false;
    private boolean ignoreLeftSideSelectionChanges = false;
    private boolean ignoreRightSideSelectionChanges = false;
    private List changeListeners;
    private MessageLabel messageLabel;

    static {
        DEFAULT_RIGHT_SIDE_WIDTH_HINT = DEFAULT_LEFT_SIDE_WIDTH_HINT = (int)((double)Display.getDefault().getBounds().width * 0.1);
        DEFAULT_LEFT_AND_RIGHT_SIDE_HEIGHT_HINT = (int)((double)Display.getDefault().getBounds().height * 0.1);
    }

    public AccumulatorPanel(Composite parent, IAccumulatorSource source, Collection initialRightSideItemsColl, ILabelProvider labelProvider, String leftSideLabelText, String rightSideLabelText, int resetButtonMarginHeight, int leftSideWidthHint, int rightSideWidthHint, int leftAndRightSideHeightHint) {
        super(parent, 0);
        this.source = source;
        this.labelProvider = labelProvider;
        this.initialRightSideItems = initialRightSideItemsColl;
        this.leftSideLabelText = leftSideLabelText;
        this.rightSideLabelText = rightSideLabelText;
        this.resetButtonMarginHeight = resetButtonMarginHeight < 0 ? 10 : resetButtonMarginHeight;
        this.leftSideWidthHint = leftSideWidthHint < 1 ? DEFAULT_LEFT_SIDE_WIDTH_HINT : leftSideWidthHint;
        this.rightSideWidthHint = rightSideWidthHint < 1 ? DEFAULT_RIGHT_SIDE_WIDTH_HINT : rightSideWidthHint;
        this.leftAndRightSideHeightHint = leftAndRightSideHeightHint < 1 ? DEFAULT_LEFT_AND_RIGHT_SIDE_HEIGHT_HINT : leftAndRightSideHeightHint;
        this.init();
    }

    public AccumulatorPanel(Composite parent, IAccumulatorSource source, Collection initialRightSideItemsColl, ILabelProvider labelProvider, String leftSideLabelText, String rightSideLabelText) {
        this(parent, source, initialRightSideItemsColl, labelProvider, leftSideLabelText, rightSideLabelText, -1, -1, -1, -1);
    }

    private void init() {
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 4;
        GridData gridData = new GridData(1808);
        this.setLayoutData(gridData);
        Label leftSideLabel = new Label((Composite)this, 0);
        if (this.leftSideLabelText == null) {
            this.leftSideLabelText = Util.getString("AccumulatorColumnLabel.available", new Object[0]);
        }
        leftSideLabel.setText(this.leftSideLabelText);
        GridData leftSideLabelGridData = new GridData();
        leftSideLabelGridData.horizontalSpan = 2;
        leftSideLabelGridData.horizontalAlignment = 4;
        leftSideLabelGridData.verticalAlignment = 4;
        leftSideLabel.setLayoutData((Object)leftSideLabelGridData);
        Label rightSideLabel = new Label((Composite)this, 0);
        if (this.rightSideLabelText == null) {
            this.rightSideLabelText = Util.getString("AccumulatorColumnLabel.selected", new Object[0]);
        }
        rightSideLabel.setText(this.rightSideLabelText);
        GridData rightSideLabelGridData = new GridData();
        rightSideLabelGridData.horizontalSpan = 2;
        rightSideLabelGridData.verticalAlignment = 4;
        rightSideLabelGridData.horizontalAlignment = 4;
        rightSideLabel.setLayoutData((Object)rightSideLabelGridData);
        Control leftSideControl = this.source.createControl(this);
        this.source.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent ev) {
                AccumulatorPanel.this.leftSideControlSelectionChanged();
            }

            public void widgetSelected(SelectionEvent ev) {
                AccumulatorPanel.this.leftSideControlSelectionChanged();
            }
        });
        GridData leftSideControlGridData = new GridData();
        leftSideControlGridData.widthHint = this.leftSideWidthHint;
        leftSideControlGridData.heightHint = this.leftAndRightSideHeightHint;
        leftSideControlGridData.verticalAlignment = 4;
        leftSideControlGridData.horizontalAlignment = 4;
        leftSideControlGridData.grabExcessHorizontalSpace = true;
        leftSideControlGridData.grabExcessVerticalSpace = true;
        leftSideControl.setLayoutData((Object)leftSideControlGridData);
        Composite controlButtons = new Composite((Composite)this, 0);
        GridData controlButtonsGridData = new GridData();
        controlButtonsGridData.verticalAlignment = 4;
        controlButtonsGridData.horizontalAlignment = 4;
        controlButtons.setLayoutData((Object)controlButtonsGridData);
        GridLayout controlButtonsGridLayout = new GridLayout();
        controlButtonsGridLayout.verticalSpacing = 2;
        controlButtons.setLayout((Layout)controlButtonsGridLayout);
        this.rightButton = new Button(controlButtons, 8);
        this.rightButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                AccumulatorPanel.this.rightButtonPressed();
            }
        });
        Image rightButtonImage = UiPlugin.getDefault().getImage("icons/full/cview16/right.gif");
        this.rightButton.setImage(rightButtonImage);
        GridData rightButtonGridData = new GridData();
        rightButtonGridData.verticalAlignment = 4;
        rightButtonGridData.horizontalAlignment = 4;
        this.rightButton.setLayoutData((Object)rightButtonGridData);
        this.leftButton = new Button(controlButtons, 8);
        this.leftButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                AccumulatorPanel.this.leftButtonPressed();
            }
        });
        Image leftButtonImage = UiPlugin.getDefault().getImage("icons/full/cview16/left.gif");
        this.leftButton.setImage(leftButtonImage);
        GridData leftButtonGridData = new GridData();
        leftButtonGridData.verticalAlignment = 4;
        leftButtonGridData.horizontalAlignment = 4;
        this.leftButton.setLayoutData((Object)leftButtonGridData);
        this.allRightButton = new Button(controlButtons, 8);
        this.allRightButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                AccumulatorPanel.this.allRightButtonPressed();
            }
        });
        Image allRightButtonImage = UiPlugin.getDefault().getImage("icons/full/cview16/allRight.gif");
        this.allRightButton.setImage(allRightButtonImage);
        GridData allRightButtonGridData = new GridData();
        allRightButtonGridData.verticalAlignment = 4;
        allRightButtonGridData.horizontalAlignment = 4;
        this.allRightButton.setLayoutData((Object)allRightButtonGridData);
        this.allRightButton.setVisible(this.source.supportsAddAll());
        this.allLeftButton = new Button(controlButtons, 8);
        this.allLeftButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                AccumulatorPanel.this.allLeftButtonPressed();
            }
        });
        Image allLeftButtonImage = UiPlugin.getDefault().getImage("icons/full/cview16/allLeft.gif");
        this.allLeftButton.setImage(allLeftButtonImage);
        GridData allLeftButtonGridData = new GridData();
        allLeftButtonGridData.verticalAlignment = 4;
        allLeftButtonGridData.horizontalAlignment = 4;
        this.allLeftButton.setLayoutData((Object)allLeftButtonGridData);
        this.rightTable = new Table((Composite)this, 770);
        this.tableViewer = new TableViewer(this.rightTable);
        this.tableViewer.setSorter((ViewerSorter)new OrderableViewerSorter());
        if (this.labelProvider != null) {
            this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        }
        this.rightTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent ev) {
                AccumulatorPanel.this.rightSideControlSelectionChanged();
            }

            public void widgetSelected(SelectionEvent ev) {
                AccumulatorPanel.this.rightSideControlSelectionChanged();
            }
        });
        GridData rightTableGridData = new GridData();
        rightTableGridData.widthHint = this.rightSideWidthHint;
        rightTableGridData.heightHint = this.leftAndRightSideHeightHint;
        rightTableGridData.verticalAlignment = 4;
        rightTableGridData.horizontalAlignment = 4;
        rightTableGridData.grabExcessHorizontalSpace = true;
        rightTableGridData.grabExcessVerticalSpace = true;
        this.rightTable.setLayoutData((Object)rightTableGridData);
        Composite upDownButtons = new Composite((Composite)this, 0);
        GridData upDownButtonsGridData = new GridData();
        upDownButtonsGridData.verticalAlignment = 4;
        upDownButtonsGridData.horizontalAlignment = 4;
        upDownButtons.setLayoutData((Object)upDownButtonsGridData);
        GridLayout upDownButtonsGridLayout = new GridLayout();
        upDownButtonsGridLayout.verticalSpacing = 2;
        upDownButtons.setLayout((Layout)upDownButtonsGridLayout);
        this.upButton = new Button(upDownButtons, 8);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                AccumulatorPanel.this.upButtonPressed();
            }
        });
        Image upButtonImage = UiPlugin.getDefault().getImage("icons/full/cview16/up.gif");
        this.upButton.setImage(upButtonImage);
        GridData upButtonGridData = new GridData();
        upButtonGridData.verticalAlignment = 4;
        upButtonGridData.horizontalAlignment = 4;
        this.upButton.setLayoutData((Object)upButtonGridData);
        this.downButton = new Button(upDownButtons, 8);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                AccumulatorPanel.this.downButtonPressed();
            }
        });
        Image downButtonImage = UiPlugin.getDefault().getImage("icons/full/cview16/down.gif");
        this.downButton.setImage(downButtonImage);
        GridData downButtonGridData = new GridData();
        downButtonGridData.verticalAlignment = 4;
        downButtonGridData.horizontalAlignment = 4;
        this.downButton.setLayoutData((Object)downButtonGridData);
        Composite resetButtonComposite = new Composite((Composite)this, 0);
        GridLayout resetButtonGridLayout = new GridLayout();
        resetButtonGridLayout.marginHeight = this.resetButtonMarginHeight;
        resetButtonComposite.setLayout((Layout)resetButtonGridLayout);
        GridData resetButtonCompositeGridData = new GridData();
        resetButtonCompositeGridData.horizontalSpan = 2;
        resetButtonComposite.setLayoutData((Object)resetButtonCompositeGridData);
        this.resetButton = new Button(resetButtonComposite, 8);
        this.resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                AccumulatorPanel.this.resetButtonPressed();
            }
        });
        String resetButtonText = Util.getString("ButtonText.reset", new Object[0]);
        this.resetButton.setText(resetButtonText);
        GridData resetButtonGridData = new GridData(1808);
        resetButtonGridData.verticalAlignment = 8;
        resetButtonGridData.horizontalAlignment = 3;
        this.resetButton.setLayoutData((Object)resetButtonGridData);
        this.sortButton = new Button((Composite)this, 32);
        this.sortButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                AccumulatorPanel.this.sortButtonChanged();
            }
        });
        String sortButtonText = Util.getString("ButtonText.keepSortedAlphabetically", new Object[0]);
        this.sortButton.setText(sortButtonText);
        GridData sortButtonGridData = new GridData();
        sortButtonGridData.verticalAlignment = 1;
        sortButtonGridData.horizontalAlignment = 2;
        sortButtonGridData.horizontalSpan = 2;
        this.sortButton.setLayoutData((Object)sortButtonGridData);
        this.messageLabel = new MessageLabel(this);
        this.messageLabel.setAlignment(16384);
        this.messageLabel.setErrorStatus(null);
        this.messageLabel.setFont(this.getFont());
        GridData messageLabelGridData = new GridData(768);
        messageLabelGridData.horizontalSpan = 4;
        this.messageLabel.setLayoutData(messageLabelGridData);
        this.initiallyPopulateRightTable();
        this.setButtonStates();
        this.changeListeners = new ArrayList();
    }

    public void addAccumulatedValuesChangeListener(IAccumulatedValuesChangeListener listener) {
        this.changeListeners.add(listener);
    }

    private void initiallyPopulateRightTable() {
        this.rightTable.removeAll();
        Object[] items = this.initialRightSideItems.toArray();
        this.insertItemsIntoRightTable(items);
        this.notifyListeners();
    }

    private void insertItemsIntoRightTable(Object[] items) {
        if (!this.isSorting) {
            List order = this.rightTableItemsListWithItemsAppended(items);
            OrderableViewerSorter sorter = (OrderableViewerSorter)this.tableViewer.getSorter();
            sorter.setStringsOrder(order);
        }
        this.tableViewer.add(items);
    }

    void leftSideControlSelectionChanged() {
        if (!this.ignoreLeftSideSelectionChanges) {
            this.setButtonStates();
        }
    }

    void rightSideControlSelectionChanged() {
        if (!this.ignoreRightSideSelectionChanges) {
            this.setButtonStates();
        }
    }

    void rightButtonPressed() {
        Collection itemsToMoveToSelected = this.source.getSelectedAvailableValues();
        Object[] items = itemsToMoveToSelected.toArray();
        this.insertItemsIntoRightTable(items);
        this.ignoreLeftSideSelectionChanges = true;
        this.source.accumulatedValuesAdded(itemsToMoveToSelected);
        this.ignoreLeftSideSelectionChanges = false;
        this.setButtonStates();
        this.notifyListeners();
    }

    void leftButtonPressed() {
        int[] selectedItemIndices = this.rightTable.getSelectionIndices();
        Object[] selectedObjects = new Object[selectedItemIndices.length];
        int i = 0;
        while (i < selectedObjects.length) {
            selectedObjects[i] = this.tableViewer.getElementAt(selectedItemIndices[i]);
            ++i;
        }
        this.ignoreRightSideSelectionChanges = true;
        this.tableViewer.remove(selectedObjects);
        this.ignoreRightSideSelectionChanges = false;
        this.source.accumulatedValuesRemoved(Arrays.asList(selectedObjects));
        this.setButtonStates();
        this.notifyListeners();
    }

    void allRightButtonPressed() {
        Collection itemsToMoveToSelected = this.source.getAvailableValues();
        Object[] items = itemsToMoveToSelected.toArray();
        this.insertItemsIntoRightTable(items);
        this.ignoreLeftSideSelectionChanges = true;
        this.source.accumulatedValuesAdded(itemsToMoveToSelected);
        this.ignoreLeftSideSelectionChanges = false;
        this.setButtonStates();
        this.notifyListeners();
    }

    void allLeftButtonPressed() {
        Object[] obj = this.getRightTableItems();
        this.ignoreRightSideSelectionChanges = true;
        this.tableViewer.remove(obj);
        this.ignoreRightSideSelectionChanges = false;
        List<Object> itemsColl = Arrays.asList(obj);
        this.source.accumulatedValuesRemoved(itemsColl);
        this.setButtonStates();
        this.notifyListeners();
    }

    void upButtonPressed() {
        Object[] items = this.getRightTableItems();
        int[] selectedIndices = this.rightTable.getSelectionIndices();
        Object[] selectedItems = new Object[selectedIndices.length];
        int i = 0;
        while (i < selectedItems.length) {
            selectedItems[i] = items[selectedIndices[i]];
            ++i;
        }
        Object[] itemsInNewOrder = new Object[items.length];
        int firstSelectionIndex = selectedIndices[0];
        int lastSelectionIndex = selectedIndices[selectedIndices.length - 1];
        int i2 = 0;
        while (i2 < firstSelectionIndex - 1) {
            itemsInNewOrder[i2] = items[i2];
            ++i2;
        }
        Object itemMovingInBackOfSelections = items[firstSelectionIndex - 1];
        int i3 = firstSelectionIndex;
        while (i3 <= lastSelectionIndex) {
            itemsInNewOrder[i3 - 1] = items[i3];
            ++i3;
        }
        itemsInNewOrder[lastSelectionIndex] = itemMovingInBackOfSelections;
        i3 = lastSelectionIndex + 1;
        while (i3 < items.length) {
            itemsInNewOrder[i3] = items[i3];
            ++i3;
        }
        this.tableViewer.remove(items);
        ArrayList<String> order = new ArrayList<String>(itemsInNewOrder.length);
        int i4 = 0;
        while (i4 < itemsInNewOrder.length) {
            String text = this.labelProvider != null ? this.labelProvider.getText(itemsInNewOrder[i4]) : itemsInNewOrder[i4].toString();
            order.add(text);
            ++i4;
        }
        OrderableViewerSorter sorter = (OrderableViewerSorter)this.tableViewer.getSorter();
        sorter.setStringsOrder(order);
        this.tableViewer.add(items);
        List<Object> itemsList = Arrays.asList(this.getRightTableItems());
        int[] newSelectedIndices = new int[selectedIndices.length];
        int i5 = 0;
        while (i5 < newSelectedIndices.length) {
            newSelectedIndices[i5] = itemsList.indexOf(items[selectedIndices[i5]]);
            ++i5;
        }
        this.rightTable.setSelection(newSelectedIndices);
        this.setButtonStates();
    }

    void downButtonPressed() {
        Object[] items = this.getRightTableItems();
        int[] selectedIndices = this.rightTable.getSelectionIndices();
        Object[] selectedItems = new Object[selectedIndices.length];
        int i = 0;
        while (i < selectedItems.length) {
            selectedItems[i] = items[selectedIndices[i]];
            ++i;
        }
        Object[] itemsInNewOrder = new Object[items.length];
        int firstSelectionIndex = selectedIndices[0];
        int lastSelectionIndex = selectedIndices[selectedIndices.length - 1];
        int i2 = 0;
        while (i2 < firstSelectionIndex) {
            itemsInNewOrder[i2] = items[i2];
            ++i2;
        }
        Object itemMovingInFrontOfSelections = items[lastSelectionIndex + 1];
        int i3 = firstSelectionIndex;
        while (i3 <= lastSelectionIndex) {
            itemsInNewOrder[i3 + 1] = items[i3];
            ++i3;
        }
        itemsInNewOrder[firstSelectionIndex] = itemMovingInFrontOfSelections;
        i3 = lastSelectionIndex + 2;
        while (i3 < items.length) {
            itemsInNewOrder[i3] = items[i3];
            ++i3;
        }
        this.tableViewer.remove(items);
        ArrayList<String> order = new ArrayList<String>(itemsInNewOrder.length);
        int i4 = 0;
        while (i4 < itemsInNewOrder.length) {
            String text = this.labelProvider != null ? this.labelProvider.getText(itemsInNewOrder[i4]) : itemsInNewOrder[i4].toString();
            order.add(text);
            ++i4;
        }
        OrderableViewerSorter sorter = (OrderableViewerSorter)this.tableViewer.getSorter();
        sorter.setStringsOrder(order);
        this.tableViewer.add(items);
        List<Object> itemsList = Arrays.asList(this.getRightTableItems());
        int[] newSelectedIndices = new int[selectedIndices.length];
        int i5 = 0;
        while (i5 < newSelectedIndices.length) {
            newSelectedIndices[i5] = itemsList.indexOf(items[selectedIndices[i5]]);
            ++i5;
        }
        this.rightTable.setSelection(newSelectedIndices);
        this.setButtonStates();
    }

    void sortButtonChanged() {
        if (this.sortButton.getSelection()) {
            this.isSorting = true;
            OrderableViewerSorter sorter = (OrderableViewerSorter)this.tableViewer.getSorter();
            sorter.setStringsOrder(null);
            Object[] items = this.getRightTableItems();
            int[] selectedItemIndices = this.rightTable.getSelectionIndices();
            Object[] selectedItems = new Object[selectedItemIndices.length];
            int i = 0;
            while (i < selectedItems.length) {
                selectedItems[i] = items[selectedItemIndices[i]];
                ++i;
            }
            int vertScrollBarPosit = -1;
            if (this.rightTable.getVerticalBar().isVisible()) {
                vertScrollBarPosit = this.rightTable.getVerticalBar().getSelection();
            }
            int horizScrollBarPosit = -1;
            if (this.rightTable.getHorizontalBar().isVisible()) {
                horizScrollBarPosit = this.rightTable.getHorizontalBar().getSelection();
            }
            this.tableViewer.remove(items);
            this.tableViewer.add(items);
            List<Object> itemsList = Arrays.asList(this.getRightTableItems());
            int[] newSelectedItemIndices = new int[selectedItemIndices.length];
            int i2 = 0;
            while (i2 < newSelectedItemIndices.length) {
                newSelectedItemIndices[i2] = itemsList.indexOf(items[selectedItemIndices[i2]]);
                ++i2;
            }
            this.rightTable.setSelection(newSelectedItemIndices);
            if (vertScrollBarPosit >= 0) {
                this.rightTable.getVerticalBar().setSelection(vertScrollBarPosit);
            }
            if (horizScrollBarPosit >= 0) {
                this.rightTable.getHorizontalBar().setSelection(horizScrollBarPosit);
            }
        } else {
            this.isSorting = false;
        }
        this.setButtonStates();
    }

    private void setButtonStates() {
        int numLeftSideItems = this.source.getAvailableValuesCount();
        if (numLeftSideItems == 0 || !this.source.getSelectionStatus().isOK()) {
            this.rightButton.setEnabled(false);
            this.allRightButton.setEnabled(false);
        } else {
            this.allRightButton.setEnabled(true);
            int numLeftSideSelectedItems = this.source.getSelectedAvailableValuesCount();
            this.rightButton.setEnabled(numLeftSideSelectedItems > 0);
        }
        int numRightSideItems = this.rightTable.getItemCount();
        if (numRightSideItems == 0) {
            this.leftButton.setEnabled(false);
            this.allLeftButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        } else {
            this.allLeftButton.setEnabled(true);
            int numRightSideSelectedItems = this.rightTable.getSelectionCount();
            boolean anyRightSideItemsSelected = numRightSideSelectedItems > 0;
            this.leftButton.setEnabled(anyRightSideItemsSelected);
            if (this.sortButton.getSelection() || !anyRightSideItemsSelected) {
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            } else {
                boolean contiguous = this.isRightSideSelectionContiguous();
                if (contiguous) {
                    this.upButton.setEnabled(!this.isFirstRightSideItemSelected());
                    this.downButton.setEnabled(!this.isLastRightSideItemSelected());
                } else {
                    this.upButton.setEnabled(false);
                    this.downButton.setEnabled(false);
                }
            }
        }
        this.setStatus(this.source.getSelectionStatus());
    }

    private void setStatus(IStatus status) {
        this.messageLabel.setErrorStatus(status);
    }

    private boolean isRightSideSelectionContiguous() {
        boolean contiguous;
        int[] indices = this.rightTable.getSelectionIndices();
        if (indices.length == 0) {
            contiguous = false;
        } else {
            boolean gapFound = false;
            int i = 0;
            while (i < indices.length - 1 && !gapFound) {
                if (indices[i + 1] - indices[i] > 1) {
                    gapFound = true;
                    continue;
                }
                ++i;
            }
            contiguous = !gapFound;
        }
        return contiguous;
    }

    private boolean isFirstRightSideItemSelected() {
        int[] indices = this.rightTable.getSelectionIndices();
        boolean firstItemSelected = indices.length == 0 ? false : indices[0] == 0;
        return firstItemSelected;
    }

    private boolean isLastRightSideItemSelected() {
        int[] indices = this.rightTable.getSelectionIndices();
        boolean lastItemSelected = indices.length == 0 ? false : indices[indices.length - 1] == this.rightTable.getItemCount() - 1;
        return lastItemSelected;
    }

    void resetButtonPressed() {
        Collection itemsThatWereAddedToRight = this.getItemsMovedToSelected();
        Collection itemsThatWereRemovedFromRight = this.getItemsRemovedFromSelected();
        this.initiallyPopulateRightTable();
        this.source.accumulatedValuesRemoved(itemsThatWereAddedToRight);
        this.source.accumulatedValuesAdded(itemsThatWereRemovedFromRight);
        this.setButtonStates();
    }

    private Object[] getRightTableItems() {
        int numItems = this.rightTable.getItemCount();
        Object[] items = new Object[numItems];
        int i = 0;
        while (i < numItems) {
            items[i] = this.tableViewer.getElementAt(i);
            ++i;
        }
        return items;
    }

    private List rightTableItemsListWithItemsAppended(Object[] newItems) {
        String text;
        Object curObj;
        Object[] items = this.getRightTableItems();
        ArrayList<String> itemsList = new ArrayList<String>(items.length + newItems.length);
        int i = 0;
        while (i < items.length) {
            curObj = this.tableViewer.getElementAt(i);
            text = this.labelProvider != null ? this.labelProvider.getText(curObj) : curObj.toString();
            itemsList.add(text);
            ++i;
        }
        i = 0;
        while (i < newItems.length) {
            curObj = newItems[i];
            text = this.labelProvider != null ? this.labelProvider.getText(curObj) : curObj.toString();
            itemsList.add(text);
            ++i;
        }
        return itemsList;
    }

    public Collection getItemsMovedToSelected() {
        Object[] obj = this.getRightTableItems();
        ArrayList<Object> itemsThatWereAddedToRight = new ArrayList<Object>(obj.length);
        int i = 0;
        while (i < obj.length) {
            if (!this.initialRightSideItems.contains(obj[i])) {
                itemsThatWereAddedToRight.add(obj[i]);
            }
            ++i;
        }
        return itemsThatWereAddedToRight;
    }

    public Collection getItemsRemovedFromSelected() {
        ArrayList itemsThatWereRemovedFromRight = new ArrayList(this.initialRightSideItems.size());
        List<Object> rightSideItems = Arrays.asList(this.getRightTableItems());
        for (Object curItem : this.initialRightSideItems) {
            boolean hasBeenRemoved;
            boolean bl = hasBeenRemoved = !rightSideItems.contains(curItem);
            if (!hasBeenRemoved) continue;
            itemsThatWereRemovedFromRight.add(curItem);
        }
        return itemsThatWereRemovedFromRight;
    }

    public Collection getSelectedItems() {
        Object[] obj = this.getRightTableItems();
        List<Object> coll = Arrays.asList(obj);
        return coll;
    }

    public void repopulateSelectedItems(Collection newSelectedItems) {
        int numRightSideItems = this.rightTable.getItemCount();
        Object[] rightSideItems = new Object[numRightSideItems];
        int i = 0;
        while (i < numRightSideItems) {
            rightSideItems[i] = this.tableViewer.getElementAt(i);
            ++i;
        }
        this.tableViewer.remove(rightSideItems);
        for (Object item : newSelectedItems) {
            this.tableViewer.add(item);
        }
        this.source.accumulatedValuesAdded(newSelectedItems);
        this.notifyListeners();
    }

    public void availableItemsHaveChanged() {
        this.setButtonStates();
    }

    private void notifyListeners() {
        if (this.changeListeners != null) {
            int numListeners = this.changeListeners.size();
            int i = numListeners - 1;
            while (i >= 0) {
                IAccumulatedValuesChangeListener listener = (IAccumulatedValuesChangeListener)this.changeListeners.get(i);
                listener.accumulatedValuesChanged(this);
                --i;
            }
        }
    }
}

