/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.util;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.UiConstants;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.wizard.IPersistentWizardPage;

public final class WizardUtil
implements InternalUiConstants.Widgets,
CoreStringUtil.Constants,
UiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(WizardUtil.class);
    private static final String SENTENCE_SEPARATOR = "  ";
    private static final String CLOSED_PROJECT_MESSAGE = WizardUtil.getString("closedProjectMessage");
    private static final String MISSING_FILE_MESSAGE = WizardUtil.getString("missingFileMessage");
    private static final String MISSING_FOLDER_MESSAGE = WizardUtil.getString("missingFolderMessage");
    private static final String INVALID_FOLDER_MESSAGE = WizardUtil.getString("invalidFolderMessage");

    public static void initialize(Wizard wizard, AbstractUIPlugin plugin, String title, ImageDescriptor image) {
        wizard.setDialogSettings(WidgetUtil.initializeSettings(wizard, plugin));
        wizard.setWindowTitle(title);
        if (image != null) {
            wizard.setDefaultPageImageDescriptor(image);
        }
    }

    public static void saveSettings(IWizard wizard) {
        IWizardPage[] pgs = wizard.getPages();
        int ndx = 0;
        while (ndx < pgs.length) {
            IWizardPage pg = pgs[ndx];
            if (pg instanceof IPersistentWizardPage) {
                ((IPersistentWizardPage)pgs[ndx]).saveSettings();
            }
            ++ndx;
        }
    }

    public static void setPageComplete(WizardPage page) {
        WizardUtil.setPageComplete(page, null);
    }

    public static void setPageComplete(WizardPage page, String message) {
        WizardUtil.setPageComplete(page, message, 0, null);
    }

    public static void setPageComplete(WizardPage page, String message, int status) {
        WizardUtil.setPageComplete(page, message, status, null);
    }

    public static void setPageComplete(WizardPage page, String message, int status, Control control) {
        CoreArgCheck.isNotNull((Object)page);
        page.setPageComplete(status != 3);
        if (status == 0) {
            message = message == null ? "" : String.valueOf(message) + SENTENCE_SEPARATOR;
            IWizard wizard = page.getWizard();
            boolean nextPg = wizard.getNextPage((IWizardPage)page) != null;
            boolean canFinish = wizard.canFinish();
            message = nextPg && canFinish ? String.valueOf(message) + VALID_LAST_OR_MIDDLE_PAGE_MESSAGE : (nextPg ? String.valueOf(message) + VALID_PAGE_MESSAGE : String.valueOf(message) + VALID_LAST_PAGE_MESSAGE);
            page.setMessage(message);
        } else {
            CoreArgCheck.isNotNull((Object)message);
            page.setMessage(message, status);
        }
        if (control != null) {
            control.setFocus();
        }
    }

    public static int getMessageSeverity(int statusSeverity) {
        switch (statusSeverity) {
            case 4: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    public static IContainer validateFileAndFolder(Text fileText, Text folderText, WizardPage page, String fileExtension, int existsLevel) throws CoreException {
        return WizardUtil.validateFileAndFolder(fileText, folderText, page, fileExtension, existsLevel, false);
    }

    public static IContainer validateFileAndFolder(Text fileText, Text folderText, WizardPage page, String fileExtension, boolean forceFileExtension) throws CoreException {
        return WizardUtil.validateFileAndFolder(fileText, folderText, page, fileExtension, 3, forceFileExtension);
    }

    public static IContainer validateFileAndFolder(Text fileText, Text folderText, WizardPage page, String fileExtension, int existsLevel, boolean forceFileExtension) throws CoreException {
        CoreArgCheck.isNotNull((Object)fileText);
        CoreArgCheck.isNotNull((Object)folderText);
        CoreArgCheck.isNotNull((Object)page);
        CoreArgCheck.isNotNull((Object)fileExtension);
        String fileName = fileText.getText();
        if (CoreStringUtil.isEmpty((String)fileName)) {
            WizardUtil.setPageComplete(page, MISSING_FILE_MESSAGE, 3);
        } else {
            if (forceFileExtension && !fileName.endsWith(fileExtension)) {
                fileName = FileUtils.toFileNameWithExtension((String)fileName, (String)fileExtension, (boolean)true);
                int ndx = fileText.getCaretPosition();
                fileText.setText(fileName);
                fileText.setSelection(ndx);
                page.setPageComplete(false);
                return null;
            }
            if (!ModelerCore.getWorkspace().validateName(fileName, 1).isOK()) {
                WizardUtil.setPageComplete(page, INVALID_FILE_MESSAGE, 3);
            } else {
                String folderName = folderText.getText();
                if (CoreStringUtil.isEmpty((String)folderName)) {
                    WizardUtil.setPageComplete(page, MISSING_FOLDER_MESSAGE, 3);
                } else {
                    IResource resrc = ModelerCore.getWorkspace().getRoot().findMember(folderName);
                    if (resrc == null || !(resrc instanceof IContainer) || resrc.getProject() == null) {
                        WizardUtil.setPageComplete(page, INVALID_FOLDER_MESSAGE, 3);
                    } else if (!resrc.getProject().isOpen()) {
                        WizardUtil.setPageComplete(page, CLOSED_PROJECT_MESSAGE, 3);
                    } else {
                        String errorMsg = null;
                        IContainer folder = (IContainer)resrc;
                        boolean exists = false;
                        IResource[] resrcs = folder.members();
                        fileName = FileUtils.toFileNameWithExtension((String)fileName, (String)fileExtension);
                        int ndx = resrcs.length;
                        while (--ndx >= 0) {
                            if (!resrcs[ndx].getName().equalsIgnoreCase(fileName)) continue;
                            exists = true;
                            errorMsg = WidgetUtil.getFileExistsMessage(folder.getFile((IPath)new Path(fileName)));
                            break;
                        }
                        if (!exists) {
                            exists = folder.getLocation().append(fileName).toFile().exists();
                            errorMsg = WidgetUtil.getFileExistsButNotInWorkspaceMessage(folder.getFile((IPath)new Path(fileName)));
                        }
                        if (existsLevel != 0 && exists) {
                            WizardUtil.setPageComplete(page, errorMsg, existsLevel);
                        } else {
                            WizardUtil.setPageComplete(page);
                        }
                        return folder;
                    }
                }
            }
        }
        return null;
    }

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private WizardUtil() {
    }
}

