/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.table;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.teiid.designer.ui.common.InternalUiConstants;

public class TablePrinter {
    private Table table;
    private GC gc;
    private FontData fontData;
    private int iAverageCharWidth;
    private int iColumnCharFudgeFactor;
    private int iLineHeight;
    private Rectangle clientArea;
    private int iTableRowMargin;
    private TableColumn[] columns;
    private TableItem[] items;
    private ArrayList[] columnsPerSectionArray;
    private int x;
    private int y;
    private static final String TAB_DELIM_FILEEXT = ".txt";
    private static final String COMMA_DELIM_FILEEXT = ".csv";
    private String DEFAULT_FILEEXT = ".csv";
    private static final String TAB_CHOOSER_FILEEXT_PATTERN = "*.txt";
    private static final String COMMA_CHOOSER_FILEEXT_PATTERN = "*.csv";
    private static final char NEWLINE = '\n';
    private static final char TAB = '\t';
    private static final char COMMA = ',';
    private static final char PERIOD = '.';
    private char chDelim = (char)44;
    private static final String PRINT_JOB_STATUS = InternalUiConstants.Util.getString("TablePrinter.jobStatus", new Object[0]);
    private static final String FILE_CHOOSER_DIALOG_TITLE = InternalUiConstants.Util.getString("TablePrinter.fileChooserDialog.title", new Object[0]);
    private static final String DEFAULT_FILENAME = InternalUiConstants.Util.getString("TablePrinter.defaultFileName.text", new Object[0]);
    private static final String CSV_EXTENSION_DESC = InternalUiConstants.Util.getString("TablePrinter.csvExtensionDescription.text", new Object[0]);
    private static final String TAB_EXTENSION_DESC = InternalUiConstants.Util.getString("TablePrinter.tabExtensionDescription.text", new Object[0]);

    public void printTable(Table table) {
        this.table = table;
        PrintDialog dialog = new PrintDialog(this.getShell());
        PrinterData data = dialog.open();
        if (data != null) {
            if (data.printToFile) {
                this.printToFile(table);
            } else {
                this.printToPaper(table, data);
            }
        }
    }

    private Shell getShell() {
        return this.table.getShell();
    }

    private void printToPaper(Table table, PrinterData data) {
        Printer printer = new Printer(data);
        if (printer.startJob(PRINT_JOB_STATUS)) {
            this.gc = new GC((Drawable)printer);
            this.fontData = table.getFont().getFontData()[0];
            Font fntStandard = new Font((Device)printer, this.fontData.getName(), this.fontData.getHeight(), this.fontData.getStyle());
            Font fntBold = new Font((Device)printer, this.fontData.getName(), this.fontData.getHeight(), 1);
            this.iAverageCharWidth = this.gc.getFontMetrics().getAverageCharWidth();
            this.iColumnCharFudgeFactor = 3;
            this.iLineHeight = this.fontData.getHeight() * 4;
            this.iTableRowMargin = this.iAverageCharWidth * 24;
            this.clientArea = printer.getClientArea();
            this.columns = table.getColumns();
            this.items = table.getItems();
            this.x = this.clientArea.x;
            this.y = this.clientArea.y;
            this.createColumnsPerSectionArray();
            int iSection = 0;
            while (iSection < this.columnsPerSectionArray.length) {
                ArrayList aryl = this.columnsPerSectionArray[iSection];
                if (aryl == null) break;
                this.gc.setFont(fntBold);
                int iEntry = 0;
                while (iEntry < aryl.size()) {
                    ColumnData cdColData = (ColumnData)aryl.get(iEntry);
                    this.gc.drawText(this.columns[cdColData.iIndex].getText(), this.x, this.y);
                    this.x += cdColData.iWidth;
                    ++iEntry;
                }
                this.y += this.iLineHeight * 3;
                this.x = this.clientArea.x;
                this.gc.setFont(fntStandard);
                int row = 0;
                while (row < this.items.length) {
                    int iEntry2 = 0;
                    while (iEntry2 < aryl.size()) {
                        ColumnData cdColData = (ColumnData)aryl.get(iEntry2);
                        this.gc.drawText(this.items[row].getText(cdColData.iIndex), this.x, this.y);
                        this.x += cdColData.iWidth;
                        ++iEntry2;
                    }
                    this.x = this.clientArea.x;
                    this.y += this.iLineHeight * 3;
                    ++row;
                }
                this.x = this.clientArea.x;
                this.y += this.iLineHeight * 3;
                this.y += this.iLineHeight * 3;
                ++iSection;
            }
            printer.endJob();
        }
    }

    private int calcColumnWidth(int iColumn) {
        int iGreatestColWidth = this.columns[iColumn].getText().length();
        String sText = "";
        int iRow = 0;
        while (iRow < this.items.length) {
            sText = this.items[iRow].getText(iColumn);
            if (sText.length() > iGreatestColWidth) {
                iGreatestColWidth = sText.length();
            }
            ++iRow;
        }
        iGreatestColWidth = this.iAverageCharWidth * (iGreatestColWidth + this.iColumnCharFudgeFactor);
        return iGreatestColWidth;
    }

    private ArrayList[] createColumnsPerSectionArray() {
        int iCurrentSection = 0;
        int iCurrentX = 0;
        this.columnsPerSectionArray = new ArrayList[this.columns.length];
        this.columnsPerSectionArray[iCurrentSection] = new ArrayList();
        int iColIndex = 0;
        while (iColIndex < this.columns.length) {
            int iColWidth = this.calcColumnWidth(iColIndex);
            int iNewX = iCurrentX + iColWidth;
            if (iNewX > this.clientArea.width - this.iTableRowMargin) {
                this.columnsPerSectionArray[++iCurrentSection] = new ArrayList();
                this.columnsPerSectionArray[iCurrentSection].add(new ColumnData(iColIndex, iColWidth));
                iCurrentX = 0;
            } else {
                this.columnsPerSectionArray[iCurrentSection].add(new ColumnData(iColIndex, iColWidth));
                iCurrentX += iColWidth;
            }
            ++iColIndex;
        }
        return this.columnsPerSectionArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void printToFile(Table table) {
        String sFileSpec;
        PrintWriter pwPrintWriter;
        BufferedWriter bwOutWriter;
        OutputStreamWriter fwFileWriter;
        StringBuffer sbText;
        char chDelim;
        block33: {
            block34: {
                this.columns = table.getColumns();
                this.items = table.getItems();
                chDelim = this.getDelimiter();
                sbText = new StringBuffer();
                fwFileWriter = null;
                bwOutWriter = null;
                pwPrintWriter = null;
                sFileSpec = this.getTargetPath();
                if (sFileSpec != null) break block33;
                if (pwPrintWriter == null) break block34;
                pwPrintWriter.close();
            }
            try {
                if (bwOutWriter != null) {
                    bwOutWriter.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fwFileWriter == null) return;
                fwFileWriter.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        try {
            try {
                chDelim = sFileSpec.endsWith(COMMA_DELIM_FILEEXT) ? (char)',' : '\t';
                int col = 0;
                while (col < this.columns.length) {
                    if (col > 0) {
                        sbText.append(chDelim);
                    }
                    sbText.append(this.columns[col].getText());
                    ++col;
                }
                sbText.append('\n');
                int row = 0;
                while (row < this.items.length) {
                    int col2 = 0;
                    while (col2 < this.columns.length) {
                        if (col2 > 0) {
                            sbText.append(chDelim);
                        }
                        sbText.append(this.items[row].getText(col2));
                        ++col2;
                    }
                    sbText.append('\n');
                    ++row;
                }
                fwFileWriter = new FileWriter(sFileSpec);
                bwOutWriter = new BufferedWriter(fwFileWriter);
                pwPrintWriter = new PrintWriter(bwOutWriter);
                pwPrintWriter.write(sbText.toString());
            }
            catch (IOException ioe) {
                InternalUiConstants.Util.log((Throwable)ioe);
                if (pwPrintWriter != null) {
                    pwPrintWriter.close();
                }
                try {
                    if (bwOutWriter != null) {
                        bwOutWriter.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fwFileWriter == null) return;
                    fwFileWriter.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            if (pwPrintWriter != null) {
                pwPrintWriter.close();
            }
            try {
                if (bwOutWriter != null) {
                    bwOutWriter.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fwFileWriter == null) throw throwable;
                fwFileWriter.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        if (pwPrintWriter != null) {
            pwPrintWriter.close();
        }
        try {
            if (bwOutWriter != null) {
                bwOutWriter.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (fwFileWriter == null) return;
            fwFileWriter.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public void setDelimiter(char chDelim) {
        this.chDelim = chDelim;
        if (this.chDelim == ',') {
            this.DEFAULT_FILEEXT = COMMA_DELIM_FILEEXT;
        }
        if (this.chDelim == '\t') {
            this.DEFAULT_FILEEXT = TAB_DELIM_FILEEXT;
        }
    }

    public char getDelimiter() {
        return this.chDelim;
    }

    public String getTargetPath() {
        FileDialog dlg = new FileDialog(this.getShell(), 8196);
        dlg.setFilterExtensions(new String[]{COMMA_CHOOSER_FILEEXT_PATTERN, TAB_CHOOSER_FILEEXT_PATTERN});
        dlg.setFilterNames(new String[]{CSV_EXTENSION_DESC, TAB_EXTENSION_DESC});
        dlg.setText(FILE_CHOOSER_DIALOG_TITLE);
        dlg.setFileName(String.valueOf(DEFAULT_FILENAME) + this.DEFAULT_FILEEXT);
        String sPath = dlg.open();
        if (sPath != null && sPath.indexOf(46) == -1) {
            sPath = String.valueOf(sPath) + this.DEFAULT_FILEEXT;
        }
        return sPath;
    }

    class ColumnData {
        public int iIndex;
        public int iWidth;

        public ColumnData(int iIndex, int iWidth) {
            this.iIndex = iIndex;
            this.iWidth = iWidth;
        }
    }
}

