/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.table;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.teiid.designer.ui.common.UiConstants;
import org.teiid.designer.ui.common.table.ColumnProvider;
import org.teiid.designer.ui.common.table.Table;
import org.teiid.designer.ui.common.table.TableProvider;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.ButtonProvider;

public final class TableAndButtonsGroup<T> {
    static final String ADD_BUTTON = UiConstants.Util.getString("addButton", new Object[0]);
    static final String EDIT_BUTTON = UiConstants.Util.getString("editButton", new Object[0]);
    static final String REMOVE_BUTTON = UiConstants.Util.getString("removeButton", new Object[0]);
    static final String NEW_BUTTON = UiConstants.Util.getString("newButton", new Object[0]);
    private final Group group;
    final Table<T> table;
    final Composite buttonBar;
    final Map<Button, ButtonProvider> buttonProvidersByButton = new ConcurrentHashMap<Button, ButtonProvider>();

    public <V> TableAndButtonsGroup(Composite parent, String title, int span, final TableProvider<T> tableProvider, ColumnProvider<T, V> ... columnProviders) {
        this.group = new Group(parent, 0);
        this.group.setText(title);
        this.group.setLayout((Layout)new GridLayout(2, false));
        this.group.setLayoutData((Object)new GridData(4, 4, true, true, span, 1));
        this.table = new Table<T>((Composite)this.group, tableProvider, columnProviders);
        this.buttonBar = WidgetFactory.createPanel((Composite)this.group, 8, 4);
        if (tableProvider.isDoubleClickSupported()) {
            this.table.getViewer().addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    tableProvider.doubleClicked(((IStructuredSelection)event.getSelection()).getFirstElement());
                }
            });
        }
    }

    public void add(final ButtonProvider buttonProvider) {
        Button button = WidgetFactory.createButton(this.buttonBar, buttonProvider.getText(), 320);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                buttonProvider.selected((IStructuredSelection)TableAndButtonsGroup.this.table.getViewer().getSelection());
                TableAndButtonsGroup.this.table.getViewer().refresh();
            }
        });
        if (!buttonProvider.isEnabled((IStructuredSelection)this.table.getViewer().getSelection())) {
            button.setEnabled(false);
        }
        if (this.buttonProvidersByButton.isEmpty()) {
            this.table.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    Control[] controlArray = TableAndButtonsGroup.this.buttonBar.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        boolean enabled;
                        ButtonProvider provider;
                        Control control = controlArray[n2];
                        if (control instanceof Button && (provider = TableAndButtonsGroup.this.buttonProvidersByButton.get(control)) != null && (enabled = provider.isEnabled(selection)) != control.isEnabled()) {
                            control.setEnabled(enabled);
                        }
                        ++n2;
                    }
                }
            });
        }
        this.buttonProvidersByButton.put(button, buttonProvider);
    }

    public Group getGroup() {
        return this.group;
    }

    public Table<T> getTable() {
        return this.table;
    }

    public void setInput(Object input) {
        this.table.setInput(input);
    }

    public abstract class AddButtonProvider
    implements ButtonProvider {
        protected abstract void add();

        @Override
        public final String getText() {
            return ADD_BUTTON;
        }

        @Override
        public boolean isEnabled(IStructuredSelection selection) {
            return true;
        }

        @Override
        public final void selected(IStructuredSelection selection) {
            this.add();
            if (TableAndButtonsGroup.this.table.getViewer().getTable().getItemCount() == 1) {
                TableAndButtonsGroup.this.table.packColumns();
            }
        }
    }

    public abstract class EditButtonProvider
    implements ButtonProvider {
        @Override
        public final String getText() {
            return EDIT_BUTTON;
        }

        @Override
        public boolean isEnabled(IStructuredSelection selection) {
            return selection.size() == 1;
        }
    }

    public abstract class NewButtonProvider
    implements ButtonProvider {
        @Override
        public final String getText() {
            return NEW_BUTTON;
        }

        @Override
        public boolean isEnabled(IStructuredSelection selection) {
            return true;
        }
    }

    public abstract class RemoveButtonProvider
    implements ButtonProvider {
        @Override
        public final String getText() {
            return REMOVE_BUTTON;
        }

        @Override
        public boolean isEnabled(IStructuredSelection selection) {
            return !selection.isEmpty();
        }
    }
}

