/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.table;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableColumn;
import org.teiid.designer.ui.common.table.ColumnProvider;
import org.teiid.designer.ui.common.table.TableProvider;

public class Table<T> {
    final TableViewer viewer;
    final List<TableViewerColumn> columns;

    public <V> Table(Composite parent, TableProvider<T> tableProvider, ColumnProvider<T, V> ... columnProviders) {
        this(parent, -1, tableProvider, columnProviders);
    }

    public <V> Table(Composite parent, int tableStyle, final TableProvider<T> tableProvider, final ColumnProvider<T, V> ... columnProviders) {
        this.viewer = tableStyle == -1 ? new TableViewer(parent) : new TableViewer(parent, tableStyle);
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return tableProvider.getElements();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        final org.eclipse.swt.widgets.Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.columns = new ArrayList<TableViewerColumn>();
        ColumnProvider<T, V>[] columnProviderArray = columnProviders;
        int n = columnProviders.length;
        int n2 = 0;
        while (n2 < n) {
            final ColumnProvider<T, V> columnProvider = columnProviderArray[n2];
            TableViewerColumn viewerCol = new TableViewerColumn(this.viewer, columnProvider.getAlignment());
            this.columns.add(viewerCol);
            viewerCol.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public Image getImage(Object element) {
                    if (columnProvider.getAlignment() != 16384) {
                        return null;
                    }
                    return columnProvider.getImage(element);
                }

                public String getText(Object element) {
                    return columnProvider.getText(element);
                }

                public String getToolTipText(Object element) {
                    return columnProvider.getToolTip(element);
                }
            });
            viewerCol.setEditingSupport(new EditingSupport((ColumnViewer)this.viewer){

                protected boolean canEdit(Object element) {
                    return columnProvider.isEditable(element);
                }

                protected CellEditor getCellEditor(Object element) {
                    try {
                        return columnProvider.getEditorClass().getConstructor(Composite.class).newInstance(table);
                    }
                    catch (Exception error) {
                        throw new RuntimeException(error);
                    }
                }

                protected Object getValue(Object element) {
                    return columnProvider.getValue(element);
                }

                protected void setValue(Object element, Object value) {
                    columnProvider.setValue(element, value);
                    Table.this.viewer.update(element, null);
                }
            });
            TableColumn col = viewerCol.getColumn();
            if (columnProvider.getName() != null) {
                col.setText(columnProvider.getName());
            } else if (columnProvider.getImage() != null) {
                col.setImage(columnProvider.getImage());
            }
            col.setMoveable(false);
            col.setResizable(columnProvider.isResizable());
            ++n2;
        }
        Listener paintListener = new Listener(){

            public void handleEvent(Event event) {
                Image image;
                ColumnProvider columnProvider = columnProviders[event.index];
                Image image2 = image = columnProvider.getAlignment() == 16384 ? null : columnProvider.getImage(event.item.getData());
                if (image == null) {
                    return;
                }
                int cellWidth = table.getColumn(event.index).getWidth();
                switch (event.type) {
                    case 41: {
                        Rectangle rect = image.getBounds();
                        event.width = cellWidth;
                        event.height = Math.max(event.height, rect.height);
                        break;
                    }
                    case 42: {
                        Rectangle rect = image.getBounds();
                        int xOffset = (cellWidth - rect.width) / 2;
                        int yOffset = (event.height - rect.height) / 2;
                        event.gc.drawImage(image, event.x + xOffset, event.y + yOffset);
                    }
                }
            }
        };
        table.addListener(41, paintListener);
        table.addListener(42, paintListener);
        this.viewer.setSorter(new ViewerSorter(){
            private final Integer[] indexes;
            {
                ArrayList<Integer> indexes = new ArrayList<Integer>();
                int ndx = 0;
                int len = columnProviderArray.length;
                while (ndx < len) {
                    if (columnProviderArray[ndx].isSortable()) {
                        indexes.add(ndx);
                    }
                    ++ndx;
                }
                this.indexes = indexes.toArray(new Integer[indexes.size()]);
            }

            public int compare(Viewer viewer, Object element1, Object element2) {
                Integer[] integerArray = this.indexes;
                int n = this.indexes.length;
                int n2 = 0;
                while (n2 < n) {
                    Integer ndx = integerArray[n2];
                    int result = columnProviders[ndx].compare(element1, element2);
                    if (result != 0) {
                        return result;
                    }
                    ++n2;
                }
                return 0;
            }
        });
    }

    public TableViewerColumn getColumn(int index) {
        return this.columns.get(index);
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    void packColumns() {
        TableColumn[] tableColumnArray = this.viewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            String title = col.getText();
            if (col.getAlignment() == 0x1000000) {
                col.setText("M" + title + "M");
            }
            if (col.getAlignment() == 131072) {
                col.setText("MM" + title);
            }
            col.setText(String.valueOf(title) + "MM");
            col.pack();
            col.setText(title);
            ++n2;
        }
    }

    public void setInput(Object input) {
        this.viewer.setInput(input);
        this.packColumns();
    }
}

