/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.common.actions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchPage;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.common.AbstractUiPlugin;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.actions.AbstractAction;
import org.teiid.designer.ui.common.actions.ActionService;
import org.teiid.designer.ui.common.actions.GlobalActionsMap;

public abstract class AbstractActionService
implements ActionService,
InternalUiConstants {
    private static final String PREFIX = "AbstractActionService.";
    private IActionBars actionBars;
    private Map<String, IAction> actionMap = new HashMap<String, IAction>();
    private AbstractUiPlugin plugin;
    private IWorkbenchWindow window;
    private IWorkbenchPage myPage;

    public AbstractActionService(AbstractUiPlugin thePlugin, IWorkbenchPage page) {
        this.plugin = thePlugin;
        CoreArgCheck.isNotNull((Object)page);
        this.myPage = page;
        this.setWorkbenchWindow(page.getWorkbenchWindow());
        this.actionBars = ((WorkbenchPage)page).getActionBars();
    }

    @Override
    public void addResourceChangeListener(IResourceChangeListener theListener) {
        IWorkspace workspace = ModelerCore.getWorkspace();
        workspace.addResourceChangeListener(theListener);
    }

    @Override
    public void addWorkbenchSelectionListener(ISelectionListener theListener) {
        if (this.window == null) {
            throw new IllegalStateException(Util.getString("AbstractActionService.WorkbenchWindowIsNullMessage", new Object[0]));
        }
        ISelectionService service = this.window.getSelectionService();
        IWorkbenchPart activePart = this.window.getPartService().getActivePart();
        service.addSelectionListener(theListener);
        theListener.selectionChanged(activePart, service.getSelection());
    }

    public void addPartListener(IPartListener theListener) {
        if (this.window == null) {
            throw new IllegalStateException(Util.getString("AbstractActionService.WorkbenchWindowIsNullMessage", new Object[0]));
        }
        this.window.getPartService().addPartListener(theListener);
        theListener.partActivated(this.window.getPartService().getActivePart());
    }

    @Override
    public void contributeToContextMenu(IMenuManager theMenuMgr, GlobalActionsMap theActionsMap, ISelection theSelection) {
    }

    @Override
    public void contributePermanentActionsToContextMenu(IMenuManager theMenuMgr, ISelection theSelection) {
    }

    @Override
    public IAction getAction(String theActionId) throws CoreException {
        CoreArgCheck.isNotNull((Object)theActionId);
        IAction result = this.actionMap.get(theActionId);
        if (result == null) {
            Class<?> actionClass = null;
            try {
                actionClass = ((Object)((Object)this.plugin)).getClass().getClassLoader().loadClass(theActionId);
                result = this.getAction(actionClass);
            }
            catch (ClassNotFoundException theException) {
                String msg = Util.getString("AbstractActionService.ProblemFindingActionClassMessage", new Object[]{theActionId});
                throw new CoreException((IStatus)new Status(4, this.plugin.getBundle().getSymbolicName(), 0, msg, (Throwable)theException));
            }
        }
        return result;
    }

    public IAction getAction(Class<? extends IAction> theActionClass) throws CoreException {
        CoreArgCheck.isNotNull(theActionClass);
        String actionName = theActionClass.getName();
        IAction result = this.actionMap.get(actionName);
        if (result == null) {
            try {
                result = theActionClass.newInstance();
                this.registerEventHandler(result);
                this.registerAction(actionName, result);
            }
            catch (Exception theException) {
                System.out.println("[AbstractActionService.getAction] Exception is: " + theException.getClass().getName());
                if (theException instanceof IllegalAccessException || theException instanceof InstantiationException || theException instanceof NullPointerException) {
                    String msg = Util.getString("AbstractActionService.FailureConstructingActionMessage", new Object[]{theActionClass});
                    throw new CoreException((IStatus)new Status(4, this.plugin.getBundle().getSymbolicName(), 0, msg, (Throwable)theException));
                }
                throw new RuntimeException(theException.getMessage());
            }
        }
        return result;
    }

    protected IAction getAction(String theActionId, GlobalActionsMap theActionMap) {
        IAction result = null;
        if (theActionMap.isUnsupportedAction(theActionId)) {
            result = theActionMap.getAction(theActionId);
            IAction defaultAction = this.getDefaultAction(theActionId);
            result.setText(defaultAction.getText());
            result.setToolTipText(defaultAction.getToolTipText());
            result.setImageDescriptor(defaultAction.getImageDescriptor());
            result.setHoverImageDescriptor(defaultAction.getHoverImageDescriptor());
            result.setDisabledImageDescriptor(defaultAction.getDisabledImageDescriptor());
        } else {
            result = theActionMap.isDefaultAction(theActionId) ? this.getDefaultAction(theActionId) : theActionMap.getAction(theActionId);
        }
        return result;
    }

    protected IActionBars getActionBars() {
        return this.actionBars;
    }

    @Override
    public AbstractUiPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public IWorkbenchWindow getWorkbenchWindow() {
        if (this.window == null) {
            throw new IllegalStateException(Util.getString("AbstractActionService.WorkbenchWindowIsNullMessage", new Object[0]));
        }
        return this.window;
    }

    protected IWorkbenchPage getPage() {
        return this.myPage;
    }

    @Override
    public boolean registerAction(String sActionKey, IAction theAction) {
        if (this.actionMap.containsKey(sActionKey)) {
            return false;
        }
        if (!IAction.class.isAssignableFrom(theAction.getClass())) {
            CoreArgCheck.isTrue((boolean)IAction.class.isAssignableFrom(theAction.getClass()), (String)Util.getString("AbstractActionService.ClassNotAssignableToIActionMessage", new Object[]{theAction}));
        }
        this.actionMap.put(sActionKey, theAction);
        return true;
    }

    @Override
    public boolean isRegistered(String theActionId) {
        return this.actionMap.containsKey(theActionId);
    }

    protected void registerEventHandler(IAction theAction) {
        if (theAction instanceof ISelectionListener) {
            this.addWorkbenchSelectionListener((ISelectionListener)theAction);
            this.actionBars.setGlobalActionHandler(theAction.getId(), theAction);
        }
        if (theAction instanceof IResourceChangeListener) {
            this.addResourceChangeListener((IResourceChangeListener)theAction);
        }
        if (theAction instanceof IPartListener) {
            this.addPartListener((IPartListener)theAction);
        }
    }

    @Override
    public void removeAction(String theActionId) {
        CoreArgCheck.isNotNull((Object)theActionId);
        this.actionMap.remove(theActionId);
    }

    @Override
    public void removeResourceChangeListener(IResourceChangeListener theListener) {
        IWorkspace workspace = ModelerCore.getWorkspace();
        workspace.removeResourceChangeListener(theListener);
    }

    @Override
    public void removeWorkbenchSelectionListener(ISelectionListener theListener) {
        if (this.window == null) {
            throw new IllegalStateException(Util.getString("AbstractActionService.WorkbenchWindowIsNullMessage", new Object[0]));
        }
        ISelectionService service = this.window.getSelectionService();
        service.removeSelectionListener(theListener);
    }

    public void removePartListener(IPartListener theListener) {
        if (this.window == null) {
            throw new IllegalStateException(Util.getString("AbstractActionService.WorkbenchWindowIsNullMessage", new Object[0]));
        }
        this.window.getPartService().removePartListener(theListener);
    }

    @Override
    public void setWorkbenchWindow(IWorkbenchWindow theWindow) {
        this.window = theWindow;
    }

    @Override
    public void shutdown() {
        for (IAction action : this.actionMap.values()) {
            this.unregisterEventHandler(action);
            if (!(action instanceof AbstractAction)) continue;
            ((AbstractAction)action).dispose();
        }
    }

    protected void unregisterEventHandler(IAction theAction) {
        if (theAction instanceof ISelectionListener) {
            this.removeWorkbenchSelectionListener((ISelectionListener)theAction);
        }
        if (theAction instanceof IResourceChangeListener) {
            this.removeResourceChangeListener((IResourceChangeListener)theAction);
        }
    }
}

