/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editparts;

import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.adapters.ILabeledElement;
import org.eclipse.bpel.ui.adapters.IMarkerHolder;
import org.eclipse.bpel.ui.editparts.ActivityEditPart;
import org.eclipse.bpel.ui.editparts.borders.DrawerBorder;
import org.eclipse.bpel.ui.editparts.borders.LeafBorder;
import org.eclipse.bpel.ui.editparts.figures.GradientFigure;
import org.eclipse.bpel.ui.editparts.policies.BPELSelectionEditPolicy;
import org.eclipse.bpel.ui.editparts.util.BPELDecorationLayout;
import org.eclipse.bpel.ui.figures.CenteredConnectionAnchor;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.marker.BPELEditPartMarkerDecorator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPolicy;
import org.eclipse.swt.graphics.Image;

public class LeafEditPart
extends ActivityEditPart {
    protected Image image;
    protected Image topImage;
    protected Image bottomImage;
    protected Label imageLabel;
    protected Label nameLabel;
    protected LeafBorder border;
    protected IFigure contentFigure;
    protected BPELEditPartMarkerDecorator editPartMarkerDecorator;

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Selection Feedback", (EditPolicy)new BPELSelectionEditPolicy(false, true){

            @Override
            protected int getDrawerInset() {
                return 16;
            }

            @Override
            protected int getWestInset() {
                return 16;
            }

            @Override
            protected int getEastInset() {
                return 16;
            }

            @Override
            protected int getNorthInset() {
                return 0;
            }

            @Override
            protected int getSouthInset() {
                return 0;
            }
        });
    }

    @Override
    protected IFigure createFigure() {
        if (this.image == null) {
            ILabeledElement element = BPELUtil.adapt((Object)this.getActivity(), ILabeledElement.class);
            this.image = element.getSmallImage(this.getActivity());
        }
        GradientFigure gradient = new GradientFigure(this.getModel());
        FlowLayout layout = new FlowLayout();
        layout.setMinorAlignment(0);
        gradient.setLayoutManager((LayoutManager)layout);
        gradient.setForegroundColor(BPELUIPlugin.INSTANCE.getColorRegistry().get("COLOR_BLACK"));
        this.imageLabel = new Label(this.image);
        gradient.add((IFigure)this.imageLabel);
        this.nameLabel = new Label(this.getLabel());
        gradient.add((IFigure)this.nameLabel);
        this.contentFigure = gradient;
        if (this.editPartMarkerDecorator == null) {
            this.editPartMarkerDecorator = new BPELEditPartMarkerDecorator((EObject)this.getModel(), new LeafDecorationLayout());
            this.editPartMarkerDecorator.addMarkerMotionListener(this.getMarkerMotionListener());
        }
        IFigure result = this.editPartMarkerDecorator.createFigure((IFigure)gradient);
        this.border = new LeafBorder((IFigure)this.editPartMarkerDecorator.getDecorationLayer());
        this.border.setEditPart(this);
        gradient.setBorder((Border)this.border);
        gradient.addMouseMotionListener(this.getMouseMotionListener());
        this.refreshDrawerImages();
        return result;
    }

    protected void refreshDrawerImages() {
        if (this.topImage != null) {
            this.topImage.dispose();
            this.topImage = null;
        }
        if (this.bottomImage != null) {
            this.bottomImage.dispose();
            this.bottomImage = null;
        }
        IMarkerHolder holder = BPELUtil.adapt((Object)this.getActivity(), IMarkerHolder.class);
        int topMarkerPriority = Integer.MIN_VALUE;
        int bottomMarkerPriority = Integer.MIN_VALUE;
        IMarker topMarker = null;
        IMarker bottomMarker = null;
        IMarker[] iMarkerArray = holder.getMarkers(this.getActivity());
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (marker.getAttribute("org.eclipse.bpel.common.ui.uiModelMarker.visible", true)) {
                int priority;
                String value = marker.getAttribute("org.eclipse.bpel.common.ui.graphicalMarker.anchorPoint", EMPTY_STRING);
                if (value.equals("DRAWER_TOP")) {
                    priority = marker.getAttribute("org.eclipse.bpel.common.ui.uiModelMarker.priority", 0);
                    if (priority > topMarkerPriority) {
                        topMarkerPriority = priority;
                        this.topImage = BPELUtil.getImage(marker);
                        topMarker = marker;
                    }
                } else if (value.equals("DRAWER_BOTTOM") && (priority = marker.getAttribute("org.eclipse.bpel.common.ui.uiModelMarker.priority", 0)) > bottomMarkerPriority) {
                    bottomMarkerPriority = priority;
                    this.bottomImage = BPELUtil.getImage(marker);
                    bottomMarker = marker;
                }
            }
            ++n2;
        }
        this.border.setTopImage(this.topImage);
        this.border.setBottomImage(this.bottomImage);
        this.border.setTopMarker(topMarker);
        this.border.setBottomMarker(bottomMarker);
    }

    @Override
    public Label getLabelFigure() {
        return this.nameLabel;
    }

    @Override
    public String getLabelContent() {
        return this.getLabel();
    }

    @Override
    public void refreshVisuals() {
        this.refreshDrawerImages();
        super.refreshVisuals();
        this.nameLabel.setText(this.getLabel());
        this.editPartMarkerDecorator.refresh();
        this.getFigure().repaint();
    }

    protected String getLabel() {
        ILabeledElement element = BPELUtil.adapt((Object)this.getActivity(), ILabeledElement.class);
        return element.getLabel(this.getActivity());
    }

    protected void unregisterVisuals() {
        if (this.contentFigure != null) {
            this.contentFigure.removeMouseMotionListener(this.getMouseMotionListener());
        }
        if (this.editPartMarkerDecorator != null) {
            this.editPartMarkerDecorator.removeMarkerMotionListener(this.markerMotionListener);
        }
        this.image = null;
        this.editPartMarkerDecorator = null;
        this.topImage = null;
        this.bottomImage = null;
        super.unregisterVisuals();
    }

    @Override
    public ConnectionAnchor getConnectionAnchor(int location) {
        switch (location) {
            case 2: {
                return new CenteredConnectionAnchor(this.getFigure(), 6, 0);
            }
            case 3: {
                return new CenteredConnectionAnchor(this.getFigure(), 7, 0);
            }
        }
        return super.getConnectionAnchor(location);
    }

    public IFigure getContentPane() {
        return this.contentFigure;
    }

    @Override
    protected DrawerBorder getDrawerBorder() {
        return this.border;
    }

    public static class LeafDecorationLayout
    extends BPELDecorationLayout {
        protected Point calculateLocation(int locationHint, IFigure container, Dimension childDimension) {
            Point result = super.calculateLocation(locationHint, container, childDimension);
            if ((locationHint & 1) != 0) {
                result.x += 16;
            }
            if ((locationHint & 4) != 0) {
                result.x -= 16;
            }
            return result;
        }
    }
}

