/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.servicemix.core.bean;

import java.io.File;
import org.jboss.ide.eclipse.as.core.server.bean.AbstractCondition;
import org.jboss.ide.eclipse.as.core.server.bean.ICondition;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanType;

public class ServerBeanTypeServiceMix4x
extends ServerBeanType {
    protected static final String SMX4x_RELEASE_VERSION = "Bundle-Version";
    public static final String V4_5 = "4.5";
    public static final String V4_x = "4.";

    protected ServerBeanTypeServiceMix4x() {
        super("SMX4x", "Apache ServiceMix 4.x", "lib" + File.separator + "servicemix-version.jar", (ICondition)new ServiceMix4xServerTypeCondition());
    }

    public static class ServiceMix4xServerTypeCondition
    extends AbstractCondition {
        public boolean isServerRoot(File location) {
            return ServiceMix4xServerTypeCondition.checkServiceMixVersion(location, ServerBeanTypeServiceMix4x.SMX4x_RELEASE_VERSION, ServerBeanTypeServiceMix4x.V4_x);
        }

        protected static boolean checkServiceMixVersion(File location, String property, String propPrefix) {
            String mainFolder = new ServerBeanTypeServiceMix4x().getSystemJarPath();
            String value = ServerBeanTypeServiceMix4x.getJarProperty((File)new File(location + File.separator + mainFolder), (String)property);
            return value != null && value.startsWith(propPrefix);
        }

        public String getServerTypeId(String version) {
            if (version.equals(ServerBeanTypeServiceMix4x.V4_5)) {
                return "org.fusesource.ide.servicemix.server.45";
            }
            if (version.startsWith(ServerBeanTypeServiceMix4x.V4_x)) {
                return "org.fusesource.ide.servicemix.server.45";
            }
            return null;
        }
    }
}

