/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.util;

import java.lang.reflect.Field;
import java.sql.Types;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.ModelerCoreRuntimeException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlDatatypeAspect;
import org.teiid.designer.core.types.DatatypeConstants;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.metamodels.relational.RelationalPlugin;
import org.teiid.designer.metamodels.relational.SearchabilityType;
import org.teiid.designer.metamodels.relational.util.RelationalTypeMapping;
import org.teiid.designer.query.IQueryService;

public class RelationalTypeMappingImpl
implements RelationalTypeMapping {
    private static final Map<String, Integer> SQL_TYPE_MAPPING;
    private static RelationalTypeMapping instance;
    private final DatatypeManager datatypeManager;

    static {
        Field[] fields;
        SQL_TYPE_MAPPING = new HashMap<String, Integer>();
        Field[] fieldArray = fields = Types.class.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getType() == Integer.TYPE) {
                try {
                    SQL_TYPE_MAPPING.put(field.getName(), field.getInt(null));
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
    }

    public static RelationalTypeMapping getInstance() {
        if (instance == null) {
            instance = new RelationalTypeMappingImpl();
        }
        return instance;
    }

    protected static DatatypeManager getStandardDatatypeManager() {
        try {
            return ModelerCore.getWorkspaceDatatypeManager();
        }
        catch (ModelerCoreRuntimeException e) {
            RelationalPlugin.Util.log((Throwable)e);
            return null;
        }
    }

    public RelationalTypeMappingImpl() {
        this(RelationalTypeMappingImpl.getStandardDatatypeManager());
    }

    public RelationalTypeMappingImpl(DatatypeManager datatypeManager) {
        this.datatypeManager = datatypeManager;
        if (this.datatypeManager == null) {
            String msg = RelationalPlugin.Util.getString("RelationalTypeMapping.No_DatatypeManager", new Object[0]);
            RelationalPlugin.Util.log(4, msg);
        }
    }

    protected EObject findDatatype(String identifier) throws ModelerCoreException {
        EObject result = this.datatypeManager.getBuiltInDatatype(identifier);
        if (result == null) {
            result = this.datatypeManager.findDatatype(identifier);
        }
        return result;
    }

    protected String getIdentifier(EObject datatype) {
        CoreArgCheck.isNotNull((Object)datatype);
        SqlAspect sqlAspect = (SqlAspect)ModelerCore.getMetamodelRegistry().getMetamodelAspect(datatype, SqlAspect.class);
        if (sqlAspect == null) {
            return this.datatypeManager.getName(datatype);
        }
        if (sqlAspect instanceof SqlDatatypeAspect) {
            SqlDatatypeAspect datatypeAspect = (SqlDatatypeAspect)sqlAspect;
            String id = datatypeAspect.getDatatypeID(datatype);
            return id;
        }
        Object id = sqlAspect.getObjectID(datatype);
        if (id != null) {
            return id.toString();
        }
        return null;
    }

    @Override
    public EObject getDatatype(String jdbcTypeName) throws ModelerCoreException {
        Integer typeCode;
        EObject result = null;
        if (jdbcTypeName != null && (typeCode = SQL_TYPE_MAPPING.get(jdbcTypeName.toUpperCase())) != null) {
            result = this.getDatatype(typeCode);
        }
        if (result == null) {
            result = this.findDatatype("object");
        }
        return result;
    }

    @Override
    public EObject getDatatype(int jdbcType) throws ModelerCoreException {
        if (jdbcType == 2000) {
            return this.findDatatype("object");
        }
        IQueryService service = ModelerCore.getTeiidQueryService();
        String typeName = service.getJDBCSQLTypeName(jdbcType);
        String builtinName = DatatypeConstants.getDatatypeNamefromRuntimeType((String)typeName);
        if (builtinName == null || "object".equals(builtinName)) {
            return null;
        }
        return this.findDatatype(builtinName);
    }

    @Override
    public SearchabilityType getSearchabilityType(EObject datatype) {
        if (datatype == null) {
            return SearchabilityType.UNSEARCHABLE_LITERAL;
        }
        EObject dt = datatype;
        while (dt != null && !this.datatypeManager.isBuiltInDatatype(dt)) {
            EObject baseType = this.datatypeManager.getBaseType(dt);
            Object object = dt = this.datatypeManager.isSimpleDatatype(baseType) ? baseType : null;
        }
        String typeName = this.datatypeManager.getName(dt);
        if ("string".equals(typeName)) {
            return SearchabilityType.SEARCHABLE_LITERAL;
        }
        if ("char".equals(typeName)) {
            return SearchabilityType.SEARCHABLE_LITERAL;
        }
        if ("clob".equals(typeName)) {
            return SearchabilityType.LIKE_ONLY_LITERAL;
        }
        if ("blob".equals(typeName)) {
            return SearchabilityType.UNSEARCHABLE_LITERAL;
        }
        if ("XMLLiteral".equals(typeName)) {
            return SearchabilityType.UNSEARCHABLE_LITERAL;
        }
        if ("object".equals(typeName)) {
            return SearchabilityType.UNSEARCHABLE_LITERAL;
        }
        return SearchabilityType.ALL_EXCEPT_LIKE_LITERAL;
    }
}

