/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.aspects.validation.rules;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.sql.SqlProcedureAspect;
import org.teiid.designer.core.util.VdbHelper;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.ModelObjectExtensionAssistant;
import org.teiid.designer.metamodels.relational.DirectionKind;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.RelationalPlugin;
import org.teiid.designer.metamodels.relational.extension.RelationalModelExtensionConstants;

public class ProcedureFunctionRule
implements ObjectValidationRule {
    public void validate(EObject eObject, ValidationContext context) {
        ValidationProblemImpl problem;
        CoreArgCheck.isInstanceOf(Procedure.class, (Object)eObject);
        Procedure procedure = (Procedure)eObject;
        SqlProcedureAspect procAspect = (SqlProcedureAspect)AspectManager.getSqlAspect((EObject)eObject);
        if (!procedure.isFunction()) {
            return;
        }
        boolean isVirtual = procAspect.isVirtual(eObject);
        String javaClass = ProcedureFunctionRule.getJavaClass(procedure);
        String javaMethod = ProcedureFunctionRule.getJavaMethod(procedure);
        if (!(isVirtual || javaClass != null && !javaClass.trim().isEmpty() || javaMethod != null && !javaMethod.trim().isEmpty())) {
            return;
        }
        ValidationResultImpl result = new ValidationResultImpl((Object)eObject);
        this.validateReturnParameter(procedure, (ValidationResult)result);
        if (CoreStringUtil.isEmpty((String)javaClass)) {
            problem = new ValidationProblemImpl(0, 4, RelationalPlugin.Util.getString("ProcedureFunctionRule.javaClassNotSpecified", new Object[0]));
            result.addProblem((ValidationProblem)problem);
        } else {
            this.validateJavaIdentifier(javaClass, RelationalPlugin.Util.getString("ProcedureFunctionRule.javaClass", (Object)javaClass), true, (ValidationResult)result);
        }
        if (CoreStringUtil.isEmpty((String)javaMethod)) {
            problem = new ValidationProblemImpl(0, 4, RelationalPlugin.Util.getString("ProcedureFunctionRule.javaMethodNotSpecified", new Object[0]));
            result.addProblem((ValidationProblem)problem);
        } else {
            this.validateJavaIdentifier(javaMethod, RelationalPlugin.Util.getString("ProcedureFunctionRule.javaMethod", (Object)javaMethod), false, (ValidationResult)result);
        }
        this.validateUdfJarPath(procedure, (ValidationResult)result);
        String category = ProcedureFunctionRule.getFunctionCategory(procedure);
        if (CoreStringUtil.isEmpty((String)category)) {
            ValidationProblemImpl problem2 = new ValidationProblemImpl(0, 4, RelationalPlugin.Util.getString("ProcedureFunctionRule.categoryNotSpecified", new Object[0]));
            result.addProblem((ValidationProblem)problem2);
        }
        context.addResult((ValidationResult)result);
    }

    private final void validateUdfJarPath(Procedure proc, ValidationResult result) {
        String udfJarPath = ProcedureFunctionRule.getUdfJarPath(proc);
        if (udfJarPath != null) {
            if (CoreStringUtil.isEmpty((String)udfJarPath.trim())) {
                String message = RelationalPlugin.Util.getString("ProcedureFunctionRule.udfJarPathNotSet", new Object[0]);
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, message);
                result.addProblem((ValidationProblem)problem);
            } else {
                ModelResource resrc = ModelerCore.getModelWorkspace().findModelResource((EObject)proc);
                IProject project = resrc.getModelProject().getProject();
                IFolder libFolder = ProcedureFunctionRule.getUdfJarFolder(project);
                boolean found = ProcedureFunctionRule.isJarInFolder(libFolder, udfJarPath);
                if (!found) {
                    String message = RelationalPlugin.Util.getString("ProcedureFunctionRule.udfJarNotFound", (Object)udfJarPath);
                    ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, message);
                    result.addProblem((ValidationProblem)problem);
                }
            }
        }
    }

    public static String getJavaClass(Procedure proc) {
        String javaClass = null;
        ModelObjectExtensionAssistant assistant = (ModelObjectExtensionAssistant)ExtensionPlugin.getInstance().getRegistry().getModelExtensionAssistant(RelationalModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix());
        if (assistant != null) {
            try {
                javaClass = assistant.getPropertyValue((Object)proc, RelationalModelExtensionConstants.PropertyIds.JAVA_CLASS);
            }
            catch (Exception ex) {
                String msg = RelationalPlugin.Util.getString("ProcedureFunctionRule.errorGettingJavaClass", (Object)proc.getName());
                RelationalPlugin.Util.log(4, (Throwable)ex, msg);
            }
        }
        return javaClass;
    }

    public static String getJavaMethod(Procedure proc) {
        String javaMethod = null;
        ModelObjectExtensionAssistant assistant = (ModelObjectExtensionAssistant)ExtensionPlugin.getInstance().getRegistry().getModelExtensionAssistant(RelationalModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix());
        if (assistant != null) {
            try {
                javaMethod = assistant.getPropertyValue((Object)proc, RelationalModelExtensionConstants.PropertyIds.JAVA_METHOD);
            }
            catch (Exception ex) {
                String msg = RelationalPlugin.Util.getString("ProcedureFunctionRule.errorGettingJavaMethod", (Object)proc.getName());
                RelationalPlugin.Util.log(4, (Throwable)ex, msg);
            }
        }
        return javaMethod;
    }

    public static String getFunctionCategory(Procedure proc) {
        String javaMethod = null;
        ModelObjectExtensionAssistant assistant = (ModelObjectExtensionAssistant)ExtensionPlugin.getInstance().getRegistry().getModelExtensionAssistant(RelationalModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix());
        if (assistant != null) {
            try {
                javaMethod = assistant.getPropertyValue((Object)proc, RelationalModelExtensionConstants.PropertyIds.FUNCTION_CATEGORY);
            }
            catch (Exception ex) {
                String msg = RelationalPlugin.Util.getString("ProcedureFunctionRule.errorGettingFunctionCategory", (Object)proc.getName());
                RelationalPlugin.Util.log(4, (Throwable)ex, msg);
            }
        }
        return javaMethod;
    }

    public static String getUdfJarPath(Procedure proc) {
        String udfJarPath = null;
        ModelObjectExtensionAssistant assistant = (ModelObjectExtensionAssistant)ExtensionPlugin.getInstance().getRegistry().getModelExtensionAssistant(RelationalModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix());
        if (assistant != null) {
            try {
                udfJarPath = assistant.getPropertyValue((Object)proc, RelationalModelExtensionConstants.PropertyIds.UDF_JAR_PATH);
            }
            catch (Exception ex) {
                String msg = RelationalPlugin.Util.getString("ProcedureFunctionRule.errorGettingJarPath", (Object)proc.getName());
                RelationalPlugin.Util.log(4, (Throwable)ex, msg);
            }
        }
        return udfJarPath;
    }

    private final void validateReturnParameter(Procedure procedure, ValidationResult result) {
        EList params = procedure.getParameters();
        if (params.size() == 0) {
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, RelationalPlugin.Util.getString("ProcedureFunctionRule.returnParmeterIsRequired", new Object[0]));
            result.addProblem((ValidationProblem)problem);
            return;
        }
        ProcedureParameter returnParam = null;
        for (EObject param : params) {
            DirectionKind direction;
            int directionKind;
            if (!(param instanceof ProcedureParameter) || (directionKind = (direction = ((ProcedureParameter)param).getDirection()).getValue()) != 3) continue;
            returnParam = (ProcedureParameter)param;
            break;
        }
        if (returnParam == null) {
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, RelationalPlugin.Util.getString("ProcedureFunctionRule.returnParmeterIsRequired", new Object[0]));
            result.addProblem((ValidationProblem)problem);
            return;
        }
    }

    private final void validateJavaIdentifier(String identifier, String strName, boolean allowMultiple, ValidationResult result) {
        if (!CoreStringUtil.isEmpty((String)identifier)) {
            char firstChar = identifier.charAt(0);
            if (!Character.isJavaIdentifierStart(firstChar)) {
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, String.valueOf(strName) + RelationalPlugin.Util.getString("ProcedureFunctionRule.hasInvalidFirstChar", new Object[0]) + '\'' + firstChar + '\'');
                result.addProblem((ValidationProblem)problem);
            }
            int i = 1;
            while (i < identifier.length()) {
                char ch = identifier.charAt(i);
                if (!(Character.isJavaIdentifierPart(ch) || allowMultiple && ch == '.')) {
                    ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, String.valueOf(strName) + RelationalPlugin.Util.getString("ProcedureFunctionRule.hasInvalidChar", new Object[0]) + '\'' + ch + '\'');
                    result.addProblem((ValidationProblem)problem);
                }
                ++i;
            }
            if (identifier.charAt(identifier.length() - 1) == '.') {
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, String.valueOf(strName) + RelationalPlugin.Util.getString("ProcedureFunctionRule.cannotEndWithDot", new Object[0]));
                result.addProblem((ValidationProblem)problem);
            }
        }
    }

    public static IFolder getUdfJarFolder(IProject project) {
        IFolder libFolder = null;
        if (project != null) {
            IResource[] resources = null;
            try {
                resources = project.members();
            }
            catch (CoreException coreException) {
                return null;
            }
            if (resources != null) {
                int i = 0;
                while (i < resources.length) {
                    IResource theResc = resources[i];
                    if (theResc instanceof IFolder && VdbHelper.VdbFolders.UDF.getReadFolder().equalsIgnoreCase(((IFolder)theResc).getName())) {
                        libFolder = (IFolder)theResc;
                        break;
                    }
                    ++i;
                }
            }
        }
        return libFolder;
    }

    public static boolean isJarInFolder(IFolder folder, String jarFileName) {
        boolean found = false;
        if (folder != null) {
            try {
                IResource[] folderEntries = folder.members();
                int j = 0;
                while (j < folderEntries.length) {
                    IResource folderEntry = folderEntries[j];
                    if (folderEntry instanceof IFile && ((IFile)folderEntry).getProjectRelativePath().toString().equalsIgnoreCase(jarFileName)) {
                        found = true;
                        break;
                    }
                    ++j;
                }
            }
            catch (CoreException ex) {
                ModelerCore.Util.log(4, (Throwable)ex, RelationalPlugin.Util.getString("ProcedureFunctionRule.errorWithJarLookupInFolder", (Object)folder.getName()));
            }
        }
        return found;
    }
}

