/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.aspects.validation.rules;

import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.ColumnSet;
import org.teiid.designer.metamodels.relational.Index;
import org.teiid.designer.metamodels.relational.RelationalPlugin;
import org.teiid.designer.metamodels.relational.Table;

public class IndexReferenceOneTableRule
implements ObjectValidationRule {
    public void validate(EObject eObject, ValidationContext context) {
        CoreArgCheck.isInstanceOf(Index.class, (Object)eObject);
        int severity = 2;
        if (context.hasPreferences() && (severity = context.getPreferenceStatus("relationalPreferences.crossTableIndexes", severity)) == 0) {
            return;
        }
        Index index = (Index)eObject;
        EList columns = index.getColumns();
        HashSet<ColumnSet> referencedTables = new HashSet<ColumnSet>();
        for (Column column : columns) {
            ColumnSet table = column.getOwner();
            if (!(table instanceof Table)) continue;
            referencedTables.add(table);
        }
        if (referencedTables.size() > 1) {
            ValidationResultImpl result = new ValidationResultImpl((Object)eObject);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, severity, this.getValidationMsg(0, new Object[]{eObject}));
            result.addProblem((ValidationProblem)problem);
            context.addResult((ValidationResult)result);
        }
    }

    protected String getValidationMsg(int theCode, Object[] theParams) {
        return RelationalPlugin.Util.getString("IndexReferenceOneTableRule.Index_references_columns_from_more_than_one_table", new Object[0]);
    }
}

