/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.internal.extension.impl;

import com.google.common.base.Preconditions;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.conflict.IConflictDetector;
import org.eclipse.emf.compare.diff.IDiffEngine;
import org.eclipse.emf.compare.equi.IEquiEngine;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.internal.extension.IEMFCompareBuilderConfigurator;
import org.eclipse.emf.compare.rcp.internal.extension.impl.ItemUtil;
import org.eclipse.emf.compare.req.IReqEngine;

public class EMFCompareBuilderConfigurator
implements IEMFCompareBuilderConfigurator {
    private final IEclipsePreferences enginePreferences;
    private final IMatchEngine.Factory.Registry matchEngineFactoryRegistry;

    public EMFCompareBuilderConfigurator(IEclipsePreferences enginePreferences, IMatchEngine.Factory.Registry matchEngineFactoryRegistry) {
        Preconditions.checkNotNull((Object)enginePreferences);
        this.enginePreferences = enginePreferences;
        this.matchEngineFactoryRegistry = matchEngineFactoryRegistry;
    }

    public static EMFCompareBuilderConfigurator createDefault() {
        return new EMFCompareBuilderConfigurator(EMFCompareRCPPlugin.getDefault().getEMFComparePreferences(), EMFCompareRCPPlugin.getDefault().getMatchEngineFactoryRegistry());
    }

    private IDiffEngine getDiffEngine() {
        return ItemUtil.getItem(EMFCompareRCPPlugin.getDefault().getDiffEngineDescriptorRegistry(), "org.eclipse.emf.compare.preference.diff.engine", this.enginePreferences);
    }

    private IEquiEngine getEquiEngine() {
        return ItemUtil.getItem(EMFCompareRCPPlugin.getDefault().getEquiEngineDescriptorRegistry(), "org.eclipse.emf.compare.preference.equi.engine", this.enginePreferences);
    }

    private IReqEngine getReqEngine() {
        return ItemUtil.getItem(EMFCompareRCPPlugin.getDefault().getReqEngineDescriptorRegistry(), "org.eclipse.emf.compare.preference.req.engine", this.enginePreferences);
    }

    private IConflictDetector getConflictDetector() {
        return ItemUtil.getItem(EMFCompareRCPPlugin.getDefault().getConflictDetectorDescriptorRegistry(), "org.eclipse.emf.compare.preference.conflict.detector", this.enginePreferences);
    }

    public void configure(EMFCompare.Builder builder) {
        IEquiEngine equiEngine;
        IReqEngine reqEngine;
        IConflictDetector conflictDetector;
        IDiffEngine diffEngine;
        IMatchEngine.Factory.Registry matchEngineRegistry = this.matchEngineFactoryRegistry;
        if (matchEngineRegistry != null) {
            builder.setMatchEngineFactoryRegistry(matchEngineRegistry);
        }
        if ((diffEngine = this.getDiffEngine()) != null) {
            builder.setDiffEngine(diffEngine);
        }
        if ((conflictDetector = this.getConflictDetector()) != null) {
            builder.setConflictDetector(conflictDetector);
        }
        if ((reqEngine = this.getReqEngine()) != null) {
            builder.setRequirementEngine(reqEngine);
        }
        if ((equiEngine = this.getEquiEngine()) != null) {
            builder.setEquivalenceEngine(equiEngine);
        }
    }
}

