/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xsd.ui.editor;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.teiid.designer.ui.forms.ComponentCategory;
import org.teiid.designer.ui.forms.FormUtil;
import org.teiid.designer.xsd.ui.ModelerXsdUiPlugin;
import org.teiid.designer.xsd.ui.editor.FacetModel;
import org.teiid.designer.xsd.ui.editor.GUIFacetHelper;

public class SimpleDatatypeEditorPanel
extends Composite {
    private FormToolkit toolkit;
    private FacetModel mdl;

    public SimpleDatatypeEditorPanel(Composite parent) {
        super(parent, 0);
        this.initModel();
        this.initGUI();
    }

    private void initModel() {
        this.mdl = new FacetModel();
    }

    private void initGUI() {
        this.setLayoutData(new GridData(1808));
        this.setLayout((Layout)new FillLayout());
        Display display = this.getDisplay();
        this.toolkit = ModelerXsdUiPlugin.getDefault() != null ? ModelerXsdUiPlugin.getDefault().getFormToolkit(display) : new FormToolkit(display);
        FormUtil.tweakColors((FormToolkit)this.toolkit, (Display)display);
        ScrolledForm form = this.toolkit.createScrolledForm((Composite)this);
        ScrollBar bar = form.getHorizontalBar();
        if (bar != null) {
            bar.setIncrement(12);
            bar.setPageIncrement(60);
        }
        if ((bar = form.getVerticalBar()) != null) {
            bar.setIncrement(12);
            bar.setPageIncrement(60);
        }
        form.setLayoutData((Object)new GridData(1808));
        TableWrapLayout twl = new TableWrapLayout();
        form.getBody().setLayout((Layout)twl);
        form.setText(GUIFacetHelper.getString("SimpleDatatypeEditor.title"));
        ComponentCategory[] ccats = this.mdl.getCategories();
        int i = 0;
        while (i < ccats.length) {
            ComponentCategory category = ccats[i];
            Composite s = category.addFormControl(form, this.toolkit);
            TableWrapData twd = new TableWrapData(256, 128);
            s.setLayoutData((Object)twd);
            category.setEnabled(false);
            ++i;
        }
        form.reflow(true);
    }

    public void setReadOnly(boolean readOnly) {
        if (this.mdl.getSimpleType() == null) {
            readOnly = true;
        }
        if (readOnly != this.mdl.isReadOnly()) {
            this.mdl.setGUIReadOnly(readOnly);
        }
    }

    public XSDSimpleTypeDefinition getInput() {
        return this.mdl.getSimpleType();
    }

    public FacetModel getModel() {
        return this.mdl;
    }

    public void setSchema(XSDSchema schema) {
        this.mdl.setSchema(schema);
    }

    public void setInput(XSDSimpleTypeDefinition def) {
        this.mdl.setSimpleType(def);
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("Simple Datatypes Editor as a Form");
        shell.setLayout((Layout)new FillLayout());
        SimpleDatatypeEditorPanel ft = new SimpleDatatypeEditorPanel((Composite)shell);
        System.out.println((Object)ft);
        shell.setBounds(100, 100, 650, 550);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

