/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xsd.ui.editor;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.teiid.designer.ui.forms.ComponentSetEvent;
import org.teiid.designer.ui.forms.ComponentSetMonitor;
import org.teiid.designer.ui.forms.DialogProvider;
import org.teiid.designer.ui.forms.FormTextObjectEditor;
import org.teiid.designer.ui.forms.FormUtil;
import org.teiid.designer.ui.forms.LinkedComponentSet;
import org.teiid.designer.xsd.ui.editor.AbstractFacetSet;

public class FormTextFacetSet
extends AbstractFacetSet {
    FormTextObjectEditor fText;
    private final String addText;
    private final boolean valueClickable;
    private final DialogProvider dlp;

    public FormTextFacetSet(String id, String labelName, String addText, boolean valueClickable, DialogProvider provider) {
        super(id, labelName, true, false);
        this.addText = addText;
        this.valueClickable = valueClickable;
        this.dlp = provider;
    }

    @Override
    protected void addMainControl(Composite parent, FormToolkit ftk, ComponentSetMonitor mon) {
        this.fText = new DlgFTObjectEditor(this.addText, this.dlp.getLaunchButtonText(), this.valueClickable, this.dlp, mon);
        Control c = this.fText.addControl(FormUtil.getScrolledForm((Control)parent), parent, ftk);
        TableWrapData twd = new TableWrapData(256, 16);
        c.setLayoutData((Object)twd);
    }

    @Override
    protected void setMainValue(Object value) {
        if (this.fText != null) {
            this.fText.setValue(value);
        }
    }

    protected void valueClicked(Object value) {
    }

    @Override
    public void setEditible(boolean enabled) {
        super.setEditible(enabled);
        this.fText.getFormText().setEnabled(true);
        this.fText.setEditible(enabled);
    }

    private final class DlgFTObjectEditor
    extends FormTextObjectEditor {
        private final DialogProvider provider;
        private final ComponentSetMonitor mon;

        DlgFTObjectEditor(String addText, String changeText, boolean valueClickable, DialogProvider provider, ComponentSetMonitor mon) {
            super(addText, changeText, valueClickable);
            this.provider = provider;
            this.mon = mon;
        }

        protected Object changeValue(Object startingValue) {
            Object newVal;
            this.provider.showDialog(FormTextFacetSet.this.fText.getFormText().getShell(), startingValue);
            if (!this.provider.wasCancelled() && !FormUtil.safeEquals((Object)(newVal = this.provider.getValue()), (Object)startingValue)) {
                if (this.mon != null) {
                    this.mon.update(new ComponentSetEvent((LinkedComponentSet)FormTextFacetSet.this, newVal == null, newVal));
                }
                return newVal;
            }
            return startingValue;
        }

        protected void valueClicked(Object value) {
            FormTextFacetSet.this.valueClicked(value);
        }
    }
}

